---
generated_at: 2025-12-26 14:26:41
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/DeliverySlipAction.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/PickingOperationAction.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/LabelsAction.php`
- E-04: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/PackageAction.php`
- E-05: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/LocationResource.php`
- E-06: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/LotResource.php`
- E-07: `plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/PackageResource.php`
- E-08: `plugins/webkul/products/src/Filament/Resources/ProductResource.php`
- E-09: `plugins/webkul/products/src/Filament/Resources/PackagingResource.php`
- E-10: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/PrintRFQAction.php`
- E-11: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource/Pages/EditPurchaseAgreement.php`
- E-12: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/SendByEmailAction.php`
- E-13: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/PrintAndSendAction.php`
- E-14: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/PreviewAction.php`
- E-15: `plugins/webkul/support/src/Traits/PDFHandler.php`
- E-16: `plugins/webkul/inventories/resources/views/filament/clusters/operations/actions/print-delivery-slip.blade.php`
- E-17: `plugins/webkul/inventories/resources/views/filament/clusters/operations/actions/print-picking-operations.blade.php`
- E-18: `plugins/webkul/inventories/resources/views/filament/clusters/operations/actions/labels.blade.php`
- E-19: `plugins/webkul/inventories/resources/views/filament/clusters/products/packages/actions/print-with-content.blade.php`
- E-20: `plugins/webkul/inventories/resources/views/filament/clusters/products/packages/actions/print-without-content.blade.php`
- E-21: `plugins/webkul/products/resources/views/filament/resources/products/actions/print.blade.php`
- E-22: `plugins/webkul/sales/resources/views/sales/quotation.blade.php`
- E-23: `plugins/webkul/accounts/resources/views/invoice/actions/preview/index.blade.php`
- E-24: `plugins/webkul/purchases/resources/views/filament/admin/clusters/orders/orders/actions/print-quotation.blade.php`
- E-25: `plugins/webkul/purchases/resources/views/filament/admin/clusters/orders/purchase-agreements/print.blade.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 納品伝票 (Delivery Slip) - PDF帳票 | E-01, E-16 | ○ |
| C-02 | ピッキング作業書 (Picking Operations) - PDF帳票 | E-02, E-17 | ○ |
| C-03 | 製品ラベル (Labels) - 複数フォーマット対応 | E-03, E-18 | ○ |
| C-04 | パッケージ伝票 (Package) - PDF帳票 | E-04, E-19 | ○ |
| C-05 | ロケーションバーコード - PDF一括印刷 | E-05 | ○ |
| C-06 | ロットバーコード - PDF出力 | E-06 | ○ |
| C-07 | パッケージバーコード（内容なし） - PDF出力 | E-07, E-20 | ○ |
| C-08 | パッケージバーコード（内容あり） - PDF出力 | E-07, E-19 | ○ |
| C-09 | 製品バーコード - 複数フォーマット対応 | E-08, E-21 | ○ |
| C-10 | パッケージングバーコード - PDF出力 | E-09 | ○ |
| C-11 | 見積依頼書/発注書 - PDF出力 | E-10, E-24 | ○ |
| C-12 | 購買契約書 - PDF出力 | E-11, E-25 | ○ |
| C-13 | 見積書 (Sales Quotation) - PDF+メール送信 | E-12, E-22 | ○ |
| C-14 | 請求書 (Invoice) - PDF+メール送信 | E-13, E-15, E-23 | ○ |
| C-15 | 請求書プレビュー - プレビュー表示 | E-14, E-23 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての帳票について、ソースコードから直接確認できる根拠が存在するため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての帳票項目についてソースコード上で実装が確認できます。
- 注意点：
  - 帳票のテンプレート（blade.php）の詳細な内容までは確認していません。
  - 帳票の出力項目や書式については、bladeテンプレートの確認が推奨されます。

## 6) レビュアーチェックリスト（最小）
- [ ] 各帳票のBladeテンプレートを確認し、出力項目が要件を満たしているか検証する
- [ ] PDF生成ライブラリ（barryvdh/laravel-dompdf）の設定を確認する
- [ ] 各帳票の用紙サイズ・向き（A4、Portrait等）が要件と一致しているか確認する
- [ ] 日本語フォントのサポート状況を確認する（PDF生成時の文字化け対策）
- [ ] メール送信機能を持つ帳票（見積書、請求書）のメールテンプレートを確認する
