# 帳票設計書 1-納品伝票 (Delivery Slip)

## 概要

本ドキュメントは、在庫管理システムにおける納品伝票（Delivery Slip）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

納品伝票は、出荷・配送時に顧客へ渡す納品情報を記載したPDF帳票であり、出荷先情報、製品明細、数量等の情報を一覧形式で出力する機能を提供する。

**業務上の目的・背景**：納品伝票は、出荷業務において商品の配送内容を顧客に明示するための重要な帳票である。配送ドライバーが顧客に商品を引き渡す際の確認書類として使用され、納品物の内容と数量を双方で確認することで、配送ミスや数量相違のトラブルを防止する。また、顧客側の検収作業における照合資料としても活用される。

**帳票の利用シーン**：出荷作業完了後、配送担当者が顧客への納品時に使用する。倉庫での出荷検品後に印刷し、商品に同梱または配送員が携帯する。顧客は納品時にこの伝票と実際の商品を照合し、受領確認を行う。

**主要な出力内容**：
1. 出荷元会社情報（会社名、住所、連絡先）
2. 配送先情報（顧客名、住所、連絡先）
3. 納品伝票番号と出荷予定日
4. 製品明細（製品名、ロット/シリアル番号、数量、単位）
5. 検収時の注意事項

**帳票の出力タイミング**：在庫オペレーション（Delivery）画面から「Delivery Slip」ボタンをクリックした際にPDFとしてダウンロードされる。

**帳票の利用者**：出荷担当者、配送担当者、顧客（検収担当）

## 帳票種別

納品書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-001 | 在庫オペレーション詳細画面 | /inventories/operations/deliveries/{id} | 「Delivery Slip」ボタンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Delivery Slip-{オペレーション名}.pdf（スラッシュはアンダースコアに変換） |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票は出荷元情報ヘッダー、配送先情報、伝票タイトル、詳細情報、製品明細テーブル、注意事項フッターの構成となる。複数オペレーションを一括出力する場合は、各オペレーションごとにページ分割される。

```
+-----------------------------------------------+
|              出荷元会社情報                    |
|   (会社名、住所、Email、電話番号)              |
+-----------------------------------------------+
|                        |    配送先情報         |
|                        | (顧客名、住所、連絡先)|
+-----------------------------------------------+
|     Delivery Slip #{伝票番号}                  |
+-----------------------------------------------+
|     Shipping Date: {出荷予定日}                |
+-----------------------------------------------+
| Product | Lot/Serial Number | Quantity        |
|---------|-------------------|-----------------|
| 製品1   | LOT001           | 10 Units        |
| 製品2   | LOT002           | 5 Units         |
+-----------------------------------------------+
|   注意事項メッセージ                           |
+-----------------------------------------------+
```

### ヘッダー部（出荷元会社情報）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 会社名 | 出荷元会社の名称 | Operation.company.name | テキスト（28px、青色） |
| 2 | 住所1 | 会社の住所（番地） | Operation.company.partner.street1 | テキスト |
| 3 | 住所2 | 会社の住所（建物等） | Operation.company.partner.street2 | テキスト（存在する場合のみ） |
| 4 | 市区町村 | 市区町村名 | Operation.company.partner.city | テキスト |
| 5 | 都道府県 | 都道府県名 | Operation.company.partner.state.name | テキスト（存在する場合のみ） |
| 6 | 郵便番号 | 郵便番号 | Operation.company.partner.zip | テキスト |
| 7 | 国名 | 国名 | Operation.company.partner.country.name | テキスト（存在する場合のみ） |
| 8 | Email | 会社のメールアドレス | Operation.company.email | テキスト（存在する場合のみ） |
| 9 | 電話番号 | 会社の電話番号 | Operation.company.phone | テキスト（存在する場合のみ） |

### 配送先情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | セクションタイトル | 「Delivery Address」固定文字列 | - | 太字 |
| 2 | 顧客名 | 配送先顧客の名前 | Operation.partner.name | テキスト |
| 3 | 住所1 | 配送先住所（番地） | Operation.partner.street1 | テキスト |
| 4 | 住所2 | 配送先住所（建物等） | Operation.partner.street2 | テキスト（存在する場合のみ） |
| 5 | 市区町村 | 市区町村名 | Operation.partner.city | テキスト |
| 6 | 都道府県 | 都道府県名 | Operation.partner.state.name | テキスト（存在する場合のみ） |
| 7 | 郵便番号 | 郵便番号 | Operation.partner.zip | テキスト |
| 8 | 国名 | 国名 | Operation.partner.country.name | テキスト（存在する場合のみ） |
| 9 | Email | 顧客のメールアドレス | Operation.partner.email | テキスト（存在する場合のみ） |
| 10 | 電話番号 | 顧客の電話番号 | Operation.partner.phone | テキスト（存在する場合のみ） |

### 伝票タイトル部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 伝票タイトル | 「Delivery Slip #」+オペレーション名 | Operation.name | 24px、青色、下線付き |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 出荷予定日 | 出荷予定日時 | Operation.scheduled_at | 日時形式 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Product | 製品名 | MoveLine.product.name | テキスト | 自動 |
| 2 | Lot/Serial Number | ロット/シリアル番号 | MoveLine.lot.name | テキスト（条件付き表示） | 自動 |
| 3 | Quantity | 数量と単位 | MoveLine.qty + MoveLine.uom.name | 数値（カンマ区切り） + 単位名 | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 注意事項 | 検収時の注意メッセージ | 固定文字列 | 中央揃え、グレー文字、0.9em |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| オペレーションID | 出力対象のOperation.id | Yes |
| moveLines | オペレーションに紐づくMoveLine一覧 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | MoveLine.id | 昇順（デフォルト） |

### 改ページ条件

複数オペレーションを出力する場合、各オペレーションごとにページブレークが発生する（page-break-after: always）。最終オペレーションでは改ページしない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_operations | オペレーション基本情報 | 主テーブル |
| inventories_move_lines | 製品明細情報 | operation_id = inventories_operations.id |
| products_products | 製品マスタ | inventories_move_lines.product_id = id |
| inventories_lots | ロット情報 | inventories_move_lines.lot_id = id |
| support_uoms | 単位マスタ | inventories_move_lines.uom_id = id |
| support_companies | 会社情報 | inventories_operations.company_id = id |
| partners_partners | パートナー（顧客/配送先） | inventories_operations.partner_id = id |
| partners_partners | 会社パートナー | support_companies.partner_id = id |
| support_states | 都道府県 | partners_partners.state_id = id |
| support_countries | 国 | partners_partners.country_id = id |

### テーブル別参照項目詳細

#### inventories_operations

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 伝票番号 | id指定 | WH/OUT/XXX形式 |
| scheduled_at | 出荷予定日 | - | datetime型 |
| company_id | 会社情報取得用 | - | FK |
| partner_id | 配送先情報取得用 | - | FK |

#### inventories_move_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | 製品情報取得用 | operation_id一致 | FK |
| qty | 数量 | - | decimal型 |
| uom_id | 単位情報取得用 | - | FK |
| lot_id | ロット情報取得用 | - | FK（nullable） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(qty) | 整数表示 | カンマ区切り |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Delivery Slipボタンクリック] --> B[DeliverySlipAction実行]
    B --> C[Operation recordsをViewに渡す]
    C --> D[Blade templateでHTML生成]
    D --> E[DomPDFでPDF変換]
    E --> F[用紙サイズA4縦設定]
    F --> G[streamDownloadでファイル返却]
    G --> H[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | moveLinesが空 | テーブル非表示 | テーブル部分をスキップして出力 |
| 会社情報なし | company.partnerがnull | 会社住所部分非表示 | 会社名のみ表示 |
| 配送先なし | partnerがnull | 配送先セクション非表示 | 配送先セクションをスキップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1オペレーションあたり明細100件程度 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- 顧客の個人情報（住所、電話番号、メールアドレス）を含むため、アクセス権限を持つユーザーのみが出力可能
- PDF出力時のログ記録は実装されていない（必要に応じて監査ログの追加を検討）
- 出力されたPDFにはパスワード保護や印刷制限は設定されていない

## 備考

- ロット/シリアル番号列の表示は、TraceabilitySettings.enable_lots_serial_numbersおよびdisplay_on_delivery_slips設定が有効な場合のみ表示される
- 複数オペレーションの一括出力に対応しているが、現在のUIでは単一オペレーションのみを対象としている
- ファイル名のスラッシュはアンダースコアに自動変換される（例：WH/OUT/1 → WH_OUT_1）
