# 帳票設計書 10-パッケージングバーコード (Packaging Barcode)

## 概要

本ドキュメントは、製品管理システムにおけるパッケージングバーコード（Packaging Barcode）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

パッケージングバーコードは、製品のパッケージング単位（まとめ売り単位など）のバーコードラベルをPDF形式で出力する機能であり、選択した複数のパッケージング情報をまとめてラベル印刷できる。

**業務上の目的・背景**：パッケージングバーコードは、製品のまとめ売り単位（6本パック、12個入りケースなど）を識別するためのラベルである。店頭での販売単位やケース単位での在庫管理において、個別製品とは別のバーコードで管理することで、効率的な商品管理と販売が可能となる。

**帳票の利用シーン**：パッケージング製品のラベル印刷、まとめ売り商品の識別ラベル発行、ケース単位での在庫管理用ラベル印刷で使用する。

**主要な出力内容**：
1. パッケージング名
2. 製品名
3. 数量（パッケージングに含まれる製品数と単位）
4. バーコード（パッケージングのバーコード）
5. バーコードテキスト

**帳票の出力タイミング**：パッケージング一覧画面で複数のパッケージングを選択し、一括アクションの「Print」を実行した際にPDFとしてダウンロードされる。

**帳票の利用者**：製品管理担当者、店舗スタッフ、倉庫作業者

## 帳票種別

ラベル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| PRD-002 | パッケージング一覧画面 | /packagings | 複数選択 → 一括アクション「Print」 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Packaging-Barcode.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票はテーブル形式で複数のラベルを3列で配置する構成となる。各セルにパッケージング名、製品名、数量、バーコードが表示される。

```
+--------------+--------------+--------------+
| PKG-6PACK    | PKG-12CASE   | PKG-BOX      |
| Product A    | Product B    | Product C    |
| Qty: 6 Unit  | Qty: 12 Pcs  | Qty: 24 Item |
| [barcode]    | [barcode]    | [barcode]    |
| BC001        | BC002        | BC003        |
+--------------+--------------+--------------+
| PKG-BUNDLE   | PKG-SET      |              |
| Product D    | Product E    |              |
| Qty: 3 Set   | Qty: 5 Pack  |              |
| [barcode]    | [barcode]    |              |
| BC004        | BC005        |              |
+--------------+--------------+--------------+
```

### ラベルセル構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | パッケージング名 | パッケージングの識別名 | Packaging.name | テキスト（14px、青色、太字） |
| 2 | 製品名 | 紐づく製品の名称 | Packaging.product.name | テキスト（11px、グレー） |
| 3 | 数量 | パッケージング内の数量と単位 | Packaging.qty + Packaging.product.uom.name | テキスト（11px、グレー） |
| 4 | バーコード | パッケージングのバーコード | Packaging.barcode | Code128形式、スケール1、高さ30px（存在する場合のみ） |
| 5 | バーコードテキスト | バーコード値のテキスト表示 | Packaging.barcode | テキスト（12px） |

### テーブル仕様

| 項目 | 内容 |
|-----|------|
| 列数 | 3列 |
| セル幅 | 33%（均等分割） |
| セル境界線 | 1px solid #e9ecef |
| セル背景色 | 白 |
| セルパディング | 12px |
| 空セル | 境界線なし、背景透明（パッケージング数が3の倍数でない場合） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パッケージングID | 選択されたPackaging.idの配列 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 選択順 | - |

### データ分割

| 条件 | 説明 |
|-----|------|
| chunk(3) | 3件ずつグループ化してテーブル行を生成 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| products_packagings | パッケージング情報 | 主テーブル |
| products_products | 製品情報 | products_packagings.product_id = id |
| support_uoms | 単位マスタ | products_products.uom_id = id |

### テーブル別参照項目詳細

#### products_packagings

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | パッケージング名 | 選択されたid | テキスト |
| barcode | バーコード値 | - | テキスト（nullable） |
| qty | 数量 | - | decimal型 |
| product_id | 製品情報取得用 | - | FK |

#### products_products

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 製品名 | packaging.product_id一致 | テキスト |
| uom_id | 単位情報取得用 | - | FK |

#### support_uoms

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 単位名 | product.uom_id一致 | テキスト |

## 計算仕様

### 計算項目一覧

本帳票には計算項目は存在しない（数量はそのまま表示）。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[パッケージング一覧画面] --> B[複数パッケージング選択]
    B --> C[一括アクション「Print」クリック]
    C --> D[BulkAction実行]
    D --> E[選択レコード取得]
    E --> F[Blade templateでHTML生成]
    F --> G[3件ずつchunk処理]
    G --> H[各chunkでテーブル行生成]
    H --> I[パッケージング名表示]
    I --> J[製品名表示]
    J --> K[数量・単位表示]
    K --> L{barcode存在?}
    L -->|Yes| M[バーコード生成: DNS1D::getBarcodeHTML]
    L -->|No| N[バーコードスキップ]
    M --> O[DomPDFでPDF変換]
    N --> O
    O --> P[用紙サイズA4縦設定]
    P --> Q[streamDownloadでファイル返却]
    Q --> R[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 選択レコードが0件 | 空のPDF生成 | 空のテーブルを出力 |
| バーコードなし | barcodeがnull | バーコード非表示 | バーコード部分を空白で表示 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回の出力で最大100件程度 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- パッケージング情報は製品管理に関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- ラベルには個人情報は含まれない
- PDF出力時のログ記録は実装されていない

## 備考

- 本帳票はパッケージング一覧画面のBulkAction（一括アクション）として実装されている
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- パッケージングのbarcode項目がnullの場合、バーコード部分は非表示となる
- 3列構成のため、選択したパッケージング数が3の倍数でない場合、最終行の余りセルは空（境界線なし、背景透明）となる
- ファイル名は「Packaging-Barcode.pdf」固定で、選択したパッケージングに依存しない
- パッケージングには必ず製品（product）が紐づいているため、製品名と単位は常に表示される
- パッケージング一覧画面はProductResource内のRelationManagerとして実装されている可能性がある
