# 帳票設計書 11-見積依頼書/発注書 (RFQ/Purchase Order)

## 概要

本ドキュメントは、購買管理モジュールにおける見積依頼書（RFQ: Request for Quotation）および発注書（Purchase Order）のPDF帳票出力機能について、その仕様と設計を定義するものである。

### 本帳票の処理概要

この帳票は、購買担当者がサプライヤーに対して見積依頼や発注を行う際に使用するPDF形式の帳票を生成・出力する機能を提供する。状態が「下書き(draft)」または「送信済(sent)」の注文データに対してのみ出力可能であり、出力時に注文状態が自動的に「送信済(SENT)」に更新される。

**業務上の目的・背景**：この帳票は、購買プロセスにおける正式な見積依頼や発注の文書化を実現する。サプライヤーとの取引において法的・商業的に有効な文書として機能し、注文内容の明確化、誤解の防止、および取引記録の保管に貢献する。また、帳票出力により注文が「送信済」状態に遷移することで、購買ワークフローの進行状況を管理できる。

**帳票の利用シーン**：新規仕入先への見積依頼時、定期発注の確認時、サプライヤーとの価格交渉時、購買契約に基づく発注実行時、FAX・メール添付用の正式文書が必要な場合に利用される。

**主要な出力内容**：
1. 自社会社情報（会社名、住所、連絡先）
2. サプライヤー情報（仕入先名、住所、連絡先）
3. 見積依頼番号/発注番号
4. 注文明細（製品名、予定日、数量、単位）
5. 見積有効期限

**帳票の出力タイミング**：購買注文の編集画面において、ユーザーが「Print RFQ」ボタンをクリックした際にPDFが生成・ダウンロードされる。

**帳票の利用者**：購買担当者、調達マネージャー、経理担当者

## 帳票種別

見積依頼書 / 発注書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| PO-001 | 購買注文編集画面 | /admin/purchases/orders/{record}/edit | Print RFQボタン押下 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦 (portrait) |
| ファイル名 | Purchase Order-{注文番号(スラッシュをアンダースコアに置換)}.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票は大きく4つの構成要素から成る：ヘッダー部（自社・サプライヤー情報）、見積依頼番号表示部、明細テーブル部、およびフッター部（有効期限・注記）。

```
┌─────────────────────────────────────┐
│  自社会社情報    │  サプライヤー情報  │
│  (左寄せ)       │  (右寄せ)        │
├─────────────────────────────────────┤
│  Request for Quotation #{番号}      │
├─────────────────────────────────────┤
│  ┌─────────────────────────────────┐│
│  │ Description | Expected | Qty   ││
│  │             | Date     |       ││
│  ├─────────────────────────────────┤│
│  │ 製品名1     | 日付1    | 数量1 ││
│  │ 製品名2     | 日付2    | 数量2 ││
│  └─────────────────────────────────┘│
├─────────────────────────────────────┤
│  Quotation Valid Until: {日付}      │
│  注記                               │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 会社名 | 発注元会社名 | purchases_orders.company → companies.name | テキスト(28px) |
| 2 | 住所1 | 会社住所1行目 | companies.partner → partners.street1 | テキスト |
| 3 | 住所2 | 会社住所2行目 | companies.partner → partners.street2 | テキスト（オプション） |
| 4 | 市区町村 | 市区町村名 | partners.city | テキスト |
| 5 | 都道府県 | 都道府県名 | partners.state → states.name | テキスト（オプション） |
| 6 | 郵便番号 | 郵便番号 | partners.zip | テキスト |
| 7 | 国名 | 国名 | partners.country → countries.name | テキスト（オプション） |
| 8 | メール | 会社メールアドレス | companies.email | テキスト（オプション） |
| 9 | 電話番号 | 会社電話番号 | companies.phone | テキスト（オプション） |
| 10 | サプライヤー名 | 仕入先名 | purchases_orders.partner → partners.name | テキスト |
| 11 | サプライヤー住所 | 仕入先住所情報 | partners.street1, street2, city, state, zip, country | テキスト |
| 12 | サプライヤーEmail | 仕入先メール | partners.email | テキスト（オプション） |
| 13 | サプライヤー電話 | 仕入先電話番号 | partners.phone | テキスト（オプション） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Description | 製品説明/名称 | purchases_order_lines.name | テキスト | - |
| 2 | Expected Date | 予定到着日 | purchases_order_lines.planned_at | 日付 | - |
| 3 | Quantity | 数量と単位 | purchases_order_lines.product_qty + uoms.name | 数値 + テキスト | - |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 見積有効期限 | 見積の有効期限日 | purchases_orders.valid_until | 日付（オプション） |
| 2 | 注記 | 固定メッセージ | 固定テキスト | "We look forward to your response..." |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 注文状態 | state が 'draft' または 'sent' のレコードのみ | Yes |
| 注文ID | 指定された購買注文レコード | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 明細行の登録順 | 昇順 |

### 改ページ条件

各注文レコードで改ページ（page-break-after: always）。最後のレコードは改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| purchases_orders | 購買注文マスタ | 主テーブル |
| purchases_order_lines | 注文明細 | order_id = purchases_orders.id |
| companies | 会社情報 | company_id = companies.id |
| partners | パートナー（サプライヤー/会社住所） | partner_id = partners.id |
| states | 都道府県 | state_id = states.id |
| countries | 国 | country_id = countries.id |
| uoms | 単位 | uom_id = uoms.id |

### テーブル別参照項目詳細

#### purchases_orders

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 見積依頼番号 | id指定 | "PO/{id}" 形式 |
| state | 表示判定 | draft または sent | Enum: OrderState |
| valid_until | 見積有効期限 | - | nullable |
| partner_id | サプライヤー | FK | - |
| company_id | 会社 | FK | - |

#### purchases_order_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | Description | order_id = ? | 製品名/説明 |
| planned_at | Expected Date | - | datetime型 |
| product_qty | Quantity | - | 数量 |
| uom_id | 単位 | FK | UOMリレーション |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | product_qty + ' ' + uom.name | - | 文字列結合 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Print RFQボタン押下] --> B[アクション実行]
    B --> C[PDFビュー読み込み]
    C --> D[DomPDF生成]
    D --> E[A4縦に設定]
    E --> F[注文状態をSENTに更新]
    F --> G[PurchaseOrder計算実行]
    G --> H[フォーム更新]
    H --> I[streamDownloadでPDF返却]
    I --> J[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ボタン非表示 | 状態がdraft/sent以外 | - | ボタンが表示されない |
| データなし | 注文明細が空 | - | 明細テーブルが表示されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1注文あたり1〜50明細行 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（単一注文出力） |

## セキュリティ考慮事項

- 購買注文へのアクセス権限を持つユーザーのみが帳票出力可能
- Filament Resourceのcan権限によるアクセス制御
- 出力ログは購買注文の状態変更履歴（SENT状態への変更）として記録

## 備考

- PDF生成にはbarryvdh/laravel-dompdfパッケージを使用
- Bladeテンプレート: `purchases::filament.admin.clusters.orders.orders.actions.print-quotation`
- 出力時に注文状態が自動的にOrderState::SENTに更新される
- PurchaseOrder::computePurchaseOrderによる計算処理が出力時に実行される
