# 帳票設計書 12-購買契約書 (Purchase Agreement)

## 概要

本ドキュメントは、購買管理モジュールにおける購買契約書（Purchase Agreement）のPDF帳票出力機能について、その仕様と設計を定義するものである。

### 本帳票の処理概要

この帳票は、サプライヤーとの間で締結する購買契約（包括注文またはテンプレート）の内容をPDF形式で出力する機能を提供する。契約タイプに応じて「Blanket Order」または「Purchase Agreement」としてタイトルが変化し、契約期間、担当者、製品リスト、支払条件などの契約詳細が含まれる。

**業務上の目的・背景**：この帳票は、サプライヤーとの長期的な取引関係を文書化し、価格・数量・期間などの合意事項を明確化するために使用される。包括注文（Blanket Order）は一定期間内に複数回の発注を行う際のマスター契約として機能し、購買テンプレートは標準的な購買条件を定義する。法的拘束力のある契約書として、両者間の取引条件を明文化する重要な文書である。

**帳票の利用シーン**：新規サプライヤーとの包括契約締結時、既存契約の更新時、価格交渉後の合意内容確認時、年間契約の締結時、法務部門への提出用文書作成時に利用される。

**主要な出力内容**：
1. 自社会社情報（会社名、住所、連絡先）
2. サプライヤー情報（仕入先名、住所、連絡先）
3. 契約番号（Blanket Order/Purchase Agreement）
4. 契約有効期間、担当者、参照番号
5. 製品リスト（製品名、数量、単位、単価）
6. 支払条件および追加条項

**帳票の出力タイミング**：購買契約編集画面において、ユーザーがプリンターアイコンの「Print」ボタンをクリックした際にPDFが生成・ダウンロードされる。

**帳票の利用者**：購買担当者、調達マネージャー、法務担当者、経理担当者

## 帳票種別

契約書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| PA-001 | 購買契約編集画面 | /admin/purchases/orders/purchase-agreements/{record}/edit | Printボタン押下 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦 (portrait) |
| ファイル名 | Purchase Agreement-{契約番号(スラッシュをアンダースコアに置換)}.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票は大きく5つの構成要素から成る：ヘッダー部（自社・サプライヤー情報）、契約タイトル部、詳細情報テーブル、製品明細テーブル、および条件・注記部。

```
┌─────────────────────────────────────┐
│  自社会社情報    │  サプライヤー情報  │
│  (左寄せ)       │  (右寄せ)        │
├─────────────────────────────────────┤
│  Blanket Order / Purchase Agreement │
│  #{契約番号}                        │
├─────────────────────────────────────┤
│  有効期限 │ 担当者 │ 参照番号       │
├─────────────────────────────────────┤
│  ┌─────────────────────────────────┐│
│  │ Product │ Qty │ Unit │ Price   ││
│  ├─────────────────────────────────┤│
│  │ 製品1   │ 100 │ 個   │ 1000.00 ││
│  └─────────────────────────────────┘│
├─────────────────────────────────────┤
│  Terms & Conditions                 │
│  - Payment Terms                    │
│  - Additional Terms                 │
├─────────────────────────────────────┤
│  注記                               │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 会社名 | 発注元会社名 | purchases_requisitions.company → companies.name | テキスト(28px) |
| 2 | 住所1 | 会社住所1行目 | companies.partner → partners.street1 | テキスト |
| 3 | 住所2 | 会社住所2行目 | companies.partner → partners.street2 | テキスト（オプション） |
| 4 | 市区町村 | 市区町村名 | partners.city | テキスト |
| 5 | 都道府県 | 都道府県名 | partners.state → states.name | テキスト（オプション） |
| 6 | 郵便番号 | 郵便番号 | partners.zip | テキスト |
| 7 | 国名 | 国名 | partners.country → countries.name | テキスト（オプション） |
| 8 | メール | 会社メールアドレス | companies.email | テキスト（オプション） |
| 9 | 電話番号 | 会社電話番号 | companies.phone | テキスト（オプション） |
| 10 | サプライヤー名 | 仕入先名 | purchases_requisitions.partner → partners.name | テキスト |
| 11 | サプライヤー住所 | 仕入先住所情報 | partners.street1, street2, city, state, zip, country | テキスト |
| 12 | サプライヤーEmail | 仕入先メール | partners.email | テキスト（オプション） |
| 13 | サプライヤー電話 | 仕入先電話番号 | partners.phone | テキスト（オプション） |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Agreement Validity | 契約有効期限 | purchases_requisitions.ends_at | 日付（オプション） |
| 2 | Contact | 担当者名 | purchases_requisitions.user → users.name | テキスト（オプション） |
| 3 | Reference | 参照番号 | purchases_requisitions.reference | テキスト（オプション） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Product | 製品名 | purchases_requisition_lines.product → products.name | テキスト | - |
| 2 | Quantity | 数量 | purchases_requisition_lines.qty | 数値（カンマ区切り） | - |
| 3 | Unit | 単位 | products.uom → uoms.name | テキスト（オプション） | - |
| 4 | Unit Price | 単価 | purchases_requisition_lines.price_unit | 数値（小数点2桁） | - |

### フッター部（条件セクション）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Terms & Conditions | セクションタイトル | 固定テキスト | 太字 |
| 2 | Payment Terms | 支払条件 | purchases_requisitions.paymentTerm → payment_terms.name | テキスト（オプション） |
| 3 | Additional Terms | 追加条項 | purchases_requisitions.notes | テキスト（オプション） |
| 4 | 注記 | 固定メッセージ | 固定テキスト | "This agreement constitutes..." |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 契約ID | 指定された購買契約レコード | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 明細行の登録順 | 昇順 |

### 改ページ条件

各契約レコードで改ページ（page-break-after: always）。最後のレコードは改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| purchases_requisitions | 購買契約マスタ | 主テーブル |
| purchases_requisition_lines | 契約明細 | requisition_id = purchases_requisitions.id |
| companies | 会社情報 | company_id = companies.id |
| partners | パートナー（サプライヤー/会社住所） | partner_id = partners.id |
| users | ユーザー（担当者） | user_id = users.id |
| products | 製品 | product_id = products.id |
| uoms | 単位 | uom_id = uoms.id |
| payment_terms | 支払条件 | payment_term_id = payment_terms.id |
| states | 都道府県 | state_id = states.id |
| countries | 国 | country_id = countries.id |

### テーブル別参照項目詳細

#### purchases_requisitions

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 契約番号 | id指定 | "BO/{id}" または "PT/{id}" 形式 |
| type | タイトル判定 | - | Enum: RequisitionType |
| ends_at | Agreement Validity | - | nullable |
| reference | Reference | - | nullable |
| notes | Additional Terms | - | nullable |
| user_id | Contact | FK | 担当者 |
| partner_id | サプライヤー | FK | - |
| company_id | 会社 | FK | - |
| payment_term_id | Payment Terms | FK | nullable |

#### purchases_requisition_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | Product | requisition_id = ? | FK |
| qty | Quantity | - | 数量 |
| price_unit | Unit Price | - | 単価 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(qty) | 整数 | カンマ区切り |
| 単価表示 | number_format(price_unit, 2) | 小数点2桁 | カンマ区切り |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Printボタン押下] --> B[アクション実行]
    B --> C[PDFビュー読み込み]
    C --> D[DomPDF生成]
    D --> E[A4縦に設定]
    E --> F[streamDownloadでPDF返却]
    F --> G[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 契約明細が空 | - | 明細テーブルが表示されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1契約あたり1〜100製品行 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（単一契約出力） |

## セキュリティ考慮事項

- 購買契約へのアクセス権限を持つユーザーのみが帳票出力可能
- Filament Resourceのcan権限によるアクセス制御
- 契約情報は機密性が高いため、アクセスログの記録を推奨

## 備考

- PDF生成にはbarryvdh/laravel-dompdfパッケージを使用
- Bladeテンプレート: `purchases::filament.admin.clusters.orders.purchase-agreements.print`
- 契約タイプ（type）が'blanket_order'の場合は「Blanket Order」、それ以外は「Purchase Agreement」としてタイトル表示
- Printボタンはヘッダーアクションとして配置（プリンターアイコン付き）
- UOM表示は設定（ProductSettings::enable_uom）により表示/非表示が切り替わる
