# 帳票設計書 13-見積書 (Sales Quotation)

## 概要

本ドキュメントは、販売管理モジュールにおける見積書（Sales Quotation）のPDF帳票出力およびメール送信機能について、その仕様と設計を定義するものである。

### 本帳票の処理概要

この帳票は、顧客に対して販売見積書をPDF形式で生成し、メールで送信する機能を提供する。見積書は状態に応じて「Quotation」または「Order」としてタイトルが変化し、製品リスト、金額サマリー、支払情報などが含まれる。PDFは自動生成されてメールの添付ファイルとして送信され、送信前に内容のカスタマイズが可能である。

**業務上の目的・背景**：この帳票は、顧客への正式な見積提示を効率化し、販売プロセスの迅速化を実現する。PDF形式の見積書を自動生成することで、手作業による作成ミスを防ぎ、プロフェッショナルな見積書を一貫したフォーマットで提供できる。また、メール送信機能との統合により、見積書の送付からフォローアップまでをシステム内で完結させることができる。

**帳票の利用シーン**：新規顧客への見積提示時、既存顧客への価格更新通知時、商談プロセスにおける正式見積送付時、見積依頼への回答時、契約前の最終見積確認時に利用される。

**主要な出力内容**：
1. 自社会社情報（会社名、住所、連絡先）
2. 顧客情報（顧客名、住所、連絡先）
3. 見積番号/注文番号とタイプ表示
4. 見積日付と有効期限
5. 製品リスト（製品名、数量、単位、単価）
6. 金額サマリー（小計、税額、割引、合計）
7. 支払情報（支払参照番号、銀行口座情報）

**帳票の出力タイミング**：見積編集画面において、ユーザーが「Send by Email」ボタンをクリックした際にPDFが自動生成され、モーダルダイアログでメール内容を確認・編集後に送信される。

**帳票の利用者**：営業担当者、販売マネージャー、カスタマーサポート担当者

## 帳票種別

見積書 / 注文確認書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| SQ-001 | 見積編集画面 | /admin/sales/orders/quotations/{record}/edit | Send by Emailボタン押下 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦 (portrait) |
| ファイル名 | {注文名}-{タイムスタンプ}.pdf |
| 出力方法 | メール添付（Storage::disk('public')に一時保存） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |
| デフォルトフォント | Arial |

## 帳票レイアウト

### レイアウト概要

帳票は大きく6つの構成要素から成る：ヘッダー部（自社・顧客情報）、見積/注文タイトル部、詳細情報テーブル、製品明細テーブル、金額サマリー部、および支払情報部。

```
┌─────────────────────────────────────┐
│  自社会社情報    │  顧客情報         │
│  (左寄せ)       │  (右寄せ)        │
├─────────────────────────────────────┤
│  Quotation / Order ID #{番号}       │
├─────────────────────────────────────┤
│  見積日付 │ 有効期限               │
├─────────────────────────────────────┤
│  ┌─────────────────────────────────┐│
│  │ Product │ Qty │ Unit │ Price   ││
│  ├─────────────────────────────────┤│
│  │ 製品1   │ 10  │ 個   │ 500.00  ││
│  └─────────────────────────────────┘│
├─────────────────────────────────────┤
│              Subtotal: xxx         │
│              Tax: xxx              │
│              Discount: -xxx        │
│              Grand Total: xxx      │
├─────────────────────────────────────┤
│  Payment Information               │
│  Communication: {参照番号}          │
│  Bank: {銀行名} ({口座番号})        │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 会社名 | 販売元会社名 | sales_orders.company → companies.name | テキスト(28px) |
| 2 | 住所1 | 会社住所1行目 | companies.address → addresses.street1 | テキスト |
| 3 | 住所2 | 会社住所2行目 | addresses.street2 | テキスト（オプション） |
| 4 | 市区町村 | 市区町村名 | addresses.city | テキスト |
| 5 | 都道府県 | 都道府県名 | addresses.state → states.name | テキスト（オプション） |
| 6 | 郵便番号 | 郵便番号 | addresses.zip | テキスト |
| 7 | 国名 | 国名 | addresses.country → countries.name | テキスト（オプション） |
| 8 | メール | 会社メールアドレス | companies.email | テキスト（オプション） |
| 9 | 電話番号 | 会社電話番号 | companies.phone | テキスト（オプション） |
| 10 | 顧客名 | 顧客名 | sales_orders.partner → partners.name | テキスト |
| 11 | 顧客住所 | 顧客住所情報 | partners.addresses[0].street1, street2等 | テキスト |
| 12 | 顧客Email | 顧客メール | addresses.email | テキスト（オプション） |
| 13 | 顧客電話 | 顧客電話番号 | addresses.phone | テキスト（オプション） |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Quotation/Order Date | 見積/注文日付 | sales_orders.date_order | 日付（オプション） |
| 2 | Expiration Date | 有効期限 | sales_orders.validity_date | 日付（オプション） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Product | 製品名 | sales_order_lines.product → products.name | テキスト | - |
| 2 | Quantity | 数量 | sales_order_lines.product_uom_qty | 数値（カンマ区切り） | - |
| 3 | Unit | 単位 | products.uom → uoms.name | テキスト（オプション） | - |
| 4 | Unit Price | 単価 | sales_order_lines.price_unit | 数値（小数点2桁） | - |

### サマリー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Subtotal | 小計（税抜） | sales_orders.amount_untaxed | 通貨記号 + 数値（小数点2桁） |
| 2 | Tax | 税額 | sales_orders.amount_tax | 通貨記号 + 数値（小数点2桁） |
| 3 | Discount | 割引額 | sales_orders.total_discount | -通貨記号 + 数値（小数点2桁） |
| 4 | Grand Total | 合計 | sales_orders.amount_total | 通貨記号 + 数値（小数点2桁、太字） |

### フッター部（支払情報）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Payment Communication | 支払参照番号 | sales_orders.name | テキスト |
| 2 | Bank Name | 銀行名 | sales_orders.partnerBank → bank → banks.name | テキスト（オプション） |
| 3 | Account Number | 口座番号 | partnerBank.account_number | テキスト（オプション） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 注文状態 | state が 'sale' 以外のレコードのみ（SALE状態では非表示） | Yes |
| 注文ID | 指定された販売注文レコード | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 明細行の登録順 | 昇順 |

### 改ページ条件

単一見積書の出力（改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sales_orders | 販売注文マスタ | 主テーブル |
| sales_order_lines | 注文明細 | order_id = sales_orders.id |
| companies | 会社情報 | company_id = companies.id |
| addresses | 住所情報 | company.address_id / partner.addresses |
| partners | パートナー（顧客） | partner_id = partners.id |
| products | 製品 | product_id = products.id |
| uoms | 単位 | uom_id = uoms.id |
| currencies | 通貨 | currency_id = currencies.id |
| bank_accounts | 銀行口座 | partner_bank_id = bank_accounts.id |
| banks | 銀行 | bank_id = banks.id |
| states | 都道府県 | state_id = states.id |
| countries | 国 | country_id = countries.id |

### テーブル別参照項目詳細

#### sales_orders

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 見積/注文番号、支払参照 | id指定 | "SO/{id}" 形式 |
| state | タイトル判定、表示判定 | SALE以外で表示 | Enum: OrderState |
| date_order | Quotation/Order Date | - | nullable |
| validity_date | Expiration Date | - | nullable |
| amount_untaxed | Subtotal | - | 税抜小計 |
| amount_tax | Tax | - | 税額 |
| amount_total | Grand Total | - | 合計 |
| total_discount | Discount | - | 割引額 |
| partner_id | 顧客 | FK | - |
| company_id | 会社 | FK | - |
| currency_id | 通貨 | FK | - |
| partner_bank_id | 銀行口座 | FK | nullable |

#### sales_order_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | Product | order_id = ? | FK |
| product_uom_qty | Quantity | - | 数量 |
| price_unit | Unit Price | - | 単価 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(product_uom_qty) | 整数 | カンマ区切り |
| 単価表示 | number_format(price_unit, 2) | 小数点2桁 | カンマ区切り |
| 小計表示 | currency.symbol + number_format(amount_untaxed, 2) | 小数点2桁 | 通貨記号付き |
| 税額表示 | currency.symbol + number_format(amount_tax, 2) | 小数点2桁 | 通貨記号付き |
| 割引表示 | -currency.symbol + number_format(total_discount, 2) | 小数点2桁 | マイナス表示 |
| 合計表示 | currency.symbol + number_format(amount_total, 2) | 小数点2桁 | 通貨記号付き、太字 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Send by Emailボタン押下] --> B[beforeFormFilled実行]
    B --> C[PDFビュー読み込み]
    C --> D[DomPDF生成（A4縦、Arial）]
    D --> E[Storage/publicに保存]
    E --> F[フォームにデフォルト値設定]
    F --> G[モーダル表示]
    G --> H{ユーザー操作}
    H -->|送信| I[SaleOrder::sendQuotationOrOrderByEmail実行]
    I --> J[メール送信結果処理]
    J --> K[通知表示]
    K --> L[フォーム更新]
    L --> M[終了]
    H -->|キャンセル| M
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ボタン非表示 | 状態がSALEの場合 | - | ボタンが表示されない |
| 送信先なし | パートナーが選択されていない | No recipients warning | 警告通知を表示 |
| 全件失敗 | 全宛先への送信失敗 | All failed error | 失敗理由を表示 |
| 部分失敗 | 一部宛先への送信失敗 | Partial success warning | 成功・失敗それぞれを表示 |
| データなし | 注文明細が空 | - | 明細テーブルが表示されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1注文あたり1〜100製品行 |
| 目標出力時間 | 3秒以内（PDF生成） |
| 同時出力数上限 | 制限なし（単一注文出力） |

## セキュリティ考慮事項

- 販売注文へのアクセス権限を持つユーザーのみが帳票出力・メール送信可能
- Filament Resourceのcan権限によるアクセス制御
- PDFはpublicディスクに保存されるため、適切なアクセス制御が必要
- メール送信先は選択可能だが、顧客情報の取り扱いに注意

## 備考

- PDF生成にはbarryvdh/laravel-dompdfパッケージを使用
- Bladeテンプレート: `sales::sales.quotation`
- 状態（state）が'sale'の場合は「Order」、それ以外は「Quotation」としてタイトル表示
- メール送信機能はSaleOrder::sendQuotationOrOrderByEmailメソッドを使用
- 送信結果に応じて成功/警告/エラー通知が表示される
- UOM表示は設定（ProductSettings::enable_uom）により表示/非表示が切り替わる
- PDFファイルは`sales-orders/`ディレクトリに保存される
