# 帳票設計書 14-請求書 (Invoice)

## 概要

本ドキュメントは、会計管理モジュールにおける請求書（Invoice）のPDF帳票出力およびメール送信機能について、その仕様と設計を定義するものである。

### 本帳票の処理概要

この帳票は、顧客に対して請求書をPDF形式で生成し、メールで送信する機能を提供する。請求書には請求先情報、明細、金額サマリー、支払情報が含まれ、転記済み（Posted）またはキャンセル済み（Cancel）の状態でのみ出力可能である。PDFは自動生成されてメールの添付ファイルとして送信され、送信前に内容のカスタマイズが可能である。

**業務上の目的・背景**：この帳票は、販売取引完了後の正式な請求処理を効率化する。PDF形式の請求書を自動生成することで、法的要件を満たす正式な請求書を一貫したフォーマットで提供できる。また、メール送信機能との統合により、請求書の発行から入金管理までの経理業務をシステム内で完結させることができる。請求書は会計監査の証跡としても重要な文書となる。

**帳票の利用シーン**：商品・サービス提供完了後の請求時、月次請求処理時、入金催促時の請求書再送付時、経理部門での請求書発行業務時、顧客からの請求書再発行依頼対応時に利用される。

**主要な出力内容**：
1. 自社会社情報（会社名、住所、連絡先）
2. 請求先情報（顧客名、住所、連絡先）
3. 請求書番号（Invoice ID）
4. 請求日と支払期日
5. 請求明細（製品名、数量、単位、単価）
6. 金額サマリー（小計、税額、割引、合計）
7. 支払情報（支払参照番号、銀行口座情報）

**帳票の出力タイミング**：請求書詳細画面において、ユーザーが「Print & Send」ボタンをクリックした際にPDFが自動生成され、モーダルダイアログでメール内容を確認・編集後に送信される。

**帳票の利用者**：経理担当者、会計マネージャー、営業担当者、財務担当者

## 帳票種別

請求書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-001 | 請求書詳細画面 | /admin/accounts/invoices/{record}/edit | Print & Sendボタン押下 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦 (portrait) |
| ファイル名 | invoice-{作成日(dd-mm-YYYY形式)}.pdf |
| 出力方法 | メール添付（Storage経由で一時保存） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票は大きく6つの構成要素から成る：ヘッダー部（自社・顧客情報）、請求書タイトル部、詳細情報テーブル、明細テーブル、金額サマリー部、および支払情報部。

```
┌─────────────────────────────────────┐
│  自社会社情報    │  請求先情報       │
│  (左寄せ)       │  (右寄せ)        │
├─────────────────────────────────────┤
│  Invoice ID #{請求書番号}           │
├─────────────────────────────────────┤
│  請求日 │ 支払期日                   │
├─────────────────────────────────────┤
│  ┌─────────────────────────────────┐│
│  │ Product │ Qty │ Unit │ Price   ││
│  ├─────────────────────────────────┤│
│  │ 製品1   │ 5   │ 個   │ 2000.00 ││
│  └─────────────────────────────────┘│
├─────────────────────────────────────┤
│              Subtotal: xxx         │
│              Tax: xxx              │
│              Discount: -xxx        │
│              Grand Total: xxx      │
├─────────────────────────────────────┤
│  Payment Information               │
│  Communication: {請求書番号}        │
│  Bank: {銀行名} ({口座番号})        │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 会社名 | 請求元会社名 | accounts_account_moves.company → companies.name | テキスト(28px) |
| 2 | 住所1 | 会社住所1行目 | companies.partner → partners.street1 | テキスト |
| 3 | 住所2 | 会社住所2行目 | partners.street2 | テキスト（オプション） |
| 4 | 市区町村 | 市区町村名 | partners.city | テキスト |
| 5 | 都道府県 | 都道府県名 | partners.state → states.name | テキスト（オプション） |
| 6 | 郵便番号 | 郵便番号 | partners.zip | テキスト |
| 7 | 国名 | 国名 | partners.country → countries.name | テキスト（オプション） |
| 8 | メール | 会社メールアドレス | companies.email | テキスト（オプション） |
| 9 | 電話番号 | 会社電話番号 | companies.phone | テキスト（オプション） |
| 10 | 顧客名 | 請求先顧客名 | accounts_account_moves.partner → partners.name | テキスト |
| 11 | 顧客住所1 | 顧客住所1行目 | partners.street1 | テキスト |
| 12 | 顧客住所2 | 顧客住所2行目 | partners.street2 | テキスト（オプション） |
| 13 | 顧客市区町村 | 顧客市区町村 | partners.city | テキスト |
| 14 | 顧客都道府県 | 顧客都道府県 | partners.state → states.name | テキスト（オプション） |
| 15 | 顧客郵便番号 | 顧客郵便番号 | partners.zip | テキスト |
| 16 | 顧客国名 | 顧客国名 | partners.country → countries.name | テキスト（オプション） |
| 17 | 顧客Email | 顧客メール | partners.email | テキスト（オプション） |
| 18 | 顧客電話 | 顧客電話番号 | partners.phone | テキスト（オプション） |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Invoice Date | 請求日 | accounts_account_moves.invoice_date | 日付（オプション） |
| 2 | Due Date | 支払期日 | accounts_account_moves.invoice_date_due | 日付（Y-m-d形式）（オプション） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Product | 製品名 | accounts_account_move_lines.product → products.name | テキスト | - |
| 2 | Quantity | 数量 | accounts_account_move_lines.quantity | 数値（カンマ区切り） | - |
| 3 | Unit | 単位 | products.uom → uoms.name | テキスト（オプション） | - |
| 4 | Unit Price | 単価 | accounts_account_move_lines.price_unit | 数値（小数点2桁） | - |

### サマリー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Subtotal | 小計（税抜） | accounts_account_moves.amount_untaxed | 通貨記号 + 数値（小数点2桁） |
| 2 | Tax | 税額 | accounts_account_moves.amount_tax | 通貨記号 + 数値（小数点2桁） |
| 3 | Discount | 割引額 | 計算（total_discount） | -通貨記号 + 数値（小数点2桁） |
| 4 | Grand Total | 合計 | accounts_account_moves.amount_total | 通貨記号 + 数値（小数点2桁、太字） |

### フッター部（支払情報）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Payment Communication | 支払参照番号 | accounts_account_moves.name | テキスト |
| 2 | Bank Name | 銀行名 | accounts_account_moves.partnerBank → bank → banks.name | テキスト（オプション） |
| 3 | Account Number | 口座番号 | partnerBank.account_number | テキスト（オプション） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 請求書状態 | state が 'posted' または 'cancel' のレコードのみ | Yes |
| 請求書ID | 指定された請求書レコード | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 明細行の登録順 | 昇順 |

### 改ページ条件

単一請求書の出力（改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| accounts_account_moves | 請求書マスタ | 主テーブル |
| accounts_account_move_lines | 請求明細 | move_id = accounts_account_moves.id, display_type = 'product' |
| companies | 会社情報 | company_id = companies.id |
| partners | パートナー（顧客/会社住所） | partner_id = partners.id |
| products | 製品 | product_id = products.id |
| uoms | 単位 | uom_id = uoms.id |
| currencies | 通貨 | currency_id = currencies.id |
| bank_accounts | 銀行口座 | partner_bank_id = bank_accounts.id |
| banks | 銀行 | bank_id = banks.id |
| states | 都道府県 | state_id = states.id |
| countries | 国 | country_id = countries.id |

### テーブル別参照項目詳細

#### accounts_account_moves

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | Invoice ID、支払参照 | id指定 | "{プレフィックス}/{id}" 形式 |
| state | 表示判定 | posted または cancel | Enum: MoveState |
| invoice_date | Invoice Date | - | nullable |
| invoice_date_due | Due Date | - | datetime型、nullable |
| amount_untaxed | Subtotal | - | 税抜小計 |
| amount_tax | Tax | - | 税額 |
| amount_total | Grand Total | - | 合計 |
| partner_id | 顧客 | FK | - |
| company_id | 会社 | FK | - |
| currency_id | 通貨 | FK | - |
| partner_bank_id | 銀行口座 | FK | nullable |

#### accounts_account_move_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | Product | move_id = ?, display_type = 'product' | FK |
| quantity | Quantity | - | 数量 |
| price_unit | Unit Price | - | 単価 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(quantity) | 整数 | カンマ区切り |
| 単価表示 | number_format(price_unit, 2) | 小数点2桁 | カンマ区切り |
| 小計表示 | currency.symbol + number_format(amount_untaxed, 2) | 小数点2桁 | 通貨記号付き |
| 税額表示 | currency.symbol + number_format(amount_tax, 2) | 小数点2桁 | 通貨記号付き |
| 割引表示 | -currency.symbol + number_format(total_discount, 2) | 小数点2桁 | アクセサで計算 |
| 合計表示 | currency.symbol + number_format(amount_total, 2) | 小数点2桁 | 通貨記号付き、太字 |
| 支払期日 | invoice_date_due->format('Y-m-d') | - | 日付フォーマット |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Print & Sendボタン押下] --> B[beforeFormFilled実行]
    B --> C[プレビュービュー読み込み]
    C --> D[PDFHandler::savePDF実行]
    D --> E[Storage経由でPDF保存]
    E --> F[フォームにデフォルト値設定]
    F --> G[モーダル表示]
    G --> H{ユーザー操作}
    H -->|送信| I[Account::printAndSend実行]
    I --> J[メール送信処理]
    J --> K[終了]
    H -->|キャンセル| K
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ボタン非表示 | 状態がposted/cancel以外 | - | ボタンが表示されない |
| データなし | 請求明細が空 | - | 明細テーブルが表示されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1請求書あたり1〜100明細行 |
| 目標出力時間 | 3秒以内（PDF生成） |
| 同時出力数上限 | 制限なし（単一請求書出力） |

## セキュリティ考慮事項

- 請求書へのアクセス権限を持つユーザーのみが帳票出力・メール送信可能
- Filament Resourceのcan権限によるアクセス制御
- 請求書は財務情報を含むため、適切なアクセス制御が必要
- メール送信先は選択可能だが、顧客情報の取り扱いに注意
- 請求書番号は会計監査の証跡となるため、改ざん防止に注意

## 備考

- PDF生成にはPDFHandler Traitを使用（barryvdh/laravel-dompdf）
- Bladeテンプレート: `accounts::invoice/actions/preview.index`
- 請求書番号は種別に応じてプレフィックスが変化（INV, RINV, BILL, RBILL）
- Print & Sendアクションは封筒アイコン付きで表示
- 明細はdisplay_type = 'product'のレコードのみを取得
- total_discountはgetTotalDiscountAttributeアクセサで計算
- モーダルでは複数ファイルの添付が可能
