# 帳票設計書 15-請求書プレビュー (Invoice Preview)

## 概要

本ドキュメントは、会計管理モジュールにおける請求書プレビュー（Invoice Preview）機能について、その仕様と設計を定義するものである。

### 本帳票の処理概要

この帳票は、請求書のPDF生成前に内容を画面上で確認するためのプレビュー機能を提供する。モーダルダイアログ形式で請求書の完成イメージを表示し、ユーザーは送信前に内容を確認することができる。プレビュー表示は転記済み（Posted）状態でのみ利用可能であり、実際のPDFファイルは生成されずにHTMLビューとして表示される。

**業務上の目的・背景**：この機能は、請求書発行前の最終確認プロセスを効率化する。PDF生成やメール送信を行う前に内容を確認することで、誤った情報での請求書発行を防止できる。特に金額や顧客情報の確認は重要であり、プレビュー機能によりヒューマンエラーを最小限に抑えることができる。また、PDF生成処理を省略することで、確認作業の応答速度を向上させている。

**帳票の利用シーン**：請求書発行前の最終確認時、経理担当者による内容チェック時、上長承認前の内容確認時、顧客への請求書送付前の検証時、誤請求防止のためのダブルチェック時に利用される。

**主要な出力内容**：
1. 自社会社情報（会社名、住所、連絡先）
2. 請求先情報（顧客名、住所、連絡先）
3. 請求書番号（Invoice ID）
4. 請求日と支払期日
5. 請求明細（製品名、数量、単位、単価）
6. 金額サマリー（小計、税額、割引、合計）
7. 支払情報（支払参照番号、銀行口座情報）

**帳票の出力タイミング**：請求書詳細画面において、ユーザーが「Preview」ボタンをクリックした際にモーダルダイアログでプレビューが表示される。

**帳票の利用者**：経理担当者、会計マネージャー、営業担当者、財務担当者

## 帳票種別

プレビュー（画面表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-002 | 請求書詳細画面 | /admin/accounts/invoices/{record}/edit | Previewボタン押下 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| 表示形式 | HTMLビュー（モーダルダイアログ） |
| レイアウト | A4相当のドキュメント形式 |
| 出力方法 | 画面表示（modalContent） |
| 文字コード | UTF-8 |

### 画面固有設定

| 項目 | 内容 |
|-----|------|
| モーダルタイプ | 通常モーダル |
| 送信ボタン | 非表示（false） |
| アイコン | viewfinder-circle |

## 帳票レイアウト

### レイアウト概要

プレビューは請求書（Invoice）と同一のレイアウトを使用する。モーダルダイアログ内にHTMLビューとして表示され、印刷イメージに近い形式で確認できる。

```
┌─────────────────────────────────────┐
│  自社会社情報    │  請求先情報       │
│  (左寄せ)       │  (右寄せ)        │
├─────────────────────────────────────┤
│  Invoice ID #{請求書番号}           │
├─────────────────────────────────────┤
│  請求日 │ 支払期日                   │
├─────────────────────────────────────┤
│  ┌─────────────────────────────────┐│
│  │ Product │ Qty │ Unit │ Price   ││
│  ├─────────────────────────────────┤│
│  │ 製品1   │ 5   │ 個   │ 2000.00 ││
│  └─────────────────────────────────┘│
├─────────────────────────────────────┤
│              Subtotal: xxx         │
│              Tax: xxx              │
│              Discount: -xxx        │
│              Grand Total: xxx      │
├─────────────────────────────────────┤
│  Payment Information               │
│  Communication: {請求書番号}        │
│  Bank: {銀行名} ({口座番号})        │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 会社名 | 請求元会社名 | accounts_account_moves.company → companies.name | テキスト(28px) |
| 2 | 住所1 | 会社住所1行目 | companies.partner → partners.street1 | テキスト |
| 3 | 住所2 | 会社住所2行目 | partners.street2 | テキスト（オプション） |
| 4 | 市区町村 | 市区町村名 | partners.city | テキスト |
| 5 | 都道府県 | 都道府県名 | partners.state → states.name | テキスト（オプション） |
| 6 | 郵便番号 | 郵便番号 | partners.zip | テキスト |
| 7 | 国名 | 国名 | partners.country → countries.name | テキスト（オプション） |
| 8 | メール | 会社メールアドレス | companies.email | テキスト（オプション） |
| 9 | 電話番号 | 会社電話番号 | companies.phone | テキスト（オプション） |
| 10 | 顧客名 | 請求先顧客名 | accounts_account_moves.partner → partners.name | テキスト |
| 11 | 顧客住所 | 顧客住所情報 | partners.street1, street2, city, state, zip, country | テキスト |
| 12 | 顧客Email | 顧客メール | partners.email | テキスト（オプション） |
| 13 | 顧客電話 | 顧客電話番号 | partners.phone | テキスト（オプション） |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Invoice Date | 請求日 | accounts_account_moves.invoice_date | 日付（オプション） |
| 2 | Due Date | 支払期日 | accounts_account_moves.invoice_date_due | 日付（Y-m-d形式）（オプション） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Product | 製品名 | accounts_account_move_lines.product → products.name | テキスト | - |
| 2 | Quantity | 数量 | accounts_account_move_lines.quantity | 数値（カンマ区切り） | - |
| 3 | Unit | 単位 | products.uom → uoms.name | テキスト（オプション） | - |
| 4 | Unit Price | 単価 | accounts_account_move_lines.price_unit | 数値（小数点2桁） | - |

### サマリー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Subtotal | 小計（税抜） | accounts_account_moves.amount_untaxed | 通貨記号 + 数値（小数点2桁） |
| 2 | Tax | 税額 | accounts_account_moves.amount_tax | 通貨記号 + 数値（小数点2桁） |
| 3 | Discount | 割引額 | 計算（total_discount） | -通貨記号 + 数値（小数点2桁） |
| 4 | Grand Total | 合計 | accounts_account_moves.amount_total | 通貨記号 + 数値（小数点2桁、太字） |

### フッター部（支払情報）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Payment Communication | 支払参照番号 | accounts_account_moves.name | テキスト |
| 2 | Bank Name | 銀行名 | accounts_account_moves.partnerBank → bank → banks.name | テキスト（オプション） |
| 3 | Account Number | 口座番号 | partnerBank.account_number | テキスト（オプション） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 請求書状態 | state が 'posted' のレコードのみ | Yes |
| 請求書ID | 指定された請求書レコード | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 明細行の登録順 | 昇順 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| accounts_account_moves | 請求書マスタ | 主テーブル |
| accounts_account_move_lines | 請求明細 | move_id = accounts_account_moves.id, display_type = 'product' |
| companies | 会社情報 | company_id = companies.id |
| partners | パートナー（顧客/会社住所） | partner_id = partners.id |
| products | 製品 | product_id = products.id |
| uoms | 単位 | uom_id = uoms.id |
| currencies | 通貨 | currency_id = currencies.id |
| bank_accounts | 銀行口座 | partner_bank_id = bank_accounts.id |
| banks | 銀行 | bank_id = banks.id |
| states | 都道府県 | state_id = states.id |
| countries | 国 | country_id = countries.id |

### テーブル別参照項目詳細

#### accounts_account_moves

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | Invoice ID、支払参照 | id指定 | "{プレフィックス}/{id}" 形式 |
| state | 表示判定 | posted のみ | Enum: MoveState |
| invoice_date | Invoice Date | - | nullable |
| invoice_date_due | Due Date | - | datetime型、nullable |
| amount_untaxed | Subtotal | - | 税抜小計 |
| amount_tax | Tax | - | 税額 |
| amount_total | Grand Total | - | 合計 |
| partner_id | 顧客 | FK | - |
| company_id | 会社 | FK | - |
| currency_id | 通貨 | FK | - |
| partner_bank_id | 銀行口座 | FK | nullable |

#### accounts_account_move_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | Product | move_id = ?, display_type = 'product' | FK |
| quantity | Quantity | - | 数量 |
| price_unit | Unit Price | - | 単価 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(quantity) | 整数 | カンマ区切り |
| 単価表示 | number_format(price_unit, 2) | 小数点2桁 | カンマ区切り |
| 小計表示 | currency.symbol + number_format(amount_untaxed, 2) | 小数点2桁 | 通貨記号付き |
| 税額表示 | currency.symbol + number_format(amount_tax, 2) | 小数点2桁 | 通貨記号付き |
| 割引表示 | -currency.symbol + number_format(total_discount, 2) | 小数点2桁 | アクセサで計算 |
| 合計表示 | currency.symbol + number_format(amount_total, 2) | 小数点2桁 | 通貨記号付き、太字 |
| 支払期日 | invoice_date_due->format('Y-m-d') | - | 日付フォーマット |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Previewボタン押下] --> B[setTemplate実行]
    B --> C{テンプレート存在確認}
    C -->|存在する| D[モーダル表示]
    C -->|存在しない| E[InvalidArgumentException]
    D --> F[Bladeビューレンダリング]
    F --> G[modalContentに表示]
    G --> H[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ボタン非表示 | 状態がposted以外 | - | ボタンが表示されない |
| テンプレートなし | setTemplateで無効なビュー指定 | InvalidArgumentException | 有効なビューパスを指定 |
| データなし | 請求明細が空 | - | 明細テーブルが表示されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1請求書あたり1〜100明細行 |
| 目標表示時間 | 1秒以内（PDF生成なし） |
| 同時表示数上限 | 制限なし（単一請求書表示） |

## セキュリティ考慮事項

- 請求書へのアクセス権限を持つユーザーのみがプレビュー表示可能
- Filament Resourceのcan権限によるアクセス制御
- 請求書は財務情報を含むため、適切なアクセス制御が必要
- プレビューはHTMLとして表示されるため、XSS対策に注意

## 備考

- プレビューはPDF生成を行わず、HTMLビューを直接表示
- Bladeテンプレートは請求書（Invoice）と共有: `accounts::invoice/actions/preview.index`
- PreviewActionクラスはPDFHandler Traitを使用するが、プレビュー表示時はPDF生成しない
- setTemplateメソッドでビューの存在確認を行い、存在しない場合は例外をスロー
- モーダルの送信ボタンは非表示（modalSubmitAction(false)）
- posted状態のみで表示可能（Print & Sendとは異なりcancelでは表示されない）
- viewfinder-circleアイコンを使用
