# 帳票設計書 3-製品ラベル (Labels)

## 概要

本ドキュメントは、在庫管理システムにおける製品ラベル（Labels）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

製品ラベルは、製品またはロット番号のバーコードラベルをPDF形式で出力する機能であり、DYMO、2x7、4x7、4x12等の複数フォーマットに対応している。ウィザード形式の入力画面でタイプ、数量、フォーマットを選択し、指定された形式でラベルを一括生成する。

**業務上の目的・背景**：製品ラベルは、倉庫内での製品識別、棚卸作業、出荷検品作業を効率化するための重要な帳票である。バーコードスキャナーで読み取り可能なラベルを提供することで、手作業による製品確認ミスを防止し、作業の迅速化と正確性向上に貢献する。また、ロット/シリアル番号追跡が必要な業務において、製品のトレーサビリティを確保する手段としても活用される。

**帳票の利用シーン**：入荷検品後の製品ラベル貼付、棚卸時の在庫確認、出荷時の製品識別、ロット管理が必要な製品の追跡管理などで使用する。

**主要な出力内容**：
1. 製品名（大文字表示）
2. バーコード（製品バーコードまたはロット番号）
3. バーコードテキスト
4. 価格（価格表示フォーマット選択時）

**帳票の出力タイミング**：在庫オペレーション画面から「Labels」ボタンをクリックし、ウィザードでオプションを選択後にPDFとしてダウンロードされる。

**帳票の利用者**：倉庫作業者、入荷検品担当者、棚卸担当者、出荷担当者

## 帳票種別

ラベル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-003 | 在庫オペレーション詳細画面 | /inventories/operations/{type}/{id} | 「Labels」ボタンクリック → ウィザード完了 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4（デフォルト）/ DYMO専用サイズ（252.2 x 144ポイント） |
| 向き | 縦（Portrait） |
| ファイル名 | Labels-{オペレーション名}.pdf（スラッシュはアンダースコアに変換） |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

### ラベルフォーマット一覧

| フォーマット | 列数 | 価格表示 | 用紙サイズ | バーコードスケール |
|------------|------|---------|-----------|-----------------|
| dymo | 1 | 無 | 252.2 x 144ポイント | 2 |
| 2x7_price | 2 | 有 | A4 | 2 |
| 4x7_price | 4 | 有 | A4 | 1.2 |
| 4x12 | 4 | 無 | A4 | 1.2 |
| 4x12_price | 4 | 有 | A4 | 1.2 |

## 帳票レイアウト

### レイアウト概要

帳票はテーブル形式で複数のラベルを配置する構成となる。選択されたフォーマットに応じて列数が変わり、各セルに製品名、バーコード、価格（オプション）が表示される。

```
+----------+----------+----------+----------+
| 製品名   | 製品名   | 製品名   | 製品名   |
|[barcode] |[barcode] |[barcode] |[barcode] |
| CODE001  | CODE002  | CODE003  | CODE004  |
| $10.00   | $15.00   | $20.00   | $25.00   |
+----------+----------+----------+----------+
| 製品名   | 製品名   | 製品名   | 製品名   |
|[barcode] |[barcode] |[barcode] |[barcode] |
| CODE005  | CODE006  | CODE007  | CODE008  |
| $30.00   | $35.00   | $40.00   | $45.00   |
+----------+----------+----------+----------+
```

### ラベルセル構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 製品名 | 製品名（大文字変換） | MoveLine.product.name | テキスト（12px、青色、大文字、太字） |
| 2 | バーコード | 製品バーコードまたはロット番号 | MoveLine.lot.name または MoveLine.product.barcode | Code128形式 |
| 3 | バーコードテキスト | バーコード値のテキスト表示 | 同上 | テキスト（11px） |
| 4 | 価格 | 製品価格 | MoveLine.price | 数値（小数点2桁、価格フォーマット時のみ） |

## 入力パラメータ

### ウィザード入力項目

#### Step 1: タイプ選択（ロット有効時のみ表示）

| 項目名 | 説明 | 選択肢 | デフォルト |
|-------|------|-------|----------|
| type | ラベルタイプ | product（製品）/ lot（ロット） | product |

#### Step 2: レイアウト設定

**製品タイプ選択時：**

| 項目名 | 説明 | 選択肢/入力 | デフォルト |
|-------|------|------------|----------|
| quantity_type | 数量タイプ | operation（オペレーション数量）/ custom（カスタム） | operation |
| quantity | カスタム数量 | 1〜100の整数（customの場合必須） | - |
| format | フォーマット | dymo / 2x7_price / 4x7_price / 4x12 / 4x12_price | 2x7_price |

**ロットタイプ選択時：**

| 項目名 | 説明 | 選択肢/入力 | デフォルト |
|-------|------|------------|----------|
| quantity_type | 数量タイプ | per_lot（ロット単位）/ per_unit（ユニット単位） | per_lot |
| format | フォーマット | 4x12 | 4x12 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| オペレーションID | 出力対象のOperation.id | Yes |
| moveLines | オペレーションに紐づくMoveLine一覧 | Yes |
| type | 製品/ロットの選択 | Yes |
| format | ラベルフォーマット | Yes |

### フィルタ条件

| 条件 | 説明 |
|-----|------|
| type='lot'の場合 | lot_idがnullでないMoveLineのみ抽出 |

### ラベル枚数計算

| quantity_type | 計算式 |
|--------------|--------|
| operation | MoveLine.qty × レコード数 |
| custom | 入力されたquantity × レコード数 |
| per_lot | 1 × レコード数 |
| per_unit | MoveLine.qty × レコード数 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_operations | オペレーション基本情報 | 主テーブル |
| inventories_move_lines | 製品明細情報 | operation_id = inventories_operations.id |
| products_products | 製品マスタ | inventories_move_lines.product_id = id |
| inventories_lots | ロット情報 | inventories_move_lines.lot_id = id |

### テーブル別参照項目詳細

#### inventories_move_lines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | 製品情報取得用 | operation_id一致 | FK |
| qty | ラベル枚数計算用 | - | decimal型 |
| lot_id | ロット情報取得用 | - | FK（nullable） |
| price | 価格表示用 | - | decimal型 |

#### products_products

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 製品名 | - | テキスト |
| barcode | バーコード値 | - | テキスト（nullable） |

#### inventories_lots

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | ロットバーコード値 | - | テキスト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 価格表示 | number_format(price, 2) | 小数点2桁 | - |
| バーコードスケール | columns == 4 ? 1.2 : 2 | - | 列数に応じて動的変更 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Labelsボタンクリック] --> B[ウィザード表示]
    B --> C{ロット機能有効?}
    C -->|Yes| D[Step1: タイプ選択]
    C -->|No| E[Step2: レイアウト設定]
    D --> E
    E --> F[LabelsAction実行]
    F --> G[MoveLine抽出]
    G --> H{type=lot?}
    H -->|Yes| I[lot_id有のみフィルタ]
    H -->|No| J[全MoveLine]
    I --> K[ラベル数計算・展開]
    J --> K
    K --> L[Blade templateでHTML生成]
    L --> M[バーコード生成: DNS1D::getBarcodeHTML]
    M --> N[DomPDFでPDF変換]
    N --> O{format=dymo?}
    O -->|Yes| P[DYMO用紙サイズ設定]
    O -->|No| Q[A4用紙サイズ設定]
    P --> R[streamDownloadでファイル返却]
    Q --> R
    R --> S[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | moveLinesが空 | 空のPDF生成 | 空のテーブルを出力 |
| バーコードなし | barcodeがnull | バーコード非表示 | バーコード部分を空白で表示 |
| ロットなし | type=lotでlot_idがない | 該当レコードスキップ | フィルタで除外 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 最大100枚/回（quantity上限） |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- 製品バーコード、ロット番号は企業の在庫管理に関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- ラベルにはセンシティブな個人情報は含まれない
- PDF出力時のログ記録は実装されていない

## 備考

- タイプ選択（Step1）は、TraceabilitySettings.enable_lots_serial_numbersが有効かつ、moveLines内にlot_idを持つレコードが存在する場合のみ表示される
- ロットタイプ選択時は、フォーマットが4x12に固定される
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 製品名は全て大文字（strtoupper）で表示される
- バーコードのスケールは列数に応じて自動調整される（4列の場合は小さく、2列以下の場合は大きく）
- DYMOフォーマットは専用用紙サイズ（252.2 x 144ポイント）で出力される
