# 帳票設計書 4-パッケージ伝票 (Package)

## 概要

本ドキュメントは、在庫管理システムにおけるパッケージ伝票（Package）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

パッケージ伝票は、在庫オペレーションに紐づくパッケージの内容物情報を含むPDF帳票であり、パッケージ名、バーコード、パッケージタイプ、梱包日、製品明細等を出力する機能を提供する。

**業務上の目的・背景**：パッケージ伝票は、出荷・入荷作業においてパッケージ単位での内容物確認を行うための帳票である。複数の製品をまとめてパッケージングした場合に、その内容物を一覧で確認できるようにし、出荷検品や入荷検品の効率化を図る。また、パッケージバーコードにより、パッケージ単位でのトラッキングが可能となる。

**帳票の利用シーン**：出荷時のパッケージ内容確認、入荷時の検品作業、倉庫内でのパッケージ移動時の内容物確認、顧客への納品時のパッキングリストとして使用する。

**主要な出力内容**：
1. パッケージ名とバーコード
2. パッケージタイプと梱包日
3. 製品明細（製品バーコード、製品名、数量）
4. ロット/シリアル番号情報（設定有効時）
5. 内容確認メッセージ

**帳票の出力タイミング**：在庫オペレーション画面から「Package」ボタンをクリックした際にPDFとしてダウンロードされる。

**帳票の利用者**：出荷担当者、入荷検品担当者、倉庫作業者、配送担当者

## 帳票種別

明細書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-004 | 在庫オペレーション詳細画面 | /inventories/operations/{type}/{id} | 「Package」ボタンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Package-{オペレーション名}.pdf（スラッシュはアンダースコアに変換） |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票はパッケージごとにセクションが分かれ、各セクションにパッケージヘッダー、詳細情報、製品明細テーブル、確認メッセージが配置される。複数パッケージを出力する場合は、各パッケージごとにページ分割される。

```
+-----------------------------------------------+
| {パッケージ名}              [バーコード]       |
+-----------------------------------------------+
| Package Type: {タイプ} | Pack Date: {日付}    |
+-----------------------------------------------+
| Barcode     | Product              | Quantity |
|-------------|----------------------|----------|
| [barcode]   | 製品名1              | 10 Units |
| CODE001     |                      |          |
|-------------|----------------------|----------|
| Lot/Serial: LOT001                            |
| [lot barcode]                                 |
+-----------------------------------------------+
|   内容確認メッセージ                           |
+-----------------------------------------------+
```

### パッケージヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | パッケージ名 | パッケージの識別名 | Package.name | テキスト（24px、青色） |
| 2 | パッケージバーコード | パッケージ名のバーコード | Package.name | Code128形式、高さ33px |
| 3 | バーコードテキスト | パッケージ名のテキスト | Package.name | テキスト（12px、グレー） |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Package Type | パッケージタイプ名 | Package.packageType.name | テキスト（存在する場合のみ） |
| 2 | Pack Date | 梱包日 | Package.pack_date | 日付形式（存在する場合のみ） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Barcode | 製品バーコード | Quantity.product.barcode | Code128バーコード + テキスト | 自動 |
| 2 | Product | 製品名 | Quantity.product.name | テキスト | 自動 |
| 3 | Quantity | 数量と単位 | Quantity.quantity + Quantity.product.uom.name | 数値（カンマ区切り） + 単位 | 自動 |

### ロット情報部（条件付き）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Lot/Serial | ロット/シリアル番号 | Quantity.lot.name | テキスト（太字） |
| 2 | ロットバーコード | ロット番号のバーコード | Quantity.lot.name | Code128形式、高さ33px |
| 3 | バーコードテキスト | ロット番号のテキスト | Quantity.lot.name | テキスト |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 確認メッセージ | 内容確認の注意メッセージ | 固定文字列 | 中央揃え、グレー文字、0.9em |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| オペレーションID | 出力対象のOperation.id | Yes |
| packages | オペレーションに紐づくPackage一覧（distinct） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Package.id | 昇順（デフォルト） |

### 改ページ条件

複数パッケージを出力する場合、各パッケージごとにページブレークが発生する（page-break-after: always）。最終パッケージでは改ページしない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_operations | オペレーション基本情報 | 主テーブル |
| inventories_move_lines | パッケージ取得用中間テーブル | operation_id = inventories_operations.id |
| inventories_packages | パッケージ情報 | inventories_move_lines.result_package_id = id |
| inventories_package_types | パッケージタイプ | inventories_packages.package_type_id = id |
| inventories_quantities | パッケージ内容物 | package_id = inventories_packages.id |
| products_products | 製品マスタ | inventories_quantities.product_id = id |
| support_uoms | 単位マスタ | products_products.uom_id = id |
| inventories_lots | ロット情報 | inventories_quantities.lot_id = id |

### テーブル別参照項目詳細

#### inventories_packages

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | パッケージ名、バーコード | - | テキスト |
| package_type_id | パッケージタイプ取得用 | - | FK（nullable） |
| pack_date | 梱包日 | - | date型（nullable） |

#### inventories_quantities

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | 製品情報取得用 | package_id一致 | FK |
| quantity | 数量 | - | decimal型 |
| lot_id | ロット情報取得用 | - | FK（nullable） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(quantity) | 整数表示 | カンマ区切り |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Packageボタンクリック] --> B[PackageAction実行]
    B --> C[Operation.packages取得]
    C --> D[distinct処理]
    D --> E[Blade templateでHTML生成]
    E --> F[各パッケージごとにセクション生成]
    F --> G[バーコード生成: DNS1D::getBarcodeHTML]
    G --> H{quantities存在?}
    H -->|Yes| I[製品明細テーブル生成]
    H -->|No| J[テーブルスキップ]
    I --> K{ロット情報存在?}
    K -->|Yes| L[ロット情報行追加]
    K -->|No| M[スキップ]
    L --> N[DomPDFでPDF変換]
    M --> N
    J --> N
    N --> O[用紙サイズA4縦設定]
    O --> P[streamDownloadでファイル返却]
    P --> Q[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パッケージなし | packagesが空 | 空のPDF生成 | 空のPDFを出力 |
| 内容物なし | quantitiesが空 | テーブル非表示 | テーブル部分をスキップ |
| パッケージタイプなし | package_type_idがnull | 項目非表示 | 該当セルをスキップ |
| 梱包日なし | pack_dateがnull | 項目非表示 | 該当セルをスキップ |
| バーコードなし | product.barcodeがnull | バーコード非表示 | バーコード部分を空白で表示 |
| ロットなし | lot_idがnull | ロット情報行非表示 | ロット情報行をスキップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1オペレーションあたりパッケージ10個、各パッケージ内製品20件程度 |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- パッケージ内容物情報は企業の在庫管理に関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- ロット/シリアル番号はトレーサビリティに関わる情報
- PDF出力時のログ記録は実装されていない

## 備考

- パッケージはOperationのmoveLinesを経由してresult_package_idで紐づけられ、distinctで重複を除去して取得される
- ロット情報の表示は、TraceabilitySettings.enable_lots_serial_numbersが有効かつ、Quantity.lotが存在する場合のみ表示される
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 製品バーコードの高さは30px、ロットバーコードの高さは33px
- パッケージタイプと梱包日は両方ともオプショナルで、どちらもnullの場合は詳細情報セクション全体が非表示となる
- 本帳票は「パッケージバーコード（内容あり）」（No.8）と同じテンプレートを使用している
