# 帳票設計書 5-ロケーションバーコード (Location Barcode)

## 概要

本ドキュメントは、在庫管理システムにおけるロケーションバーコード（Location Barcode）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

ロケーションバーコードは、倉庫ロケーションのバーコードをPDF形式で一括印刷する機能であり、選択した複数のロケーションのバーコードラベルを一括で出力できる。

**業務上の目的・背景**：ロケーションバーコードは、倉庫内の棚や保管場所にバーコードラベルを貼付することで、ピッキング作業や棚卸作業の効率化を図るための帳票である。作業者がハンディターミナルやバーコードスキャナーでロケーションを読み取ることで、作業場所の特定と作業内容の確認を迅速に行える。また、誤った場所での作業を防止するためのチェック機能としても活用される。

**帳票の利用シーン**：新しいロケーション設置時のラベル印刷、既存ラベルの劣化・汚損時の再印刷、倉庫レイアウト変更時のラベル更新、棚卸作業前の準備として使用する。

**主要な出力内容**：
1. ロケーション名（大文字表示）
2. バーコード（ロケーションのバーコード値）
3. バーコードテキスト

**帳票の出力タイミング**：ロケーション一覧画面で複数のロケーションを選択し、一括アクションの「Print」を実行した際にPDFとしてダウンロードされる。

**帳票の利用者**：倉庫管理者、棚卸担当者、レイアウト管理担当者

## 帳票種別

ラベル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-005 | ロケーション一覧画面 | /inventories/configurations/locations | 複数選択 → 一括アクション「Print」 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Location-Barcode.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票はテーブル形式で複数のラベルを4列で配置する構成となる。各セルにロケーション名とバーコードが表示される。

```
+----------+----------+----------+----------+
| LOC-A01  | LOC-A02  | LOC-A03  | LOC-A04  |
|[barcode] |[barcode] |[barcode] |[barcode] |
| BC001    | BC002    | BC003    | BC004    |
+----------+----------+----------+----------+
| LOC-B01  | LOC-B02  | LOC-B03  |          |
|[barcode] |[barcode] |[barcode] |          |
| BC005    | BC006    | BC007    |          |
+----------+----------+----------+----------+
```

### ラベルセル構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ロケーション名 | ロケーションの識別名（大文字変換） | Location.name | テキスト（12px、青色、大文字、太字） |
| 2 | バーコード | ロケーションのバーコード | Location.barcode | Code128形式、スケール1、高さ30px |
| 3 | バーコードテキスト | バーコード値のテキスト表示 | Location.barcode | テキスト（11px） |

### テーブル仕様

| 項目 | 内容 |
|-----|------|
| 列数 | 4列 |
| セル幅 | 均等分割 |
| セル境界線 | 1px solid #e9ecef |
| セル背景色 | 白 |
| セルパディング | 12px |
| 空セル | 境界線なし（ロケーション数が4の倍数でない場合） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ロケーションID | 選択されたLocation.idの配列 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 選択順 | - |

### データ分割

| 条件 | 説明 |
|-----|------|
| chunk(4) | 4件ずつグループ化してテーブル行を生成 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_locations | ロケーション情報 | 主テーブル |

### テーブル別参照項目詳細

#### inventories_locations

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | ロケーション名 | 選択されたid | テキスト |
| barcode | バーコード値 | - | テキスト（nullable） |

## 計算仕様

### 計算項目一覧

本帳票には計算項目は存在しない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ロケーション一覧画面] --> B[複数ロケーション選択]
    B --> C[一括アクション「Print」クリック]
    C --> D[BulkAction実行]
    D --> E[選択レコード取得]
    E --> F[Blade templateでHTML生成]
    F --> G[4件ずつchunk処理]
    G --> H[各chunkでテーブル行生成]
    H --> I{barcode存在?}
    I -->|Yes| J[バーコード生成: DNS1D::getBarcodeHTML]
    I -->|No| K[バーコード非表示]
    J --> L[DomPDFでPDF変換]
    K --> L
    L --> M[用紙サイズA4縦設定]
    M --> N[streamDownloadでファイル返却]
    N --> O[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 選択レコードが0件 | 空のPDF生成 | 空のテーブルを出力 |
| バーコードなし | barcodeがnull | バーコード非表示 | ロケーション名のみ表示 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回の出力で最大100件程度 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- ロケーション情報は倉庫のレイアウトに関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- ラベルには個人情報は含まれない
- PDF出力時のログ記録は実装されていない

## 備考

- 本帳票はロケーション一覧画面のBulkAction（一括アクション）として実装されている
- ロケーションのbarcode項目がnullの場合、バーコード部分は表示されない（ロケーション名のみ表示）
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 4列構成のため、選択したロケーション数が4の倍数でない場合、最終行の余りセルは空（境界線なし）となる
- ファイル名は「Location-Barcode.pdf」固定で、選択したロケーションに依存しない
- ロケーション名は大文字（strtoupper）で表示される
