# 帳票設計書 6-ロットバーコード (Lot Barcode)

## 概要

本ドキュメントは、在庫管理システムにおけるロットバーコード（Lot Barcode）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

ロットバーコードは、製品ロット/シリアル番号のバーコードをPDF形式で出力する機能であり、選択した複数のロットのバーコードラベルを一括で印刷できる。

**業務上の目的・背景**：ロットバーコードは、製品のトレーサビリティ管理を実現するための帳票である。ロット番号やシリアル番号をバーコード化して製品に貼付することで、入荷から出荷までの製品追跡、品質管理、リコール対応などを効率的に行える。特に食品、医薬品、精密機器などトレーサビリティが重要な業界で必須の機能となる。

**帳票の利用シーン**：入荷時のロットラベル印刷、製造時のシリアル番号ラベル発行、出荷前の製品識別ラベル貼付、品質検査時の追跡確認用として使用する。

**主要な出力内容**：
1. 製品名（紐づく製品がある場合、大文字表示）
2. バーコード（ロット/シリアル番号）
3. バーコードテキスト

**帳票の出力タイミング**：ロット一覧画面で複数のロットを選択し、一括アクションの「Print」を実行した際にPDFとしてダウンロードされる。

**帳票の利用者**：品質管理担当者、入荷検品担当者、製造担当者、棚卸担当者

## 帳票種別

ラベル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-006 | ロット一覧画面 | /inventories/products/lots | 複数選択 → 一括アクション「Print」 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Lot-Barcode.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票はテーブル形式で複数のラベルを3列で配置する構成となる。各セルに製品名（存在する場合）とロットバーコードが表示される。

```
+------------+------------+------------+
| 製品名A    | 製品名B    | 製品名C    |
| [barcode]  | [barcode]  | [barcode]  |
| LOT001     | LOT002     | LOT003     |
+------------+------------+------------+
| 製品名D    | 製品名E    |            |
| [barcode]  | [barcode]  |            |
| LOT004     | LOT005     |            |
+------------+------------+------------+
```

### ラベルセル構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 製品名 | 紐づく製品の名称（大文字変換） | Lot.product.name | テキスト（12px、青色、大文字、太字）※存在する場合のみ |
| 2 | バーコード | ロット/シリアル番号のバーコード | Lot.name | Code128形式、スケール2、高さ33px |
| 3 | バーコードテキスト | ロット/シリアル番号のテキスト表示 | Lot.name | テキスト（11px） |

### テーブル仕様

| 項目 | 内容 |
|-----|------|
| 列数 | 3列 |
| セル幅 | 均等分割 |
| セル境界線 | 1px solid #e9ecef |
| セル背景色 | 白 |
| セルパディング | 12px |
| 空セル | 境界線なし（ロット数が3の倍数でない場合） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ロットID | 選択されたLot.idの配列 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 選択順 | - |

### データ分割

| 条件 | 説明 |
|-----|------|
| chunk(3) | 3件ずつグループ化してテーブル行を生成 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_lots | ロット情報 | 主テーブル |
| products_products | 製品情報 | inventories_lots.product_id = id |

### テーブル別参照項目詳細

#### inventories_lots

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | バーコード値、バーコードテキスト | 選択されたid | テキスト |
| product_id | 製品情報取得用 | - | FK（nullable） |

#### products_products

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 製品名 | lot.product_id一致 | テキスト |

## 計算仕様

### 計算項目一覧

本帳票には計算項目は存在しない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ロット一覧画面] --> B[複数ロット選択]
    B --> C[一括アクション「Print」クリック]
    C --> D[BulkAction実行]
    D --> E[選択レコード取得]
    E --> F[Blade templateでHTML生成]
    F --> G[3件ずつchunk処理]
    G --> H[各chunkでテーブル行生成]
    H --> I{product_id存在?}
    I -->|Yes| J[製品名表示]
    I -->|No| K[製品名スキップ]
    J --> L[バーコード生成: DNS1D::getBarcodeHTML]
    K --> L
    L --> M[DomPDFでPDF変換]
    M --> N[用紙サイズA4縦設定]
    N --> O[streamDownloadでファイル返却]
    O --> P[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 選択レコードが0件 | 空のPDF生成 | 空のテーブルを出力 |
| 製品紐づけなし | product_idがnull | 製品名非表示 | バーコードのみ表示 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回の出力で最大100件程度 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- ロット/シリアル番号情報は製品のトレーサビリティに関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- TraceabilitySettings.enable_lots_serial_numbersが有効な場合のみロット一覧画面が表示される
- PDF出力時のログ記録は実装されていない

## 備考

- 本帳票はロット一覧画面のBulkAction（一括アクション）として実装されている
- ロットのname項目がバーコード値として使用される（常に存在）
- 製品名はproduct_idが存在する場合のみ表示される
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 3列構成のため、選択したロット数が3の倍数でない場合、最終行の余りセルは空（境界線なし）となる
- ファイル名は「Lot-Barcode.pdf」固定で、選択したロットに依存しない
- 製品名は大文字（strtoupper）で表示される
- 本機能はTraceabilitySettings.enable_lots_serial_numbersが有効な場合のみ利用可能
