# 帳票設計書 7-パッケージバーコード（内容なし）(Package Barcode without Content)

## 概要

本ドキュメントは、在庫管理システムにおけるパッケージバーコード（内容なし）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

パッケージバーコード（内容なし）は、パッケージの識別バーコードをシンプルな形式でPDF出力する機能であり、選択した複数のパッケージのバーコードラベルを一括で印刷できる。内容物情報は含まず、パッケージの基本情報とバーコードのみを出力する。

**業務上の目的・背景**：パッケージバーコード（内容なし）は、パッケージ単位での識別・追跡を行うためのシンプルなラベルである。梱包作業時にパッケージに貼付することで、ハンディターミナルやバーコードスキャナーでの読み取りによるパッケージ識別が可能となる。内容物情報を含まないため、印刷コストを抑えつつ基本的な追跡機能を実現できる。

**帳票の利用シーン**：梱包作業時のパッケージラベル印刷、倉庫内でのパッケージ識別、出荷時のパッケージ追跡、パッケージの棚卸作業で使用する。

**主要な出力内容**：
1. パッケージ名（大文字表示）
2. パッケージタイプ（存在する場合）
3. 梱包日（存在する場合）
4. バーコード（パッケージ名）
5. バーコードテキスト

**帳票の出力タイミング**：パッケージ一覧画面で複数のパッケージを選択し、一括アクションの「Print without Content」を実行した際にPDFとしてダウンロードされる。

**帳票の利用者**：倉庫作業者、梱包担当者、出荷担当者、棚卸担当者

## 帳票種別

ラベル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-007 | パッケージ一覧画面 | /inventories/products/packages | 複数選択 → 一括アクション「Print without Content」 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Package-Barcode.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票はテーブル形式で複数のラベルを3列で配置する構成となる。各セルにパッケージ名、パッケージタイプ（オプション）、梱包日（オプション）、バーコードが表示される。

```
+--------------+--------------+--------------+
| PKG001       | PKG002       | PKG003       |
| Type: Box    | Type: Pallet |              |
| Date: 12/27  | Date: 12/26  | Date: 12/25  |
| [barcode]    | [barcode]    | [barcode]    |
| PKG001       | PKG002       | PKG003       |
+--------------+--------------+--------------+
| PKG004       | PKG005       |              |
|              |              |              |
| Date: 12/24  |              |              |
| [barcode]    | [barcode]    |              |
| PKG004       | PKG005       |              |
+--------------+--------------+--------------+
```

### ラベルセル構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | パッケージ名 | パッケージの識別名（大文字変換） | Package.name | テキスト（14px、青色、大文字、太字） |
| 2 | パッケージタイプ | パッケージのタイプ名 | Package.packageType.name | テキスト（11px、グレー）※存在する場合のみ |
| 3 | 梱包日 | パッケージの梱包日 | Package.pack_date | 日付形式（11px、グレー）※存在する場合のみ |
| 4 | バーコード | パッケージ名のバーコード | Package.name | Code128形式、スケール1.5、高さ33px |
| 5 | バーコードテキスト | パッケージ名のテキスト表示 | Package.name | テキスト（12px） |

### テーブル仕様

| 項目 | 内容 |
|-----|------|
| 列数 | 3列 |
| セル幅 | 33%（均等分割） |
| セル境界線 | 1px solid #e9ecef |
| セル背景色 | 白 |
| セルパディング | 12px |
| 空セル | 境界線なし、背景透明（パッケージ数が3の倍数でない場合） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パッケージID | 選択されたPackage.idの配列 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 選択順 | - |

### データ分割

| 条件 | 説明 |
|-----|------|
| chunk(3) | 3件ずつグループ化してテーブル行を生成 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_packages | パッケージ情報 | 主テーブル |
| inventories_package_types | パッケージタイプ | inventories_packages.package_type_id = id |

### テーブル別参照項目詳細

#### inventories_packages

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | パッケージ名、バーコード | 選択されたid | テキスト |
| package_type_id | パッケージタイプ取得用 | - | FK（nullable） |
| pack_date | 梱包日 | - | date型（nullable） |

#### inventories_package_types

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | パッケージタイプ名 | package.package_type_id一致 | テキスト |

## 計算仕様

### 計算項目一覧

本帳票には計算項目は存在しない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[パッケージ一覧画面] --> B[複数パッケージ選択]
    B --> C[一括アクション「Print without Content」クリック]
    C --> D[BulkAction実行]
    D --> E[選択レコード取得]
    E --> F[Blade templateでHTML生成]
    F --> G[3件ずつchunk処理]
    G --> H[各chunkでテーブル行生成]
    H --> I{packageType存在?}
    I -->|Yes| J[パッケージタイプ表示]
    I -->|No| K[パッケージタイプスキップ]
    J --> L{pack_date存在?}
    K --> L
    L -->|Yes| M[梱包日表示]
    L -->|No| N[梱包日スキップ]
    M --> O[バーコード生成: DNS1D::getBarcodeHTML]
    N --> O
    O --> P[DomPDFでPDF変換]
    P --> Q[用紙サイズA4縦設定]
    Q --> R[streamDownloadでファイル返却]
    R --> S[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 選択レコードが0件 | 空のPDF生成 | 空のテーブルを出力 |
| パッケージタイプなし | package_type_idがnull | タイプ非表示 | パッケージタイプ行をスキップ |
| 梱包日なし | pack_dateがnull | 日付非表示 | 梱包日行をスキップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回の出力で最大100件程度 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- パッケージ情報は在庫管理に関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- OperationSettings.enable_packagesが有効な場合のみパッケージ一覧画面が表示される
- PDF出力時のログ記録は実装されていない

## 備考

- 本帳票はパッケージ一覧画面のBulkAction（一括アクション）として実装されている
- 「Print with Content」との違いは内容物情報の有無のみ
- パッケージのname項目がバーコード値として使用される（常に存在）
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 3列構成のため、選択したパッケージ数が3の倍数でない場合、最終行の余りセルは空（境界線なし、背景透明）となる
- ファイル名は「Package-Barcode.pdf」固定で、選択したパッケージに依存しない
- パッケージ名は大文字（strtoupper）で表示される
- 本機能はOperationSettings.enable_packagesが有効な場合のみ利用可能
