# 帳票設計書 8-パッケージバーコード（内容あり）(Package Barcode with Content)

## 概要

本ドキュメントは、在庫管理システムにおけるパッケージバーコード（内容あり）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

パッケージバーコード（内容あり）は、パッケージの識別バーコードに加えて内容物情報を含むPDF帳票を出力する機能であり、選択した複数のパッケージの詳細情報を一括で印刷できる。「パッケージ伝票（No.4）」と同じテンプレートを使用しており、パッケージ一覧画面からの一括出力に対応している。

**業務上の目的・背景**：パッケージバーコード（内容あり）は、パッケージの識別に加えて内容物の確認も同時に行いたい場合に使用するラベルである。出荷検品時や入荷時に、パッケージを開封せずに内容物を確認できるため、作業効率と精度の向上に貢献する。また、顧客への納品時のパッキングリストとしても活用できる。

**帳票の利用シーン**：出荷検品時の内容確認、入荷検品時のパッケージ内容確認、顧客への納品時のパッキングリスト、倉庫内でのパッケージ内容確認で使用する。

**主要な出力内容**：
1. パッケージ名とバーコード
2. パッケージタイプと梱包日
3. 製品明細（製品バーコード、製品名、数量）
4. ロット/シリアル番号情報（設定有効時）
5. 内容確認メッセージ

**帳票の出力タイミング**：パッケージ一覧画面で複数のパッケージを選択し、一括アクションの「Print with Content」を実行した際にPDFとしてダウンロードされる。

**帳票の利用者**：倉庫作業者、出荷検品担当者、入荷検品担当者、配送担当者

## 帳票種別

明細書

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| INV-008 | パッケージ一覧画面 | /inventories/products/packages | 複数選択 → 一括アクション「Print with Content」 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4 |
| 向き | 縦（Portrait） |
| ファイル名 | Package-Barcode.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

## 帳票レイアウト

### レイアウト概要

帳票はパッケージごとにセクションが分かれ、各セクションにパッケージヘッダー、詳細情報、製品明細テーブル、確認メッセージが配置される。複数パッケージを出力する場合は、各パッケージごとにページ分割される。この構成は「パッケージ伝票（No.4）」と同一である。

```
+-----------------------------------------------+
| {パッケージ名}              [バーコード]       |
+-----------------------------------------------+
| Package Type: {タイプ} | Pack Date: {日付}    |
+-----------------------------------------------+
| Barcode     | Product              | Quantity |
|-------------|----------------------|----------|
| [barcode]   | 製品名1              | 10 Units |
| CODE001     |                      |          |
|-------------|----------------------|----------|
| Lot/Serial: LOT001                            |
| [lot barcode]                                 |
+-----------------------------------------------+
|   内容確認メッセージ                           |
+-----------------------------------------------+
```

### パッケージヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | パッケージ名 | パッケージの識別名 | Package.name | テキスト（24px、青色） |
| 2 | パッケージバーコード | パッケージ名のバーコード | Package.name | Code128形式、スケール1.5、高さ33px |
| 3 | バーコードテキスト | パッケージ名のテキスト | Package.name | テキスト（12px、グレー） |

### 詳細情報部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Package Type | パッケージタイプ名 | Package.packageType.name | テキスト（存在する場合のみ） |
| 2 | Pack Date | 梱包日 | Package.pack_date | 日付形式（存在する場合のみ） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Barcode | 製品バーコード | Quantity.product.barcode | Code128バーコード（スケール1、高さ30px） + テキスト | 自動 |
| 2 | Product | 製品名 | Quantity.product.name | テキスト | 自動 |
| 3 | Quantity | 数量と単位 | Quantity.quantity + Quantity.product.uom.name | 数値（カンマ区切り） + 単位 | 自動 |

### ロット情報部（条件付き）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Lot/Serial | ロット/シリアル番号 | Quantity.lot.name | テキスト（太字） |
| 2 | ロットバーコード | ロット番号のバーコード | Quantity.lot.name | Code128形式、スケール1.5、高さ33px |
| 3 | バーコードテキスト | ロット番号のテキスト | Quantity.lot.name | テキスト |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 確認メッセージ | 内容確認の注意メッセージ | 固定文字列 | 中央揃え、グレー文字、0.9em |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パッケージID | 選択されたPackage.idの配列 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 選択順 | - |

### 改ページ条件

複数パッケージを出力する場合、各パッケージごとにページブレークが発生する（page-break-after: always）。最終パッケージでは改ページしない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| inventories_packages | パッケージ情報 | 主テーブル |
| inventories_package_types | パッケージタイプ | inventories_packages.package_type_id = id |
| inventories_quantities | パッケージ内容物 | package_id = inventories_packages.id |
| products_products | 製品マスタ | inventories_quantities.product_id = id |
| support_uoms | 単位マスタ | products_products.uom_id = id |
| inventories_lots | ロット情報 | inventories_quantities.lot_id = id |

### テーブル別参照項目詳細

#### inventories_packages

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | パッケージ名、バーコード | 選択されたid | テキスト |
| package_type_id | パッケージタイプ取得用 | - | FK（nullable） |
| pack_date | 梱包日 | - | date型（nullable） |

#### inventories_quantities

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| product_id | 製品情報取得用 | package_id一致 | FK |
| quantity | 数量 | - | decimal型 |
| lot_id | ロット情報取得用 | - | FK（nullable） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 数量表示 | number_format(quantity) | 整数表示 | カンマ区切り |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[パッケージ一覧画面] --> B[複数パッケージ選択]
    B --> C[一括アクション「Print with Content」クリック]
    C --> D[BulkAction実行]
    D --> E[選択レコード取得]
    E --> F[Blade templateでHTML生成]
    F --> G[各パッケージごとにセクション生成]
    G --> H[バーコード生成: DNS1D::getBarcodeHTML]
    H --> I{quantities存在?}
    I -->|Yes| J[製品明細テーブル生成]
    I -->|No| K[テーブルスキップ]
    J --> L{ロット情報存在?}
    L -->|Yes| M[ロット情報行追加]
    L -->|No| N[スキップ]
    M --> O[DomPDFでPDF変換]
    N --> O
    K --> O
    O --> P[用紙サイズA4縦設定]
    P --> Q[streamDownloadでファイル返却]
    Q --> R[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 選択レコードが0件 | 空のPDF生成 | 空のPDFを出力 |
| 内容物なし | quantitiesが空 | テーブル非表示 | テーブル部分をスキップ |
| パッケージタイプなし | package_type_idがnull | 項目非表示 | 該当セルをスキップ |
| 梱包日なし | pack_dateがnull | 項目非表示 | 該当セルをスキップ |
| バーコードなし | product.barcodeがnull | バーコード非表示 | バーコード部分を空白で表示 |
| ロットなし | lot_idがnull | ロット情報行非表示 | ロット情報行をスキップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回の出力でパッケージ10個、各パッケージ内製品20件程度 |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- パッケージ内容物情報は企業の在庫管理に関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- ロット/シリアル番号はトレーサビリティに関わる情報
- OperationSettings.enable_packagesが有効な場合のみパッケージ一覧画面が表示される
- PDF出力時のログ記録は実装されていない

## 備考

- 本帳票はパッケージ一覧画面のBulkAction（一括アクション）として実装されている
- 「Print without Content」との違いは内容物情報（製品明細、ロット情報）の有無
- 「パッケージ伝票（No.4）」と同じテンプレート（print-with-content.blade.php）を使用している
- ロット情報の表示は、TraceabilitySettings.enable_lots_serial_numbersが有効かつ、Quantity.lotが存在する場合のみ表示される
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 製品バーコードのスケールは1、ロットバーコードのスケールは1.5
- ファイル名は「Package-Barcode.pdf」固定で、「Print without Content」と同じ
- 本機能はOperationSettings.enable_packagesが有効な場合のみ利用可能
