# 帳票設計書 9-製品バーコード (Product Barcode)

## 概要

本ドキュメントは、製品管理システムにおける製品バーコード（Product Barcode）のPDF帳票出力機能について、帳票レイアウト、データ取得仕様、出力条件等を定義する設計書である。

### 本帳票の処理概要

製品バーコードは、製品のバーコードラベルをPDF形式で出力する機能であり、DYMO、2x7、4x7、4x12等の複数フォーマットに対応している。ウィザード形式の入力画面で数量とフォーマットを選択し、指定された形式でラベルを一括生成する。

**業務上の目的・背景**：製品バーコードは、製品の識別・管理を効率化するための帳票である。製品に貼付するバーコードラベルを一括印刷することで、入荷検品、棚卸、出荷検品などの作業でバーコードスキャナーによる迅速な製品確認が可能となる。また、価格表示フォーマットを選択することで、店頭での価格表示ラベルとしても活用できる。

**帳票の利用シーン**：入荷時の製品ラベル印刷、棚卸用の製品識別ラベル発行、店頭での価格表示ラベル印刷、出荷検品用のラベル発行で使用する。

**主要な出力内容**：
1. 製品名（大文字表示）
2. バーコード（製品バーコード）
3. バーコードテキスト
4. 価格（価格表示フォーマット選択時）

**帳票の出力タイミング**：製品一覧画面で複数の製品を選択し、一括アクションの「Print」を実行、ウィザードでオプションを選択後にPDFとしてダウンロードされる。

**帳票の利用者**：製品管理担当者、入荷検品担当者、店舗スタッフ、棚卸担当者

## 帳票種別

ラベル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| PRD-001 | 製品一覧画面 | /products | 複数選択 → 一括アクション「Print」 → ウィザード完了 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | A4（デフォルト）/ DYMO専用サイズ（252.2 x 144ポイント） |
| 向き | 縦（Portrait） |
| ファイル名 | Product-Barcode.pdf |
| 出力方法 | ダウンロード（streamDownload） |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |

### ラベルフォーマット一覧

| フォーマット | 列数 | 価格表示 | 用紙サイズ | バーコードスケール |
|------------|------|---------|-----------|-----------------|
| dymo | 1 | 無 | 252.2 x 144ポイント | 2 |
| 2x7_price | 2 | 有 | A4 | 2 |
| 4x7_price | 4 | 有 | A4 | 1 |
| 4x12 | 4 | 無 | A4 | 1 |
| 4x12_price | 4 | 有 | A4 | 1 |

## 帳票レイアウト

### レイアウト概要

帳票はテーブル形式で複数のラベルを配置する構成となる。選択されたフォーマットに応じて列数が変わり、各セルに製品名、バーコード、価格（オプション）が表示される。

```
+----------+----------+----------+----------+
| PRODUCT1 | PRODUCT2 | PRODUCT3 | PRODUCT4 |
|[barcode] |[barcode] |[barcode] |[barcode] |
| CODE001  | CODE002  | CODE003  | CODE004  |
| $10.00   | $15.00   | $20.00   | $25.00   |
+----------+----------+----------+----------+
| PRODUCT5 | PRODUCT6 | PRODUCT7 | PRODUCT8 |
|[barcode] |[barcode] |[barcode] |[barcode] |
| CODE005  | CODE006  | CODE007  | CODE008  |
| $30.00   | $35.00   | $40.00   | $45.00   |
+----------+----------+----------+----------+
```

### ラベルセル構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 製品名 | 製品名（大文字変換） | Product.name | テキスト（12px、青色、大文字、太字） |
| 2 | バーコード | 製品バーコード | Product.barcode | Code128形式（存在する場合のみ） |
| 3 | バーコードテキスト | バーコード値のテキスト表示 | Product.barcode | テキスト（11px） |
| 4 | 価格 | 製品価格 | Product.price | 数値（小数点2桁、価格フォーマット時のみ） |

## 入力パラメータ

### ウィザード入力項目

| 項目名 | 説明 | 選択肢/入力 | デフォルト |
|-------|------|------------|----------|
| quantity | 各製品の印刷枚数 | 1〜100の整数 | - |
| format | フォーマット | dymo / 2x7_price / 4x7_price / 4x12 / 4x12_price | 2x7_price |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 製品ID | 選択されたProduct.idの配列 | Yes |
| quantity | 各製品のラベル枚数 | Yes |
| format | ラベルフォーマット | Yes |

### ラベル枚数計算

| 項目 | 計算式 |
|-----|--------|
| 総ラベル数 | 入力されたquantity × 選択した製品数 |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| products_products | 製品情報 | 主テーブル |

### テーブル別参照項目詳細

#### products_products

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| name | 製品名 | 選択されたid | テキスト |
| barcode | バーコード値 | - | テキスト（nullable） |
| price | 価格 | - | decimal型 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 価格表示 | number_format(price, 2) | 小数点2桁 | - |
| バーコードスケール | columns == 4 ? 1 : 2 | - | 列数に応じて動的変更 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[製品一覧画面] --> B[複数製品選択]
    B --> C[一括アクション「Print」クリック]
    C --> D[ウィザード表示]
    D --> E[quantity, format入力]
    E --> F[BulkAction実行]
    F --> G[選択レコード取得]
    G --> H[quantity分ラベル展開]
    H --> I[Blade templateでHTML生成]
    I --> J{barcode存在?}
    J -->|Yes| K[バーコード生成: DNS1D::getBarcodeHTML]
    J -->|No| L[バーコードスキップ]
    K --> M{showPrice?}
    L --> M
    M -->|Yes| N[価格表示]
    M -->|No| O[価格スキップ]
    N --> P[DomPDFでPDF変換]
    O --> P
    P --> Q{format=dymo?}
    Q -->|Yes| R[DYMO用紙サイズ設定]
    Q -->|No| S[A4用紙サイズ設定]
    R --> T[streamDownloadでファイル返却]
    S --> T
    T --> U[ブラウザでダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 選択レコードが0件 | 空のPDF生成 | 空のテーブルを出力 |
| バーコードなし | barcodeがnull | バーコード非表示 | 製品名のみ表示 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 最大100枚/製品（quantity上限） |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし（ただしサーバーリソースに依存） |

## セキュリティ考慮事項

- 製品バーコード、価格は企業の製品管理・販売に関わる情報のため、アクセス権限を持つユーザーのみが出力可能
- ラベルには個人情報は含まれない
- PDF出力時のログ記録は実装されていない

## 備考

- 本帳票は製品一覧画面のBulkAction（一括アクション）として実装されている
- バーコードはCode128形式で生成される（DNS1D::getBarcodeHTML使用）
- 製品名は全て大文字（strtoupper）で表示される
- バーコードのスケールは列数に応じて自動調整される（4列の場合は1、2列以下の場合は2）
- DYMOフォーマットは専用用紙サイズ（252.2 x 144ポイント）で出力される
- ファイル名は「Product-Barcode.pdf」固定で、選択した製品に依存しない
- 価格表示はフォーマット名に「price」が含まれる場合のみ表示される
- 製品にbarcodeが設定されていない場合、バーコード部分は非表示となるが、製品名と価格（該当フォーマットの場合）は表示される
