---
generated_at: 2025-12-27 10:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：1-納品伝票 (Delivery Slip)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **同時出力数上限**：制限なしの根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/DeliverySlipAction.php`
- E-02: `plugins/webkul/inventories/resources/views/filament/clusters/operations/actions/print-delivery-slip.blade.php`
- E-03: `plugins/webkul/inventories/src/Models/Operation.php`
- E-04: `plugins/webkul/inventories/src/Models/MoveLine.php`
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル形式はPDF | E-01 (DomPDF使用) | ○ |
| C-02 | 用紙サイズはA4 | E-01 (setPaper('a4')) | ○ |
| C-03 | 向きは縦（Portrait） | E-01 (setPaper('a4', 'portrait')) | ○ |
| C-04 | ファイル名形式 | E-01 (streamDownload関数) | ○ |
| C-05 | 出力方法はstreamDownload | E-01 (response()->streamDownload) | ○ |
| C-06 | 会社名表示（28px青色） | E-02 (style定義) | ○ |
| C-07 | 会社住所表示 | E-02 (company.partner.street1等) | ○ |
| C-08 | 配送先情報表示 | E-02 (record.partner参照) | ○ |
| C-09 | 伝票タイトル形式 | E-02 (Delivery Slip #) | ○ |
| C-10 | 出荷予定日表示 | E-02 (record.scheduled_at) | ○ |
| C-11 | 製品名カラム | E-02 (item.product.name) | ○ |
| C-12 | ロット番号条件付き表示 | E-02 (TraceabilitySettings判定) | ○ |
| C-13 | 数量表示形式 | E-02 (number_format(item.qty)) | ○ |
| C-14 | 単位表示 | E-02 (item.uom.name) | ○ |
| C-15 | 注意事項フッター | E-02 (固定メッセージ) | ○ |
| C-16 | ページブレーク設定 | E-02 (page-break-after CSS) | ○ |
| C-17 | Operationテーブル名 | E-03 (inventories_operations) | ○ |
| C-18 | MoveLineテーブル名 | E-04 (inventories_move_lines) | ○ |
| C-19 | Operationのリレーション | E-03 (moveLines, company, partner) | ○ |
| C-20 | MoveLineのリレーション | E-04 (product, lot, uom) | ○ |
| C-21 | 帳票カテゴリは在庫管理 | E-05 (帳票一覧.csv) | ○ |
| C-22 | 帳票説明 | E-05 (帳票一覧.csv) | ○ |
| C-23 | moveLinesが空の場合の処理 | E-02 (@if条件分岐) | ○ |
| C-24 | partnerがnullの場合の処理 | E-02 (@if条件分岐) | ○ |
| C-25 | companyパートナーnull処理 | E-02 (@if条件分岐) | ○ |
| C-26 | scheduled_atはdatetime型 | E-03 (casts定義) | ○ |
| C-27 | nameはWH/OUT/XXX形式 | E-03 (updateName関数) | ○ |
| C-28 | スラッシュ→アンダースコア変換 | E-01 (str_replace) | ○ |
| C-29 | 複数レコード一括出力対応 | E-02 (@foreach $records) | ○ |
| C-30 | TraceabilitySettings依存 | E-02 (app()呼び出し) | ○ |
| C-31 | UTF-8文字コード | E-02 (meta charset) | ○ |
| C-32 | Helveticaフォント使用 | E-02 (font-family CSS) | ○ |
| C-33 | テーブルの偶数行背景色 | E-02 (nth-child(even) CSS) | ○ |
| C-34 | 想定データ件数100件 | **根拠なし** | △ |
| C-35 | 目標出力時間3秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は推定値であり、実測データや要件定義書からの根拠がない
  - 候補：負荷テスト結果 / システム要件定義書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本仕様は全てコードから確認可能
- 1: 中リスク - パフォーマンス要件は実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TraceabilitySettings設定による表示切替が正しく動作するか確認
- [ ] 複数オペレーション一括出力時のページ分割が正しいか確認
- [ ] 会社情報・配送先情報がnullの場合のレイアウト崩れがないか確認
- [ ] パフォーマンス要件の妥当性を実環境で検証
