---
generated_at: 2025-12-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-見積依頼書/発注書 (RFQ/Purchase Order)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **valid_until項目**：モデルに定義が見当たらないが、Bladeテンプレートで参照されている
  2. **同時出力数上限**：コードからは制限の有無を確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/PrintRFQAction.php`
- E-02: `plugins/webkul/purchases/resources/views/filament/admin/clusters/orders/orders/actions/print-quotation.blade.php`
- E-03: `plugins/webkul/purchases/src/Models/Order.php`
- E-04: `plugins/webkul/purchases/src/Enums/OrderState.php`
- E-05: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PDF形式で出力 | E-01 (PDF::loadView, DomPDF使用) | ○ |
| C-02 | A4縦向き | E-01 ($pdf->setPaper('a4', 'portrait')) | ○ |
| C-03 | ファイル名形式 | E-01 ('Purchase Order-'.str_replace('/', '_', $record->name).'.pdf') | ○ |
| C-04 | streamDownloadで出力 | E-01 (response()->streamDownload) | ○ |
| C-05 | draft/sent状態でのみ表示 | E-01 (visible条件でOrderState::DRAFT, OrderState::SENT) | ○ |
| C-06 | 出力時にSENT状態に更新 | E-01 ($record->update(['state' => OrderState::SENT])) | ○ |
| C-07 | 自社会社情報を表示 | E-02 ($record->company->name, company->partner) | ○ |
| C-08 | サプライヤー情報を表示 | E-02 ($record->partner->name, street1, city等) | ○ |
| C-09 | 見積依頼番号表示 | E-02 (Request for Quotation #{{ $record->name }}) | ○ |
| C-10 | 明細テーブルにDescription表示 | E-02 ($item->name) | ○ |
| C-11 | 明細テーブルにExpected Date表示 | E-02 ($item->planned_at) | ○ |
| C-12 | 明細テーブルにQuantity表示 | E-02 ($item->product_qty.' '.$item->uom->name) | ○ |
| C-13 | 注文名はPO/{id}形式 | E-03 (updateName: 'PO/'.$this->id) | ○ |
| C-14 | テーブル名はpurchases_orders | E-03 (protected $table = 'purchases_orders') | ○ |
| C-15 | OrderStateはEnum型 | E-04 (enum OrderState: string) | ○ |
| C-16 | 5つの状態を持つ | E-04 (DRAFT, SENT, PURCHASE, DONE, CANCELED) | ○ |
| C-17 | 明細はlinesリレーション | E-03 (hasMany(OrderLine::class, 'order_id')) | ○ |
| C-18 | 会社はcompanyリレーション | E-03 (belongsTo(Company::class)) | ○ |
| C-19 | パートナーはpartnerリレーション | E-03 (belongsTo(Partner::class)) | ○ |
| C-20 | UOMはuomリレーション | E-02 ($item->uom->name), E-05 (Select uom_id relationship) | ○ |
| C-21 | PurchaseOrder計算実行 | E-01 (PurchaseOrder::computePurchaseOrder($record)) | ○ |
| C-22 | フォーム更新 | E-01 ($livewire->updateForm()) | ○ |
| C-23 | 改ページ条件 | E-02 (page-break-after: always, :last-child auto) | ○ |
| C-24 | valid_until項目 | E-02 ($record->valid_until) | △ |
| C-25 | 同時出力数上限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **valid_until項目**：Bladeテンプレートで参照されているが、Orderモデルの$fillableに明示的に定義が見当たらない。データベースマイグレーションの確認が必要。
  - 候補：マイグレーションファイル / データベーススキーマ
- **同時出力数上限**：コード上で明示的な制限が設定されていないため「制限なし」と記載したが、インフラ・設定レベルでの制限有無は不明。
  - 候補：サーバー設定 / インフラ設計書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本機能（PDF生成、ダウンロード）は明確に実装されている
- 1: 中リスク - valid_until項目の存在確認が必要
- 0: 低リスク - 状態遷移ロジックは明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] valid_untilカラムがpurchases_ordersテーブルに存在することを確認
- [ ] 実際のPDF出力結果がBladeテンプレートと一致することを確認
- [ ] 状態がSENTに更新されることを動作確認
- [ ] 明細が空の場合の表示を確認
