---
generated_at: 2025-12-27 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：12-購買契約書 (Purchase Agreement)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **payment_term_idリレーション**：モデルに定義が見当たらないが、Bladeで使用されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource/Pages/EditPurchaseAgreement.php`
- E-02: `plugins/webkul/purchases/resources/views/filament/admin/clusters/orders/purchase-agreements/print.blade.php`
- E-03: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php`
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PDF形式で出力 | E-01 (PDF::loadView, DomPDF使用) | ○ |
| C-02 | A4縦向き | E-01 ($pdf->setPaper('a4', 'portrait')) | ○ |
| C-03 | ファイル名形式 | E-01 ('Purchase Agreement-'.str_replace('/', '_', $record->name).'.pdf') | ○ |
| C-04 | streamDownloadで出力 | E-01 (response()->streamDownload) | ○ |
| C-05 | Printボタンはヘッダーアクション | E-01 (getHeaderActions内でAction::make('print')) | ○ |
| C-06 | プリンターアイコン付き | E-01 (->icon('heroicon-o-printer')) | ○ |
| C-07 | 自社会社情報を表示 | E-02 ($record->company->name, company->partner) | ○ |
| C-08 | サプライヤー情報を表示 | E-02 ($record->partner->name, street1, city等) | ○ |
| C-09 | タイプによるタイトル変化 | E-02 (@if ($record->type == 'blanket_order') Blanket Order @else Purchase Agreement) | ○ |
| C-10 | Agreement Validity表示 | E-02 ($record->ends_at) | ○ |
| C-11 | Contact（担当者）表示 | E-02 ($record->user->name) | ○ |
| C-12 | Reference表示 | E-02 ($record->reference) | ○ |
| C-13 | 製品テーブルにProduct表示 | E-02 ($item->product->name) | ○ |
| C-14 | 製品テーブルにQuantity表示 | E-02 (number_format($item->qty)) | ○ |
| C-15 | 製品テーブルにUnit表示 | E-02 ($item->product->uom->name) | ○ |
| C-16 | 製品テーブルにUnit Price表示 | E-02 (number_format($item->price_unit, 2)) | ○ |
| C-17 | UOM表示は設定により切替 | E-02 (app(ProductSettings::class)->enable_uom) | ○ |
| C-18 | Payment Terms表示 | E-02 ($record->paymentTerm->name) | △ |
| C-19 | Additional Terms表示 | E-02 ($record->notes) | ○ |
| C-20 | テーブル名はpurchases_requisitions | E-03 (protected $table = 'purchases_requisitions') | ○ |
| C-21 | 契約名はBO/{id}またはPT/{id}形式 | E-03 (updateName: BO/{id} or PT/{id}) | ○ |
| C-22 | 明細はlinesリレーション | E-03 (hasMany(RequisitionLine::class)) | ○ |
| C-23 | 改ページ条件 | E-02 (page-break-after: always, :last-child auto) | ○ |
| C-24 | 注記メッセージ | E-02 ("This agreement constitutes the entire understanding...") | ○ |

## 4) 不足情報（Unknown / Missing）
- **payment_term_idリレーション**：Bladeテンプレートで`$record->paymentTerm->name`が参照されているが、Requisitionモデルにはリレーション定義が見当たらない。マイグレーションまたは動的リレーションの確認が必要。
  - 候補：マイグレーションファイル / Traitによる動的リレーション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本機能（PDF生成、ダウンロード）は明確に実装されている
- 1: 中リスク - paymentTermリレーションの存在確認が必要
- 0: 低リスク - 契約タイプによるタイトル切替は明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] paymentTermリレーションがRequisitionモデルまたはTrait経由で存在することを確認
- [ ] 実際のPDF出力結果がBladeテンプレートと一致することを確認
- [ ] Blanket OrderとPurchase Agreementの両タイプでタイトルが正しく表示されることを確認
- [ ] UOM設定がOFFの場合に単位列が非表示になることを確認
- [ ] 明細が空の場合の表示を確認
