---
generated_at: 2025-12-27 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：13-見積書 (Sales Quotation)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **total_discount項目**：モデルに明示的な定義が見当たらないが、Bladeで使用されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/SendByEmailAction.php`
- E-02: `plugins/webkul/sales/resources/views/sales/quotation.blade.php`
- E-03: `plugins/webkul/sales/src/Models/Order.php`
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PDF形式で出力 | E-01 (Pdf::loadView), E-02 (HTML構造) | ○ |
| C-02 | A4縦向き | E-01 (setPaper('A4', 'portrait')) | ○ |
| C-03 | デフォルトフォントはArial | E-01 (setOption('defaultFont', 'Arial')) | ○ |
| C-04 | ファイル名形式 | E-01 ($fileName = "$record->name-".time().'.pdf') | ○ |
| C-05 | publicディスクに保存 | E-01 (Storage::disk('public')->put) | ○ |
| C-06 | sales-ordersディレクトリ | E-01 ($filePath = 'sales-orders/'.$fileName) | ○ |
| C-07 | Send by Emailボタン | E-01 (->label(__('...send-by-email.title'))) | ○ |
| C-08 | SALE状態で非表示 | E-01 (->hidden(fn (Order $record) => $record->state == OrderState::SALE)) | ○ |
| C-09 | 自社会社情報を表示 | E-02 ($record->company->name, company->address) | ○ |
| C-10 | 顧客情報を表示 | E-02 ($record->partner->name, partner->addresses) | ○ |
| C-11 | タイプによるタイトル変化 | E-02 (state == OrderState::SALE ? 'Order' : 'Quotation') | ○ |
| C-12 | 見積日付表示 | E-02 ($record->date_order) | ○ |
| C-13 | 有効期限表示 | E-02 ($record->validity_date) | ○ |
| C-14 | 製品テーブルにProduct表示 | E-02 ($item->product->name) | ○ |
| C-15 | 製品テーブルにQuantity表示 | E-02 (number_format($item->product_uom_qty)) | ○ |
| C-16 | 製品テーブルにUnit表示 | E-02 ($item->product->uom->name) | ○ |
| C-17 | 製品テーブルにUnit Price表示 | E-02 (number_format($item->price_unit, 2)) | ○ |
| C-18 | UOM表示は設定により切替 | E-02 (app(ProductSettings::class)->enable_uom) | ○ |
| C-19 | Subtotal表示 | E-02 (currency->symbol + amount_untaxed) | ○ |
| C-20 | Tax表示 | E-02 (currency->symbol + amount_tax) | ○ |
| C-21 | Discount表示 | E-02 (currency->symbol + total_discount) | △ |
| C-22 | Grand Total表示 | E-02 (currency->symbol + amount_total) | ○ |
| C-23 | Payment Information表示 | E-02 (Payment Communication, partnerBank) | ○ |
| C-24 | テーブル名はsales_orders | E-03 (protected $table = 'sales_orders') | ○ |
| C-25 | 注文名はSO/{id}形式 | E-03 (updateName: 'SO/'.$this->id) | ○ |
| C-26 | 明細はlinesリレーション | E-03 (hasMany(OrderLine::class)) | ○ |
| C-27 | SaleOrder::sendQuotationOrOrderByEmail使用 | E-01 (SaleOrder::sendQuotationOrOrderByEmail($record, $data)) | ○ |
| C-28 | 送信結果通知処理 | E-01 (handleEmailResults, Notification::make) | ○ |

## 4) 不足情報（Unknown / Missing）
- **total_discount項目**：Bladeテンプレートで`$record->total_discount`が参照されているが、Orderモデルの$fillableに明示的な定義が見当たらない。アクセサまたはマイグレーションの確認が必要。
  - 候補：マイグレーションファイル / getterメソッド / アクセサ定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本機能（PDF生成、メール送信）は明確に実装されている
- 1: 中リスク - total_discount項目の存在確認が必要
- 0: 低リスク - メール送信結果のハンドリングは詳細に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] total_discountカラムがsales_ordersテーブルに存在する、またはアクセサで計算されていることを確認
- [ ] 実際のPDF出力結果がBladeテンプレートと一致することを確認
- [ ] QuotationとOrderの両状態でタイトルが正しく表示されることを確認
- [ ] メール送信成功/失敗時の通知が正しく表示されることを確認
- [ ] UOM設定がOFFの場合に単位列が非表示になることを確認
- [ ] publicディスクへのPDF保存とアクセス制御を確認
