---
generated_at: 2025-12-27 10:45:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-請求書 (Invoice)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/PrintAndSendAction.php`
- E-02: `plugins/webkul/accounts/resources/views/invoice/actions/preview/index.blade.php`
- E-03: `plugins/webkul/accounts/src/Models/Move.php`
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PDF形式で出力 | E-01 (PDFHandler Trait使用) | ○ |
| C-02 | ファイル名形式 | E-01 ('invoice-'.$record->created_at->format('d-m-Y')) | ○ |
| C-03 | プレビュービューを使用 | E-01 (view('accounts::invoice/actions/preview.index')) | ○ |
| C-04 | PDFHandler::savePDF使用 | E-01 ($this->savePDF(...)) | ○ |
| C-05 | Print & Sendボタン | E-01 (->label(__('...print-and-send.title'))) | ○ |
| C-06 | posted/cancel状態で表示 | E-01 (visible: MoveState::CANCEL or POSTED) | ○ |
| C-07 | 封筒アイコン | E-01 (->icon('heroicon-o-envelope')) | ○ |
| C-08 | 複数ファイル添付可能 | E-01 (FileUpload->multiple()) | ○ |
| C-09 | 自社会社情報を表示 | E-02 ($record->company->name, company->partner) | ○ |
| C-10 | 顧客情報を表示 | E-02 ($record->partner->name, street1, city等) | ○ |
| C-11 | Invoice IDタイトル | E-02 (Invoice ID #{{ $record->name }}) | ○ |
| C-12 | Invoice Date表示 | E-02 ($record->invoice_date) | ○ |
| C-13 | Due Date表示 | E-02 ($record->invoice_date_due?->format('Y-m-d')) | ○ |
| C-14 | 製品テーブルにProduct表示 | E-02 ($item->product->name) | ○ |
| C-15 | 製品テーブルにQuantity表示 | E-02 (number_format($item->quantity)) | ○ |
| C-16 | 製品テーブルにUnit表示 | E-02 ($item->product->uom->name) | ○ |
| C-17 | 製品テーブルにUnit Price表示 | E-02 (number_format($item->price_unit, 2)) | ○ |
| C-18 | UOM表示は設定により切替 | E-02 (app(ProductSettings::class)->enable_uom) | ○ |
| C-19 | Subtotal表示 | E-02 (currency->symbol + amount_untaxed) | ○ |
| C-20 | Tax表示 | E-02 (currency->symbol + amount_tax) | ○ |
| C-21 | Discount表示 | E-02 (currency->symbol + total_discount) | ○ |
| C-22 | Grand Total表示 | E-02 (currency->symbol + amount_total) | ○ |
| C-23 | Payment Information表示 | E-02 (Payment Communication, partnerBank) | ○ |
| C-24 | テーブル名 | E-03 (protected $table = 'accounts_account_moves') | ○ |
| C-25 | 請求書番号プレフィックス | E-03 (updateSequencePrefix: INV, RINV, BILL, RBILL) | ○ |
| C-26 | 明細はlinesリレーション | E-03 (hasMany(MoveLine::class)->where('display_type', 'product')) | ○ |
| C-27 | total_discountアクセサ | E-03 (getTotalDiscountAttributeメソッド) | ○ |
| C-28 | Account::printAndSend使用 | E-01 (Account::printAndSend($record, $data)) | ○ |
| C-29 | モーダルアイコン | E-01 (->modalIcon('heroicon-m-paper-airplane')) | ○ |
| C-30 | デフォルトメール本文 | E-01 (description変数にHTML形式の本文設定) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張に対して根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本機能（PDF生成、メール送信）は明確に実装されている
- 0: 低リスク - 状態制御は明確に実装されている
- 0: 低リスク - 金額計算ロジックは明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のPDF出力結果がBladeテンプレートと一致することを確認
- [ ] posted/cancel両状態でボタンが表示されることを確認
- [ ] メール送信成功時の動作を確認
- [ ] UOM設定がOFFの場合に単位列が非表示になることを確認
- [ ] 請求書番号のプレフィックス（INV, RINV, BILL, RBILL）が正しく設定されることを確認
- [ ] 明細が空の場合の表示を確認
