---
generated_at: 2025-12-27 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：15-請求書プレビュー (Invoice Preview)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **テンプレート共有**：PreviewActionでのsetTemplate呼び出し箇所が確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/PreviewAction.php`
- E-02: `plugins/webkul/accounts/resources/views/invoice/actions/preview/index.blade.php`
- E-03: `plugins/webkul/accounts/src/Models/Move.php`
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLビューとして表示 | E-01 (modalContent(fn (Move $record) => view(...))) | ○ |
| C-02 | モーダルダイアログ形式 | E-01 (modalHeading, modalContent) | ○ |
| C-03 | posted状態でのみ表示 | E-01 (visible(fn (Move $record) => $record->state == MoveState::POSTED)) | ○ |
| C-04 | Previewボタン | E-01 (->label(__('...preview.title'))) | ○ |
| C-05 | viewfinder-circleアイコン | E-01 (->icon('heroicon-o-viewfinder-circle')) | ○ |
| C-06 | 送信ボタン非表示 | E-01 (->modalSubmitAction(false)) | ○ |
| C-07 | setTemplateメソッド | E-01 (public function setTemplate(string $template)) | ○ |
| C-08 | テンプレート存在確認 | E-01 (if (! view()->exists($template)) throw new InvalidArgumentException) | ○ |
| C-09 | PDFHandler Trait使用 | E-01 (use PDFHandler) | ○ |
| C-10 | 自社会社情報を表示 | E-02 ($record->company->name, company->partner) | ○ |
| C-11 | 顧客情報を表示 | E-02 ($record->partner->name, street1, city等) | ○ |
| C-12 | Invoice IDタイトル | E-02 (Invoice ID #{{ $record->name }}) | ○ |
| C-13 | Invoice Date表示 | E-02 ($record->invoice_date) | ○ |
| C-14 | Due Date表示 | E-02 ($record->invoice_date_due?->format('Y-m-d')) | ○ |
| C-15 | 製品テーブル表示 | E-02 ($item->product->name, quantity, price_unit) | ○ |
| C-16 | UOM表示は設定により切替 | E-02 (app(ProductSettings::class)->enable_uom) | ○ |
| C-17 | 金額サマリー表示 | E-02 (amount_untaxed, amount_tax, total_discount, amount_total) | ○ |
| C-18 | Payment Information表示 | E-02 (Payment Communication, partnerBank) | ○ |
| C-19 | テーブル名 | E-03 (protected $table = 'accounts_account_moves') | ○ |
| C-20 | 明細はlinesリレーション | E-03 (hasMany(MoveLine::class)->where('display_type', 'product')) | ○ |
| C-21 | total_discountアクセサ | E-03 (getTotalDiscountAttributeメソッド) | ○ |
| C-22 | 請求書とテンプレート共有 | E-02 (同一ビューファイル) | △ |

## 4) 不足情報（Unknown / Missing）
- **テンプレート共有の確認**：PreviewActionでのsetTemplate呼び出し箇所（InvoiceResourceなど）が確認できていない。実際の使用時にどのテンプレートが指定されるかは呼び出し元の確認が必要。
  - 候補：InvoiceResource.php / EditInvoice.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プレビュー機能の基本動作は明確に実装されている
- 1: 中リスク - setTemplateの呼び出し元でのテンプレート指定の確認が必要
- 0: 低リスク - 状態制御は明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] InvoiceResourceまたは関連ファイルでsetTemplateが呼び出されていることを確認
- [ ] 実際のプレビュー表示がBladeテンプレートと一致することを確認
- [ ] posted状態でのみボタンが表示されることを確認（cancelでは非表示）
- [ ] モーダルに送信ボタンが表示されないことを確認
- [ ] UOM設定がOFFの場合に単位列が非表示になることを確認
- [ ] 明細が空の場合の表示を確認
