---
generated_at: 2025-12-27 10:05:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：2-ピッキング作業書 (Picking Operations)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **同時出力数上限**：制限なしの根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/PickingOperationAction.php`
- E-02: `plugins/webkul/inventories/resources/views/filament/clusters/operations/actions/print-picking-operations.blade.php`
- E-03: `plugins/webkul/inventories/src/Models/Operation.php`
- E-04: `plugins/webkul/inventories/src/Models/MoveLine.php`
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル形式はPDF | E-01 (DomPDF使用) | ○ |
| C-02 | 用紙サイズはA4 | E-01 (setPaper('a4')) | ○ |
| C-03 | 向きは縦（Portrait） | E-01 (setPaper('a4', 'portrait')) | ○ |
| C-04 | ファイル名形式 | E-01 (streamDownload関数) | ○ |
| C-05 | 出力方法はstreamDownload | E-01 (response()->streamDownload) | ○ |
| C-06 | 会社名表示（28px青色） | E-02 (style定義) | ○ |
| C-07 | 会社住所表示 | E-02 (company.partner.street1等) | ○ |
| C-08 | 倉庫住所表示 | E-02 (destinationLocation.warehouse.partnerAddress) | ○ |
| C-09 | 仕入先住所表示 | E-02 (record.partner参照) | ○ |
| C-10 | 伝票タイトル形式（Packing Slip） | E-02 (Packing Slip #) | ○ |
| C-11 | オペレーションバーコード表示 | E-02 (DNS1D::getBarcodeHTML) | ○ |
| C-12 | ステータス表示 | E-02 (record.state.name) | ○ |
| C-13 | 予定日時表示 | E-02 (record.scheduled_at) | ○ |
| C-14 | 製品名カラム | E-02 (item.product.name) | ○ |
| C-15 | 数量と単位表示 | E-02 (number_format + uom.name) | ○ |
| C-16 | 保管先ロケーション表示 | E-02 (item.destinationLocation.full_name) | ○ |
| C-17 | パッケージ名併記 | E-02 (result_package_id条件分岐) | ○ |
| C-18 | ロット番号条件付き表示 | E-02 (TraceabilitySettings判定) | ○ |
| C-19 | ロットバーコード表示 | E-02 (lot.name DNS1D) | ○ |
| C-20 | 製品バーコード表示 | E-02 (product.barcode DNS1D) | ○ |
| C-21 | 確認メッセージフッター | E-02 (固定メッセージ) | ○ |
| C-22 | ページブレーク設定 | E-02 (page-break-after CSS) | ○ |
| C-23 | Operationテーブル名 | E-03 (inventories_operations) | ○ |
| C-24 | MoveLineテーブル名 | E-04 (inventories_move_lines) | ○ |
| C-25 | Operationのリレーション | E-03 (moveLines, company, partner, destinationLocation) | ○ |
| C-26 | MoveLineのリレーション | E-04 (product, lot, uom, destinationLocation, resultPackage) | ○ |
| C-27 | 帳票カテゴリは在庫管理 | E-05 (帳票一覧.csv) | ○ |
| C-28 | 帳票説明 | E-05 (帳票一覧.csv) | ○ |
| C-29 | moveLinesが空の場合の処理 | E-02 (@if条件分岐) | ○ |
| C-30 | partnerがnullの場合の処理 | E-02 (@if条件分岐) | ○ |
| C-31 | バーコード高さ44px | E-02 (DNS1D height引数) | ○ |
| C-32 | ロットバーコード高さ33px | E-02 (DNS1D height引数) | ○ |
| C-33 | Code128形式 | E-02 (DNS1D 'C128') | ○ |
| C-34 | UTF-8文字コード | E-02 (meta charset) | ○ |
| C-35 | 複数レコード一括出力対応 | E-02 (@foreach $records) | ○ |
| C-36 | state はEnum型 | E-03 (casts定義) | ○ |
| C-37 | スラッシュ→アンダースコア変換 | E-01 (str_replace) | ○ |
| C-38 | テーブルの偶数行背景色 | E-02 (nth-child(even) CSS) | ○ |
| C-39 | 想定データ件数100件 | **根拠なし** | △ |
| C-40 | 目標出力時間5秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は推定値であり、実測データや要件定義書からの根拠がない
  - 候補：負荷テスト結果 / システム要件定義書 / SLA定義書
- バーコード生成のパフォーマンス影響についての検証データがない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本仕様は全てコードから確認可能
- 1: 中リスク - バーコード多数生成時のパフォーマンス検証が必要
- 0: 低リスク - TraceabilitySettings依存の条件分岐は明確

## 6) レビュアーチェックリスト（最小）
- [ ] TraceabilitySettings設定による表示切替が正しく動作するか確認
- [ ] バーコードが正しく生成・表示されるか確認（Code128形式）
- [ ] 倉庫住所・仕入先住所がnullの場合のレイアウト崩れがないか確認
- [ ] result_package_idがある場合のパッケージ名併記が正しいか確認
- [ ] パフォーマンス要件の妥当性を実環境で検証（特にバーコード多数の場合）
