---
generated_at: 2025-12-27 10:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：4-パッケージ伝票 (Package)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：目標出力時間の根拠なし
  2. **同時出力数上限**：制限なしの根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/Print/PackageAction.php`
- E-02: `plugins/webkul/inventories/resources/views/filament/clusters/products/packages/actions/print-with-content.blade.php`
- E-03: `plugins/webkul/inventories/src/Models/Operation.php`
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル形式はPDF | E-01 (DomPDF使用) | ○ |
| C-02 | 用紙サイズはA4 | E-01 (setPaper('a4')) | ○ |
| C-03 | 向きは縦（Portrait） | E-01 (setPaper('a4', 'portrait')) | ○ |
| C-04 | ファイル名形式 | E-01 (Package-{name}.pdf) | ○ |
| C-05 | 出力方法はstreamDownload | E-01 (response()->streamDownload) | ○ |
| C-06 | パッケージ名表示 | E-02 (record.name) | ○ |
| C-07 | パッケージバーコード表示 | E-02 (DNS1D::getBarcodeHTML) | ○ |
| C-08 | パッケージタイプ条件付き表示 | E-02 (@if package_type_id) | ○ |
| C-09 | 梱包日条件付き表示 | E-02 (@if pack_date) | ○ |
| C-10 | 製品明細テーブル | E-02 (quantities foreach) | ○ |
| C-11 | 製品バーコード表示 | E-02 (product.barcode DNS1D) | ○ |
| C-12 | 製品名表示 | E-02 (product.name) | ○ |
| C-13 | 数量表示（カンマ区切り） | E-02 (number_format) | ○ |
| C-14 | 単位表示 | E-02 (product.uom.name) | ○ |
| C-15 | ロット情報条件付き表示 | E-02 (TraceabilitySettings判定) | ○ |
| C-16 | ロットバーコード表示 | E-02 (lot.name DNS1D) | ○ |
| C-17 | 確認メッセージフッター | E-02 (固定メッセージ) | ○ |
| C-18 | ページブレーク設定 | E-02 (page-break-after CSS) | ○ |
| C-19 | packagesの取得方法 | E-01 (packages()->distinct()) | ○ |
| C-20 | packages経由でmoveLines参照 | E-03 (hasManyThrough) | ○ |
| C-21 | Code128バーコード形式 | E-02 ('C128') | ○ |
| C-22 | 製品バーコード高さ30px | E-02 (height引数) | ○ |
| C-23 | ロットバーコード高さ33px | E-02 (height引数) | ○ |
| C-24 | 帳票カテゴリは在庫管理 | E-04 (帳票一覧.csv) | ○ |
| C-25 | 帳票説明 | E-04 (帳票一覧.csv) | ○ |
| C-26 | quantitiesが空の場合の処理 | E-02 (@if条件分岐) | ○ |
| C-27 | バーコードなし時の処理 | E-02 (@if条件) | ○ |
| C-28 | UTF-8文字コード | E-02 (meta charset) | ○ |
| C-29 | スラッシュ→アンダースコア変換 | E-01 (str_replace) | ○ |
| C-30 | 複数パッケージ一括出力対応 | E-02 (@foreach $records) | ○ |
| C-31 | テーブルの偶数行背景色 | E-02 (nth-child(even) CSS) | ○ |
| C-32 | ロット情報行のスタイル | E-02 (lot-info CSS) | ○ |
| C-33 | パッケージタイトルスタイル | E-02 (package-title CSS) | ○ |
| C-34 | 想定データ件数 | **根拠なし** | △ |
| C-35 | 目標出力時間5秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は推定値であり、実測データや要件定義書からの根拠がない
  - 候補：負荷テスト結果 / システム要件定義書 / SLA定義書
- inventories_quantitiesテーブルの詳細構造に関する情報

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票の基本仕様は全てコードから確認可能
- 1: 中リスク - パッケージ多数の場合のパフォーマンス検証が必要
- 0: 低リスク - TraceabilitySettings依存の条件分岐は明確

## 6) レビュアーチェックリスト（最小）
- [ ] パッケージが複数ある場合のページ分割が正しいか確認
- [ ] パッケージタイプ・梱包日がnullの場合の表示を確認
- [ ] 製品バーコードがnullの場合のレイアウト崩れがないか確認
- [ ] ロット情報の表示/非表示がTraceabilitySettings設定に連動するか確認
- [ ] パフォーマンス要件の妥当性を実環境で検証
