---
generated_at: 2025-12-27 12:30:00
metrics:
  claims_total: 83
  claims_with_evidence: 78
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された業務要件一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：78 / 83、根拠なし：5
- 優先レビュー（高）
  1. **No.67 タイムシート入力**：週次・月次集計機能の実装詳細が不明確
  2. **No.78 ページ管理**：SEO設定機能の実装範囲が未確認
  3. **No.82 プラグイン管理**：依存関係チェック機能の詳細が不明確
  4. **No.71 価格リスト管理**：割引ルールの詳細仕様が未確認
  5. **No.58 休暇発生プラン管理**：繰越・失効ルールの詳細実装が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### ソースコード
- E-01: `plugins/webkul/sales/src/SaleManager.php` - 販売注文ワークフロー
- E-02: `plugins/webkul/sales/src/Enums/OrderState.php` - 販売注文ステータス定義
- E-03: `plugins/webkul/purchases/src/PurchaseOrder.php` - 購買注文ワークフロー
- E-04: `plugins/webkul/purchases/src/Enums/OrderState.php` - 購買注文ステータス定義
- E-05: `plugins/webkul/accounts/src/Enums/MoveState.php` - 会計仕訳ステータス定義
- E-06: `plugins/webkul/inventories/src/Enums/OperationState.php` - 在庫オペレーションステータス
- E-07: `plugins/webkul/time-off/src/Enums/State.php` - 休暇申請ステータス定義
- E-08: `plugins/webkul/projects/src/Enums/TaskState.php` - タスクステータス定義
- E-09: `plugins/webkul/recruitments/src/Enums/ApplicationStatus.php` - 採用ステータス定義
- E-10: `plugins/webkul/sales/src/Models/Order.php` - 販売注文モデル

### 既存ドキュメント
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` - 全369画面の一覧
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 全114機能の一覧

### Filamentリソース（CRUD操作の実装）
- E-13: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource` - 見積書リソース
- E-14: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource` - 受注リソース
- E-15: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource` - 見積依頼リソース
- E-16: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource` - 発注書リソース
- E-17: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource` - 入庫リソース
- E-18: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource` - 出庫リソース
- E-19: `plugins/webkul/employees/src/Filament/Resources/EmployeeResource` - 従業員リソース
- E-20: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource` - 応募者リソース
- E-21: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyTimeOffResource` - 休暇申請リソース
- E-22: `plugins/webkul/projects/src/Filament/Resources/TaskResource` - タスクリソース

## 3) Claims と根拠の対応（レビューの主戦場）

### 販売管理（No.1-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 見積書を新規作成できる | E-01, E-02, E-13 | ○ |
| C-02 | 見積書をメール送信できる | E-01 (sendQuotationOrOrderByEmail) | ○ |
| C-03 | 見積書を受注に変換できる | E-01 (confirmSaleOrder) | ○ |
| C-04 | 受注をキャンセルできる | E-01 (cancelSaleOrder) | ○ |
| C-05 | 受注をロック・アンロックできる | E-01 (lockAndUnlock) | ○ |
| C-06 | 請求書を発行できる | E-01 (createInvoice) | ○ |
| C-07 | 配送状況を確認できる | E-01 (computeDeliveryStatus) | ○ |
| C-08 | 顧客情報を管理できる | E-11, E-14 | ○ |
| C-09 | 商品価格を設定できる | E-11, E-12 | ○ |
| C-10 | 販売チームを管理できる | E-11, E-12 | ○ |

### 購買管理（No.11-19）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 見積依頼を作成できる | E-03, E-04, E-15 | ○ |
| C-12 | 見積依頼をメール送信できる | E-03 (sendRFQ) | ○ |
| C-13 | 発注書を確認できる | E-03 (confirmPurchaseOrder) | ○ |
| C-14 | 発注書をキャンセルできる | E-03 (cancelPurchaseOrder) | ○ |
| C-15 | 発注書をロック・アンロックできる | E-03 (lockPurchaseOrder, unlockPurchaseOrder) | ○ |
| C-16 | 仕入先請求書を発行できる | E-03 (createPurchaseOrderBill) | ○ |
| C-17 | 入庫状況を確認できる | E-03 (computeReceiptStatus) | ○ |
| C-18 | 仕入先情報を管理できる | E-11, E-16 | ○ |
| C-19 | 仕入先価格を管理できる | E-11, E-12 | ○ |

### 在庫管理（No.20-30）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | 入庫処理ができる | E-06, E-17 | ○ |
| C-21 | 出庫処理ができる | E-06, E-18 | ○ |
| C-22 | 内部移動ができる | E-06, E-11 | ○ |
| C-23 | 在庫廃棄ができる | E-06, E-11 | ○ |
| C-24 | オペレーション検証ができる | E-06 | ○ |
| C-25 | オペレーションキャンセルができる | E-06 | ○ |
| C-26 | 倉庫管理ができる | E-11, E-12 | ○ |
| C-27 | ロケーション管理ができる | E-11, E-12 | ○ |
| C-28 | 在庫ルート管理ができる | E-11, E-12 | ○ |
| C-29 | ロット管理ができる | E-11, E-12 | ○ |
| C-30 | パッケージ管理ができる | E-11, E-12 | ○ |

### 会計管理（No.31-41）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | 顧客請求書を作成できる | E-05, E-11 | ○ |
| C-32 | 請求書を確認・転記できる | E-05 | ○ |
| C-33 | 請求書をキャンセルできる | E-05 | ○ |
| C-34 | クレジットノートを発行できる | E-11, E-12 | ○ |
| C-35 | 入金処理ができる | E-11, E-12 | ○ |
| C-36 | 仕入先請求書を処理できる | E-11, E-12 | ○ |
| C-37 | 支払処理ができる | E-11, E-12 | ○ |
| C-38 | 勘定科目を管理できる | E-11, E-12 | ○ |
| C-39 | 仕訳帳を管理できる | E-11, E-12 | ○ |
| C-40 | 税設定を管理できる | E-11, E-12 | ○ |
| C-41 | 支払条件を管理できる | E-11, E-12 | ○ |

### 人事管理（No.42-47）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | 従業員を登録できる | E-11, E-19 | ○ |
| C-43 | 従業員スキルを管理できる | E-11, E-12 | ○ |
| C-44 | 従業員履歴書を管理できる | E-11, E-12 | ○ |
| C-45 | 部門を管理できる | E-11, E-12 | ○ |
| C-46 | 職位を管理できる | E-11, E-12 | ○ |
| C-47 | 勤務カレンダーを管理できる | E-11, E-12 | ○ |

### 採用管理（No.48-53）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | 求人を作成できる | E-09, E-11 | ○ |
| C-49 | 応募者を登録できる | E-09, E-20 | ○ |
| C-50 | 選考ステージを管理できる | E-09, E-20 | ○ |
| C-51 | 採用決定ができる | E-09 (ApplicationStatus::HIRED) | ○ |
| C-52 | 不採用処理ができる | E-09 (ApplicationStatus::REFUSED) | ○ |
| C-53 | 候補者プールを管理できる | E-11, E-12 | ○ |

### 休暇管理（No.54-60）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | 休暇申請ができる | E-07, E-21 | ○ |
| C-55 | 休暇承認ができる | E-07 (VALIDATE_ONE, VALIDATE_TWO) | ○ |
| C-56 | 休暇割当を管理できる | E-11, E-12 | ○ |
| C-57 | 休暇タイプを管理できる | E-11, E-12 | ○ |
| C-58 | 休暇発生プランを管理できる | E-11, E-12 | △ |
| C-59 | 祝日を管理できる | E-11, E-12 | ○ |
| C-60 | 休暇残高を確認できる | E-11, E-21 | ○ |

### プロジェクト管理（No.61-66）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | プロジェクトを作成できる | E-11, E-22 | ○ |
| C-62 | タスクを作成できる | E-08, E-22 | ○ |
| C-63 | タスク状態を管理できる | E-08 (TaskState) | ○ |
| C-64 | サブタスクを管理できる | E-11, E-12 | ○ |
| C-65 | マイルストーンを管理できる | E-11, E-12 | ○ |
| C-66 | タスク工数を入力できる | E-11, E-12 | ○ |

### 工数管理（No.67）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | タイムシートを入力できる | E-11, E-12 | △ |

### 商品管理（No.68-71）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | 商品を登録できる | E-11, E-12 | ○ |
| C-69 | 商品バリエーションを管理できる | E-11, E-12 | ○ |
| C-70 | 商品カテゴリを管理できる | E-11, E-12 | ○ |
| C-71 | 価格リストを管理できる | E-11, E-12 | △ |

### 連絡先管理（No.72-74）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | パートナーを登録できる | E-10, E-11 | ○ |
| C-73 | 住所を管理できる | E-11 | ○ |
| C-74 | 銀行口座を管理できる | E-11, E-12 | ○ |

### ブログ管理（No.75-77）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | 記事を作成できる | E-11, E-12 | ○ |
| C-76 | 記事カテゴリを管理できる | E-11, E-12 | ○ |
| C-77 | 記事タグを管理できる | E-11, E-12 | ○ |

### ウェブサイト管理（No.78）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | ページを管理できる | E-11, E-12 | △ |

### セキュリティ管理（No.79-81）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | ユーザーを管理できる | E-11, E-12 | ○ |
| C-80 | ロールを管理できる | E-11, E-12 | ○ |
| C-81 | 会社を管理できる | E-11, E-12 | ○ |

### システム管理（No.82-83）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | プラグインを管理できる | E-11, E-12 | △ |
| C-83 | カスタムフィールドを管理できる | E-11, E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- **休暇発生プラン管理（C-58）**：繰越・失効ルールの詳細実装が確認できず
  - 候補：LeaveAccrualPlan モデルの詳細確認 / 累積プラン関連の設定画面確認
- **タイムシート入力（C-67）**：週次・月次集計機能の実装詳細が不明
  - 候補：TimesheetResource の集計ロジック確認 / レポート機能の確認
- **価格リスト管理（C-71）**：割引ルールの詳細仕様が未確認
  - 候補：PriceRule モデルの詳細確認 / 価格計算ロジックの確認
- **ページ管理（C-78）**：SEO設定機能の実装範囲が未確認
  - 候補：PageResource の詳細確認 / メタデータ設定機能の確認
- **プラグイン管理（C-82）**：依存関係チェック機能の詳細が不明
  - 候補：PluginManagerServiceProvider の詳細確認

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：販売管理・購買管理・在庫管理の主要ワークフロー
  - SaleManager, PurchaseOrder クラスで明確にビジネスロジックが実装されている
- **リスク0（低）**：会計管理の基本機能
  - MoveState enum で状態遷移が明確に定義されている
- **リスク1（中）**：休暇管理の累積プラン機能
  - 画面・機能は存在するが、詳細ロジックの確認が必要
- **リスク1（中）**：ウェブサイト管理のSEO機能
  - CMS機能は存在するが、SEO設定の詳細が不明
- **リスク1（中）**：プラグイン管理の依存関係チェック
  - プラグイン管理機能は存在するが、依存関係チェックの詳細が不明

## 6) レビュアーチェックリスト（最小）
- [ ] 販売管理（No.1-10）：見積書から受注への変換フローが業務要件と一致しているか
- [ ] 購買管理（No.11-19）：見積依頼から発注への変換フローが業務要件と一致しているか
- [ ] 在庫管理（No.20-30）：入庫・出庫・移動のオペレーションが業務運用に適合しているか
- [ ] 会計管理（No.31-41）：請求書・支払の消込処理が経理業務と一致しているか
- [ ] 人事管理（No.42-47）：従業員・部門・職位の階層構造が組織と一致しているか
- [ ] 採用管理（No.48-53）：選考ステージが実際の採用フローと一致しているか
- [ ] 休暇管理（No.54-60）：休暇タイプ・承認フローが就業規則と一致しているか
- [ ] プロジェクト管理（No.61-66）：タスク状態遷移がプロジェクト運用と一致しているか
- [ ] △マークの項目（C-58, C-67, C-71, C-78, C-82）について詳細確認が必要
