# 機能一覧 信頼度レポート

## 概要

本レポートは、AureusERP プロジェクトから抽出した機能一覧の信頼度と根拠を示すものです。

- **対象プロジェクト**: AureusERP (aureuserp-master)
- **生成日時**: 2025-12-26
- **総機能数**: 114件
- **総合信頼度**: 85%

## 分析手法

### 情報源

1. **README.md**: プロジェクト概要、プラグイン一覧、機能説明
2. **composer.json**: プラグイン構成、依存関係
3. **Filament Resources**: 各プラグインのFilamentリソースクラス
4. **Models**: データモデル構造
5. **Service Providers**: プラグイン登録情報

### 分析対象ディレクトリ

```
/plugins/webkul/
  - accounts/          (会計管理)
  - analytics/         (アナリティクス)
  - blogs/             (ブログ管理)
  - chatter/           (チャッター)
  - contacts/          (連絡先管理)
  - employees/         (人事管理)
  - fields/            (カスタムフィールド)
  - full-calendar/     (カレンダー)
  - inventories/       (在庫管理)
  - invoices/          (請求管理)
  - partners/          (パートナー管理)
  - payments/          (決済管理)
  - plugin-manager/    (プラグイン管理)
  - products/          (商品管理)
  - projects/          (プロジェクト管理)
  - purchases/         (購買管理)
  - recruitments/      (採用管理)
  - sales/             (販売管理)
  - security/          (セキュリティ)
  - support/           (サポート)
  - table-views/       (テーブルビュー)
  - time-off/          (休暇管理)
  - timesheets/        (工数管理)
  - website/           (ウェブサイト管理)
```

## カテゴリ別信頼度

| カテゴリ | 機能数 | 信頼度 | 根拠 |
|---------|--------|--------|------|
| コアシステム | 11 | 90% | README.md記載、Filamentリソース確認済み |
| 販売管理 | 13 | 90% | Filament Resources/Clustersから詳細確認 |
| 購買管理 | 9 | 85% | Filament Admin構造から確認 |
| 在庫管理 | 8 | 85% | Configurations Resources確認済み |
| 会計管理 | 8 | 85% | InvoiceResource Actions詳細確認 |
| 請求管理 | 7 | 80% | Clusters/Vendors構造から確認 |
| 決済管理 | 2 | 75% | Modelsベースの推定含む |
| 商品管理 | 5 | 90% | ProductResource詳細確認済み |
| 連絡先管理 | 3 | 85% | PartnerResource確認済み |
| パートナー管理 | 1 | 75% | 基本構造のみ確認 |
| 人事管理 | 11 | 90% | Configurations Resources詳細確認 |
| 採用管理 | 14 | 90% | 豊富なFilamentリソース確認 |
| 休暇管理 | 9 | 90% | MyTime/Configurations詳細確認 |
| 工数管理 | 1 | 85% | TimesheetResource確認済み |
| プロジェクト管理 | 6 | 90% | RelationManagers含め詳細確認 |
| ブログ管理 | 3 | 90% | Admin/Customer両方のリソース確認 |
| ウェブサイト管理 | 3 | 80% | 基本リソース確認済み |

## 高信頼度の根拠

### 確認済みソースコード

以下のFilament Resourcesの存在を直接確認しました:

#### 販売管理 (sales)
- `QuotationResource` - 見積書管理
- `OrderResource` - 受注管理
- `CustomerResource` - 顧客管理
- `ProductResource` - 商品管理
- `TeamResource` - チーム管理
- `QuotationTemplateResource` - 見積テンプレート
- `ProductCategoryResource` - 商品カテゴリ
- `ProductAttributeResource` - 商品属性
- `PackagingResource` - パッケージング
- `TagResource` - タグ
- `ActivityTypeResource` - 活動タイプ
- `ActivityPlanResource` - 活動プラン

#### 人事管理 (employees)
- `EmployeeResource` - 従業員管理
- `DepartmentResource` - 部門管理
- `JobPositionResource` - 職位管理
- `SkillTypeResource` - スキルタイプ
- `CalendarResource` - 勤務カレンダー
- `EmployeeCategoryResource` - 従業員カテゴリ
- `WorkLocationResource` - 勤務地
- `EmploymentTypeResource` - 雇用形態
- `DepartureReasonResource` - 退職理由
- `ActivityPlanResource` - 活動プラン

#### 採用管理 (recruitments)
- `StageResource` - 採用ステージ
- `SkillTypeResource` - スキルタイプ
- `DegreeResource` - 学歴
- `UTMSourceResource` - UTMソース
- `RefuseReasonResource` - 不採用理由
- `ActivityPlanResource` - 活動プラン
- `UTMMediumResource` - UTMメディア
- `JobPositionResource` - 求人職位
- `ActivityTypeResource` - 活動タイプ
- `EmploymentTypeResource` - 雇用形態
- `ApplicantCategoryResource` - 応募者カテゴリ
- `DepartmentResource` - 部門

#### 在庫管理 (inventories)
- `WarehouseResource` - 倉庫管理
- `RouteResource` - ルート管理
- `PackageTypeResource` - パッケージタイプ
- `StorageCategoryResource` - ストレージカテゴリ
- `LocationResource` - ロケーション
- `ProductCategoryResource` - 商品カテゴリ

#### 休暇管理 (time-off)
- `LeaveTypeResource` - 休暇タイプ
- `AccrualPlanResource` - 休暇発生プラン
- `PublicHolidayResource` - 祝日
- `MandatoryDayResource` - 必須休暇日
- `ActivityTypeResource` - 活動タイプ
- `MyTimeOffResource` - 自分の休暇
- `MyAllocationResource` - 自分の休暇割当

## 低信頼度の項目

### 推定に基づく機能 (信頼度 75%以下)

1. **決済管理 (payments)** - 信頼度 75%
   - Modelsのみ確認、Filament Resourcesが見つからなかった
   - PaymentToken, PaymentTransaction, Paymentモデルから推定

2. **パートナー管理 (partners)** - 信頼度 75%
   - 基本的なPartnerServiceProviderのみ確認
   - 詳細な機能は未確認

3. **アナリティクス (analytics)** - 信頼度 70%
   - Record モデルのみ確認
   - 具体的な分析機能の詳細は未確認

## 潜在的な機能漏れ

以下の機能が存在する可能性がありますが、本分析では未確認です:

1. **レポート機能** - 各モジュールにレポート生成機能がある可能性
2. **ダッシュボード** - Filament Widgetsによるダッシュボード
3. **インポート/エクスポート** - データ入出力機能
4. **通知機能** - メール/システム通知
5. **監査ログ** - 操作履歴の記録
6. **ワークフロー自動化** - 状態遷移の自動処理

## 改善提案

1. **実行環境での確認**: 実際にアプリケーションを起動し、UI から機能を確認することで精度向上
2. **テストケースの確認**: tests/ ディレクトリのテストケースから追加機能を特定
3. **マイグレーションの確認**: データベース構造からより詳細な機能を特定
4. **言語ファイルの確認**: lang/ ディレクトリから機能ラベルを確認

## 結論

本機能一覧は、ソースコードの静的解析に基づいて作成されました。Filament PHP フレームワークのResource構造を主な情報源としているため、Resource として実装されている機能については高い信頼度があります。

一方、バックグラウンドジョブ、API エンドポイント、コンソールコマンドなど、Filament Resource 以外で実装されている機能については、追加調査が必要です。

---

**作成者**: Claude Code Agent
**バージョン**: 1.0
**最終更新**: 2025-12-26
