# 機能設計書: プラグイン管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F001 |
| 機能名 | プラグイン管理 |
| 機能概要 | システムにインストールされているプラグインの表示、有効化/無効化を管理する機能 |
| 関連画面 | SCR-PLUGIN-001（プラグイン一覧画面） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

プラグイン管理機能は、AureusERPシステムに導入されているプラグインモジュールを一覧表示し、各プラグインの有効化・無効化を切り替える機能を提供する。

#### 主な機能
1. **プラグイン一覧表示**: インストール済みプラグインをテーブル形式で表示
2. **プラグイン有効化/無効化**: トグルスイッチによるプラグインの活性状態切り替え
3. **プラグイン情報表示**: 各プラグインの名前、説明、バージョン情報の表示

### 2.2 処理フロー

```
[開始]
   |
   v
[プラグイン一覧画面アクセス]
   |
   v
[Packageクラスからプラグイン情報取得]
   |
   v
[pluginsテーブルから有効/無効状態取得]
   |
   v
[プラグイン一覧表示]
   |
   v
[ユーザーがトグル操作]
   |
   v
[pluginsテーブルのis_activeカラム更新]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | 説明 |
|----------|-----|------|------|
| is_active | boolean | - | プラグインの有効/無効状態 |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| name | string | プラグイン名 |
| description | string | プラグイン説明 |
| version | string | バージョン番号 |
| is_active | boolean | 有効/無効状態 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | プラグイン存在チェック | Packageクラスに登録されているプラグインのみ管理対象となる |
| BR-002 | 依存関係チェック | 依存するプラグインがある場合、無効化時に警告を表示する |
| BR-003 | コアプラグイン保護 | システムコアプラグイン（support等）は無効化不可 |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| plugins | プラグイン状態管理 | SELECT, UPDATE |

### 4.2 テーブル定義（plugins）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| name | varchar(255) | NO | - | プラグイン名 |
| is_active | boolean | NO | true | 有効/無効フラグ |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| PluginResource | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php | プラグイン管理のFilamentリソース |
| ListPlugins | plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource/Pages/ListPlugins.php | プラグイン一覧ページ |
| PluginManagerPlugin | plugins/webkul/plugin-manager/src/PluginManagerPlugin.php | プラグイン管理モジュールの登録 |
| Package | plugins/webkul/support/src/Package.php | プラグインパッケージ情報管理 |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/support | 必須 |
| filament/filament | 必須 |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_plugin | プラグイン一覧の閲覧権限 |
| update_plugin | プラグインの有効/無効切り替え権限 |

### 6.2 セキュリティ考慮事項

- プラグイン管理は管理者権限を持つユーザーのみアクセス可能
- プラグイン状態の変更はauditログに記録される

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| 一覧表示速度 | 1秒以内 |
| 状態更新応答時間 | 500ms以内 |

### 7.2 可用性

- プラグイン状態変更後、システム再起動なしで反映される

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| PLUG-001 | プラグイン情報取得失敗 | エラーログ出力、エラーメッセージ表示 |
| PLUG-002 | 状態更新失敗 | トランザクションロールバック、エラー通知 |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | 一覧表示 | インストール済みプラグインが正しく表示されること |
| T-002 | 有効化 | 無効状態のプラグインを有効化できること |
| T-003 | 無効化 | 有効状態のプラグインを無効化できること |
| T-004 | 権限確認 | 権限のないユーザーがアクセスできないこと |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
