# 機能設計書: フルカレンダー

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F010 |
| 機能名 | フルカレンダー |
| 機能概要 | FullCalendarライブラリを活用したカレンダー表示・イベント管理ウィジェットを提供する |
| 関連画面 | 各モジュールのカレンダービュー |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

フルカレンダー機能は、FullCalendar.ioライブラリをFilamentウィジェットとして統合し、日/週/月表示のカレンダーUIを提供する。イベントの作成、編集、削除、およびドラッグ&ドロップによるスケジュール変更が可能。

#### 主な機能
1. **カレンダー表示**: 日/週/月ビューの切り替え表示
2. **イベント表示**: カレンダー上にイベントを表示
3. **イベント作成**: カレンダー上からの新規イベント作成
4. **イベント編集**: 既存イベントの編集
5. **イベント削除**: イベントの削除
6. **イベント表示（詳細）**: イベントクリックで詳細表示
7. **ヘッダーアクション**: カレンダー上部のカスタムアクション

### 2.2 処理フロー

#### イベント取得フロー
```
[開始]
   |
   v
[カレンダーウィジェット表示]
   |
   v
[表示期間を取得（start, end）]
   |
   v
[fetchEvents()メソッド呼び出し]
   |
   v
[イベントデータ配列を返却]
   |
   v
[FullCalendarにイベント描画]
   |
   v
[終了]
```

#### イベント作成フロー
```
[開始]
   |
   v
[カレンダー上の日付をクリック/ドラッグ選択]
   |
   v
[CreateActionモーダル表示]
   |
   v
[フォーム入力（getFormSchema()で定義）]
   |
   v
[バリデーション実行]
   |
   +-- NG --> [エラー表示] --> [フォーム入力]
   |
   v (OK)
[レコード作成]
   |
   v
[カレンダー更新]
   |
   v
[終了]
```

### 2.3 入力仕様

#### fetchEventsメソッド引数

| 入力項目 | 型 | 必須 | 説明 |
|----------|-----|------|------|
| info.start | string | YES | 表示期間開始日時（ISO8601） |
| info.end | string | YES | 表示期間終了日時（ISO8601） |
| info.startStr | string | YES | 開始日時文字列 |
| info.endStr | string | YES | 終了日時文字列 |
| info.timeZone | string | YES | タイムゾーン |

#### イベントデータ形式

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| id | string/integer | YES | イベントID |
| title | string | YES | イベントタイトル |
| start | string | YES | 開始日時 |
| end | string | NO | 終了日時 |
| allDay | boolean | NO | 終日イベントフラグ |
| color | string | NO | イベント色 |
| url | string | NO | クリック時遷移URL |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| events | array | イベントデータ配列 |
| view | string | 現在のビュー（dayGridMonth等） |
| date | string | 現在表示中の日付 |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | イベント取得 | fetchEvents()は継承クラスでオーバーライドして実装 |
| BR-002 | フォーム定義 | getFormSchema()で作成・編集フォームを定義 |
| BR-003 | ヘッダーアクション | headerActions()でカレンダー上部のアクションを定義 |
| BR-004 | モーダルアクション | modalActions()でイベント操作アクションを定義 |
| BR-005 | フルスパン表示 | デフォルトでカラム全幅表示 |

## 4. データ設計

### 4.1 使用テーブル

イベントデータのテーブルは継承先で定義される。基本的なイベント構造は以下の通り。

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| （継承先で定義） | イベントデータ管理 | SELECT, INSERT, UPDATE, DELETE |

### 4.2 イベントデータ構造（FullCalendar準拠）

| プロパティ | データ型 | 必須 | 説明 |
|------------|----------|------|------|
| id | string | YES | イベント識別子 |
| title | string | YES | イベントタイトル |
| start | datetime | YES | 開始日時 |
| end | datetime | NO | 終了日時 |
| allDay | boolean | NO | 終日フラグ |
| backgroundColor | string | NO | 背景色 |
| borderColor | string | NO | 枠線色 |
| textColor | string | NO | テキスト色 |
| extendedProps | object | NO | 拡張プロパティ |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| FullCalendarWidget | plugins/webkul/full-calendar/src/Filament/Widgets/FullCalendarWidget.php | カレンダーウィジェット基底クラス |
| CanBeConfigured | plugins/webkul/full-calendar/src/Concerns/CanBeConfigured.php | カレンダー設定トレイト |
| InteractsWithEvents | plugins/webkul/full-calendar/src/Concerns/InteractsWithEvents.php | イベント操作トレイト |
| InteractsWithHeaderActions | plugins/webkul/full-calendar/src/Concerns/InteractsWithHeaderActions.php | ヘッダーアクショントレイト |
| InteractsWithModalActions | plugins/webkul/full-calendar/src/Concerns/InteractsWithModalActions.php | モーダルアクショントレイト |
| InteractsWithRawJS | plugins/webkul/full-calendar/src/Concerns/InteractsWithRawJS.php | JavaScript統合トレイト |
| InteractsWithRecord | plugins/webkul/full-calendar/src/Concerns/InteractsWithRecord.php | レコード操作トレイト |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/full-calendar | 必須（カレンダー基盤） |
| filament/filament | 必須（ウィジェット基盤） |
| fullcalendar/fullcalendar | 必須（JSライブラリ） |

## 6. セキュリティ

### 6.1 アクセス制御

| 操作 | 条件 |
|------|------|
| カレンダー表示 | 継承先リソースへのアクセス権限 |
| イベント作成 | CreateAction権限 |
| イベント編集 | EditAction権限 |
| イベント削除 | DeleteAction権限 |

### 6.2 セキュリティ考慮事項

- イベントデータのアクセス制御は継承先で実装
- CSRFトークンによるフォーム保護

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| カレンダー初期読み込み | 2秒以内 |
| イベント取得応答時間 | 1秒以内（100イベントまで） |
| ビュー切り替え | 500ms以内 |

### 7.2 可用性

- 遅延読み込みによるパフォーマンス最適化
- イベント数が多い場合のページネーション対応

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| CAL-001 | イベント取得失敗 | 空配列を返却、エラーログ |
| CAL-002 | イベント作成失敗 | エラー通知表示 |
| CAL-003 | イベント更新失敗 | エラー通知表示、状態ロールバック |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | カレンダー表示 | 月/週/日ビューが正しく表示されること |
| T-002 | イベント表示 | イベントがカレンダー上に表示されること |
| T-003 | イベント作成 | 日付クリックでイベントが作成できること |
| T-004 | イベント編集 | イベントクリックで編集できること |
| T-005 | イベント削除 | イベントが削除できること |
| T-006 | ビュー切り替え | 月/週/日ビューの切り替えができること |
| T-007 | ナビゲーション | 前月/次月への移動ができること |
| T-008 | ヘッダーアクション | カスタムアクションが動作すること |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
