# 機能設計書 100-必須休暇日管理

## 概要

本ドキュメントは、休暇管理モジュールにおける必須休暇日管理機能の設計仕様を定義します。

### 本機能の処理概要

必須休暇日管理機能は、組織として従業員に休暇取得を義務付ける日（一斉休業日、年末年始休暇、夏季休暇など）を登録・管理するための機能です。

**業務上の目的・背景**：
一部の組織では、特定の期間を全社一斉休業とするケースがあります。例えば、年末年始休暇、ゴールデンウィーク一斉休業、お盆休みなどです。これらの必須休暇日を事前に登録しておくことで、従業員の勤務計画や休暇取得計画に反映できます。本機能により、人事担当者は組織の一斉休業日を一元管理できます。

**機能の利用シーン**：
- 年末年始一斉休業日の登録
- 夏季休暇期間の設定
- 会社創立記念日など特別休業日の登録
- 必須休暇日の確認・修正

**主要な処理内容**：
1. 必須休暇日の一覧表示・検索・フィルタリング・グループ化
2. 必須休暇日の新規作成
3. 必須休暇日の編集・更新
4. 必須休暇日の詳細表示
5. 必須休暇日の削除

**関連システム・外部連携**：
- 勤務カレンダー：必須休暇日をカレンダーに反映
- 休暇申請：必須休暇日との重複チェック

**権限による制御**：
管理者・人事担当者など、設定権限を持つユーザーのみがアクセス可能です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-CONFIG-004 | MandatoryDayResource | 主画面 | 必須休暇日の一覧表示・CRUD操作 |
| SCR-TOFF-CONFIG-004 | ListMandatoryDays | 参照画面 | 必須休暇日の一覧表示 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 必須休暇日名 | |
| color | string | Yes | 表示カラー | 16進数カラーコード、デフォルト: #000000 |
| start_date | date | Yes | 開始日 | 有効な日付 |
| end_date | date | Yes | 終了日 | 開始日以降 |

### 入力データソース

- 画面入力（Filament フォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 必須休暇日ID |
| name | string | 必須休暇日名 |
| color | string | 表示カラー |
| start_date | date | 開始日 |
| end_date | date | 終了日 |
| company.name | string | 会社名 |
| createdBy.name | string | 作成者名 |

### 出力先

- 画面表示（Filament テーブル/フォーム/インフォリスト）
- データベース（time_off_leave_mandatory_days テーブル）

## 処理フロー

### 処理シーケンス

```
1. 一覧表示
   └─ 必須休暇日データを取得・表示（グループ化可能）
2. 新規作成
   └─ フォーム入力 → バリデーション → 保存
3. 編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 削除
   └─ レコード削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[一覧画面表示]
    B --> C{操作選択}
    C -->|新規作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|表示| F[詳細画面表示]
    C -->|削除| G[削除確認]
    D --> H[日付・色入力]
    E --> H
    H --> I[バリデーション]
    I -->|成功| J[DB保存]
    I -->|失敗| K[エラー表示]
    G --> L[レコード削除]
    J --> M[成功通知]
    L --> M
    K --> B
    M --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-01 | 期間整合性 | end_dateはstart_date以降である必要がある | 常時 |
| BR-100-02 | カラー設定 | 表示カラーは16進数カラーコードで指定 | 常時 |
| BR-100-03 | 会社スコープ | 必須休暇日は会社ごとに管理される | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | time_off_leave_mandatory_days | SELECT | 必須休暇日を取得 |
| 新規作成 | time_off_leave_mandatory_days | INSERT | 必須休暇日の新規登録 |
| 編集 | time_off_leave_mandatory_days | UPDATE | 必須休暇日の更新 |
| 削除 | time_off_leave_mandatory_days | DELETE | レコードの削除 |

### テーブル別操作詳細

#### time_off_leave_mandatory_days

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 条件指定 | 会社・作成者リレーション含む |
| INSERT | name, color, start_date, end_date, company_id, creator_id | フォーム入力値 | |
| UPDATE | name, color, start_date, end_date | フォーム入力値 | |
| DELETE | - | WHERE id = {record_id} | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-100-01 | バリデーションエラー | 必須項目未入力 | 入力を促すメッセージ表示 |
| E-100-02 | 期間エラー | 終了日が開始日より前 | 正しい期間を入力するよう促す |
| E-100-03 | 色形式エラー | 不正なカラーコード | 正しい形式を入力するよう促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- エラー発生時は自動ロールバック

## パフォーマンス要件

- 一覧表示: 1秒以内
- 作成/更新: 2秒以内

## セキュリティ考慮事項

- 設定権限を持つユーザーのみアクセス可能
- 会社スコープによるデータ分離

## 備考

- LeaveMandatoryDayモデルはcompanyとcreatedByのリレーションを持ちます
- テーブルのグループ機能で名前、作成者、会社名、開始日、終了日でグループ化できます
- フィルターでは会社、作成者、名前、日付で絞り込みが可能です
