# 機能設計書 101-活動タイプ管理(休暇)

## 概要

本ドキュメントは、休暇管理プラグイン(time-off)における活動タイプ管理機能の設計仕様を定義する。

### 本機能の処理概要

休暇関連の活動タイプを定義・管理し、休暇申請・承認プロセスにおける活動(アクティビティ)を標準化する機能を提供する。

**業務上の目的・背景**：休暇申請から承認までのプロセスにおいて、電話連絡・メール送信・面談・書類提出など、様々な種類の活動が発生する。これらの活動タイプを事前に定義しておくことで、業務プロセスの標準化と追跡を可能にし、休暇管理業務の効率化を実現する。

**機能の利用シーン**：人事部門や管理者が、休暇関連の活動タイプ(承認通知、確認連絡、書類提出依頼など)を設定する際に使用される。また、休暇申請の各ステップで実行すべき活動を定義し、自動リマインダーやフォローアップ活動のトリガー設定に活用される。

**主要な処理内容**：
1. 活動タイプの作成・編集・削除・表示
2. 活動タイプのカテゴリ(アクション種別)設定
3. 遅延設定(活動の予定時間設定)
4. 連鎖タイプ(次の活動の提案/トリガー)設定
5. デフォルト担当者の設定
6. 活動完了後の履歴保持設定

**関連システム・外部連携**：supportプラグインのActivityTypeResourceを基底クラスとして継承しており、共通の活動タイプ管理機能を利用する。

**権限による制御**：ActivityTypePolicyにより、活動タイプの表示・作成・編集・削除の権限が制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TOFF-ACT-001 | ActivityTypeResource | 主画面 | 活動タイプ一覧の表示・検索・フィルタ・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 活動タイプ名 | 最大255文字 |
| category | enum | No | アクション種別 | ActivityTypeAction Enum値 |
| default_user_id | integer | No | デフォルト担当者ID | usersテーブルに存在するID |
| summary | text | No | 概要 | - |
| default_note | text | No | デフォルトノート(リッチテキスト) | - |
| delay_count | integer | Yes | 遅延カウント | 0以上、デフォルト0 |
| delay_unit | enum | Yes | 遅延単位 | ActivityDelayUnit Enum値、デフォルトMINUTES |
| delay_from | enum | Yes | 遅延起点 | ActivityDelayFrom Enum値、デフォルトPREVIOUS_ACTIVITY |
| icon | string | No | アイコン | heroicons/fontawesome-solid |
| decoration_type | enum | No | 装飾タイプ | ActivityDecorationType Enum値 |
| chaining_type | enum | Yes | 連鎖タイプ | ActivityChainingType Enum値、デフォルトSUGGEST |
| activity_type_suggestions | array | No | 提案する次の活動タイプ | 活動タイプIDの配列 |
| triggered_next_type_id | integer | No | トリガーする次の活動タイプID | 活動タイプID |
| is_active | boolean | No | 有効フラグ | デフォルトfalse |
| keep_done | boolean | No | 完了した活動を保持 | デフォルトfalse |

### 入力データソース

画面フォーム入力、ActivityTypeモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 活動タイプID |
| name | string | 活動タイプ名 |
| category | string | アクション種別 |
| summary | string | 概要 |
| delay_count | integer | 遅延カウント |
| delay_unit | string | 遅延単位 |
| delay_from | string | 遅延起点 |
| is_active | boolean | 有効フラグ |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

Filamentテーブル画面、データベース(activities_activity_types)

## 処理フロー

### 処理シーケンス

```
1. 活動タイプ一覧表示
   └─ time-offプラグインの活動タイプのみフィルタして表示(plugin='time-off')
2. 活動タイプ作成
   └─ フォーム入力 → バリデーション → DBへ保存
3. 活動タイプ編集
   └─ 既存データ取得 → フォーム表示 → 更新保存
4. 活動タイプ削除
   └─ ソフトデリート(SoftDeletes)
5. 活動タイプ完全削除
   └─ 関連データチェック → 物理削除
6. 活動タイプ復元
   └─ ソフトデリートからの復元
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[活動タイプ一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|削除| F[削除確認]
    C -->|復元| G[復元処理]
    C -->|完全削除| H[完全削除確認]
    D --> I[入力バリデーション]
    E --> I
    I -->|OK| J[DB保存]
    I -->|NG| K[エラー表示]
    F --> L[ソフトデリート]
    G --> M[restore処理]
    H --> N{関連データ確認}
    N -->|なし| O[物理削除]
    N -->|あり| P[エラー通知]
    J --> Q[成功通知]
    L --> Q
    M --> Q
    O --> Q
    K --> C
    P --> C
    Q --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-101-01 | プラグイン限定表示 | time-offプラグインの活動タイプのみ表示 | 一覧表示時 |
| BR-101-02 | 連鎖タイプ制御 | カテゴリがupload_fileの場合、連鎖タイプは非表示 | フォーム表示時 |
| BR-101-03 | 提案/トリガー切替 | 連鎖タイプがsuggestの場合は提案、triggerの場合はトリガー設定 | フォーム表示時 |
| BR-101-04 | 並び順管理 | sortフィールドによる並び順管理(ドラッグ&ドロップ対応) | 一覧表示時 |

### 計算ロジック

活動の予定日時計算:
- 遅延日時 = 起点日時 + delay_count × delay_unit
- 起点は delay_from で決定(前の活動完了時/現在時刻)

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | activities_activity_types | SELECT | plugin='time-off'でフィルタ |
| 作成 | activities_activity_types | INSERT | 新規活動タイプ登録 |
| 編集 | activities_activity_types | UPDATE | 既存活動タイプ更新 |
| 削除 | activities_activity_types | UPDATE | deleted_atをセット(ソフトデリート) |
| 復元 | activities_activity_types | UPDATE | deleted_atをNULLに |
| 完全削除 | activities_activity_types | DELETE | 物理削除 |
| 提案関連 | activities_activity_type_suggestions | INSERT/DELETE | 提案活動タイプの関連付け |

### テーブル別操作詳細

#### activities_activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | category | 選択値 | - |
| INSERT | plugin | 'time-off' | 固定値 |
| INSERT | delay_count | ユーザー入力値 | デフォルト0 |
| INSERT | delay_unit | 選択値 | デフォルトminutes |
| INSERT | delay_from | 選択値 | デフォルトprevious_activity |
| INSERT | is_active | true/false | デフォルトfalse |
| UPDATE | deleted_at | now() | ソフトデリート時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-101-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-101-02 | 削除エラー | 関連データ存在時の完全削除 | エラー通知表示、削除中止 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

活動タイプの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内

## セキュリティ考慮事項

- ActivityTypePolicyによるアクセス制御
- 認証済みユーザーのみアクセス可能
- ロールベースの権限管理(Filament Shield)

## 備考

- BaseActivityTypeResourceを継承し、time-offプラグイン固有の設定を追加
- plugin='time-off'でフィルタリングすることで、他プラグインの活動タイプと分離
