# 機能設計書 103-プロジェクト管理

## 概要

本ドキュメントは、プロジェクトプラグイン(projects)におけるプロジェクト管理機能の設計仕様を定義する。

### 本機能の処理概要

プロジェクトの作成・編集・削除・表示を行い、タスク・マイルストーン・タイムシートなどの関連機能と統合してプロジェクト全体を管理する機能を提供する。

**業務上の目的・背景**：組織内の様々なプロジェクトを一元管理し、プロジェクトマネージャーや担当者が進捗状況を把握できるようにする。顧客、開始/終了日、割当時間、可視性設定などプロジェクトに必要な情報を管理し、タスクやマイルストーンと連携してプロジェクトを効率的に推進する。

**機能の利用シーン**：
- プロジェクトマネージャーが新規プロジェクトを登録する
- プロジェクトの進捗状況やマイルストーンの達成状況を確認する
- プロジェクトの残り工数を確認する
- プロジェクトをお気に入りに追加してすぐにアクセスできるようにする

**主要な処理内容**：
1. プロジェクトの作成・編集・削除・表示
2. プロジェクトステージの管理（ProgressStepper）
3. プロジェクトマネージャー・顧客の割当
4. 開始日・終了日・割当時間の設定
5. 可視性設定（private/internal/public）
6. タイムシート・マイルストーンの有効化設定
7. お気に入り機能
8. タグ付け機能

**関連システム・外部連携**：Partner（顧客）、User（担当者）、Company（会社）、TaskStage、Milestone、Task、Timesheetと連携。

**権限による制御**：UserPermissionScopeによりユーザー権限に基づくアクセス制御。Visibilityによる公開範囲制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-PRJ-001 | ListProjects | 一覧画面 | プロジェクト一覧表示・検索・フィルタ |
| SCR-PRJ-002 | CreateProject | 作成画面 | 新規プロジェクト作成 |
| SCR-PRJ-003 | EditProject | 編集画面 | プロジェクト情報編集 |
| SCR-PRJ-004 | ViewProject | 詳細画面 | プロジェクト詳細表示 |
| SCR-PRJ-005 | ManageTasks | 関連画面 | プロジェクトのタスク管理 |
| SCR-PRJ-006 | ManageMilestones | 関連画面 | プロジェクトのマイルストーン管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stage_id | integer | Yes* | プロジェクトステージID | enable_project_stages時のみ表示・必須 |
| name | string | Yes | プロジェクト名 | 最大255文字 |
| description | text | No | 説明（リッチテキスト） | - |
| user_id | integer | No | プロジェクトマネージャーID | usersテーブルに存在するID |
| partner_id | integer | No | 顧客ID | partnersテーブルに存在するID |
| start_date | date | No* | 開始日 | end_date設定時は必須、end_date以前 |
| end_date | date | No* | 終了日 | start_date設定時は必須、start_date以降 |
| allocated_hours | float | No | 割当時間 | 数値、0以上、enable_timesheets時のみ表示 |
| tags | array | No | タグID配列 | tagsテーブルに存在するID |
| company_id | integer | No | 会社ID | companiesテーブルに存在するID |
| visibility | enum | No | 可視性 | private/internal/public、デフォルトinternal |
| allow_timesheets | boolean | No | タイムシート許可 | enable_timesheets時のみ表示 |
| allow_milestones | boolean | No | マイルストーン許可 | enable_milestones時のみ表示 |

### 入力データソース

画面フォーム入力、Projectモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | プロジェクトID |
| name | string | プロジェクト名 |
| partner.name | string | 顧客名 |
| planned_date | string | 計画期間（開始日-終了日） |
| remaining_hours | float | 残り時間 |
| user.name | string | プロジェクトマネージャー名 |
| tags.name | array | タグ名一覧 |
| stage.name | string | ステージ名 |
| is_favorite_by_user | boolean | お気に入りフラグ |
| tasks_count | integer | タスク数 |
| milestones_completion | string | マイルストーン進捗(完了/全体) |

### 出力先

Filamentテーブル画面（カードグリッド表示）、Infolist詳細画面、データベース(projects_projects)

## 処理フロー

### 処理シーケンス

```
1. プロジェクト一覧表示
   └─ UserPermissionScopeを適用してプロジェクトをフィルタ
   └─ favoriteUsers, milestonesをeager load
2. プロジェクト作成
   └─ フォーム入力 → バリデーション → DBへ保存
3. プロジェクト編集
   └─ 既存データ取得 → フォーム表示 → 更新保存
4. プロジェクト削除
   └─ ソフトデリート(SoftDeletes)
5. プロジェクト完全削除
   └─ 関連データチェック → 物理削除
6. お気に入り切替
   └─ favoriteUsersテーブルのtoggle操作
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[プロジェクト一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|詳細| F[詳細画面表示]
    C -->|削除| G[削除確認]
    C -->|お気に入り| H[お気に入りToggle]
    C -->|タスク| I[タスク管理画面]
    C -->|マイルストーン| J[マイルストーン管理画面]
    D --> K[入力バリデーション]
    E --> K
    K -->|OK| L[DB保存]
    K -->|NG| M[エラー表示]
    G --> N[ソフトデリート]
    H --> O[favoriteUsers toggle]
    L --> P[成功通知]
    N --> P
    O --> B
    M --> C
    P --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-103-01 | 日付ペア制約 | start_dateとend_dateは両方設定または両方未設定 | 入力時 |
| BR-103-02 | 日付順序制約 | start_dateはend_date以前 | 入力時 |
| BR-103-03 | 設定依存表示 | enable_timesheets/enable_milestones設定により関連フィールド表示制御 | フォーム表示時 |
| BR-103-04 | 残り時間計算 | remaining_hours = allocated_hours - tasks.sum(remaining_hours) | 一覧/詳細表示時 |
| BR-103-05 | お気に入りトグル | favoriteUsersテーブルで現在ユーザーとのリレーション切替 | お気に入りボタンクリック時 |
| BR-103-06 | グリッド表示 | カードグリッド形式で表示（sm:1, md:2, xl:3, 2xl:4列） | 一覧表示時 |
| BR-103-07 | 並び順管理 | sortフィールドによる並び順管理（ドラッグ&ドロップ対応） | 一覧表示時 |

### 計算ロジック

残り時間の計算(Project::getRemainingHoursAttribute):
```
remaining_hours = allocated_hours - tasks.sum(remaining_hours)
```

計画期間の表示(planned_date):
```
planned_date = start_date.format('d M Y') + ' - ' + end_date.format('d M Y')
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | projects_projects | SELECT | UserPermissionScope適用 |
| 一覧表示 | projects_user_project_favorites | SELECT | お気に入り情報取得 |
| 一覧表示 | projects_milestones | SELECT | マイルストーン情報取得 |
| 作成 | projects_projects | INSERT | 新規プロジェクト登録 |
| 作成 | projects_project_tag | INSERT | タグ関連付け |
| 編集 | projects_projects | UPDATE | プロジェクト情報更新 |
| 削除 | projects_projects | UPDATE | deleted_atをセット(ソフトデリート) |
| 完全削除 | projects_projects | DELETE | 物理削除 |
| お気に入り | projects_user_project_favorites | INSERT/DELETE | お気に入りトグル |

### テーブル別操作詳細

#### projects_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | description | ユーザー入力値 | 任意 |
| INSERT | visibility | 選択値 | デフォルトinternal |
| INSERT | stage_id | 選択値 | enable_project_stages時 |
| INSERT | start_date | ユーザー入力値 | 任意 |
| INSERT | end_date | ユーザー入力値 | 任意 |
| INSERT | allocated_hours | ユーザー入力値 | enable_timesheets時 |
| INSERT | allow_timesheets | true/false | enable_timesheets時 |
| INSERT | allow_milestones | true/false | enable_milestones時 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | deleted_at | now() | ソフトデリート時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-103-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-103-02 | バリデーションエラー | 日付順序不正 | エラーメッセージ表示 |
| E-103-03 | 削除エラー | 関連データ存在時の完全削除 | エラー通知表示、削除中止 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

プロジェクトの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内
- フィルタ検索: 2秒以内

## セキュリティ考慮事項

- UserPermissionScopeによるユーザー権限ベースのアクセス制御
- Visibilityによるプロジェクト公開範囲制御
- 認証済みユーザーのみアクセス可能

## 備考

- HasCustomFieldsトレイトによりカスタムフィールド対応
- HasChatter, HasLogActivityトレイトによりチャット・アクティビティログ対応
- SoftDeletes対応
- SortableTraitによるドラッグ&ドロップ並び替え対応
- グローバル検索対応（name, user.name, partner.name）
- サブナビゲーション（Top位置）でView/Edit/Tasks/Milestones間の移動
