# 機能設計書 104-タスク管理

## 概要

本ドキュメントは、プロジェクトプラグイン(projects)におけるタスク管理機能の設計仕様を定義する。

### 本機能の処理概要

プロジェクト内のタスクを作成・編集・削除・表示し、状態管理・優先度設定・担当者割当・工数管理などを通じてタスクの進捗を管理する機能を提供する。

**業務上の目的・背景**：プロジェクトを構成する個々の作業単位（タスク）を管理し、担当者の割当、期限管理、進捗追跡を行う。タイムシートとの連携により実際の作業時間を記録し、予定工数との差異を把握できる。

**機能の利用シーン**：
- プロジェクトマネージャーがタスクを作成し担当者を割り当てる
- 担当者がタスクの状態を更新する（進行中→完了など）
- タスクの優先度を設定してスターマークを付ける
- 割当時間と実績時間を比較して進捗を確認する

**主要な処理内容**：
1. タスクの作成・編集・削除・表示
2. タスクステージの管理（ProgressStepper）
3. タスク状態の管理（進行中/変更依頼/承認待ち/完了/キャンセル）
4. 優先度のトグル（スターマーク）
5. 担当者（複数）の割当
6. マイルストーンへの紐付け
7. タイムシート・サブタスクとの連携
8. 工数管理（割当時間/実績時間/残り時間/進捗率）

**関連システム・外部連携**：Project、Partner、Milestone、TaskStage、Timesheet、SubTask(自己参照)と連携。

**権限による制御**：UserPermissionScopeによりユーザー権限に基づくアクセス制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-TSK-001 | ListTasks | 一覧画面 | タスク一覧表示・検索・フィルタ |
| SCR-TSK-002 | CreateTask | 作成画面 | 新規タスク作成 |
| SCR-TSK-003 | EditTask | 編集画面 | タスク情報編集 |
| SCR-TSK-004 | ViewTask | 詳細画面 | タスク詳細表示 |
| SCR-TSK-005 | ManageTimesheets | 関連画面 | タスクのタイムシート管理 |
| SCR-TSK-006 | ManageSubTasks | 関連画面 | サブタスク管理 |

## 機能種別

CRUD操作 / トランザクション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stage_id | integer | Yes | タスクステージID | TaskStageテーブルに存在するID |
| title | string | Yes | タスク名 | 最大255文字 |
| state | enum | Yes | 状態 | TaskState Enum値、デフォルトIN_PROGRESS |
| tags | array | No | タグID配列 | tagsテーブルに存在するID |
| description | text | No | 説明（リッチテキスト） | - |
| project_id | integer | No | プロジェクトID | projectsテーブルに存在するID |
| milestone_id | integer | No | マイルストーンID | project_idのmilestonesに存在するID |
| partner_id | integer | No | 顧客ID | partnersテーブルに存在するID |
| users | array | No | 担当者ID配列 | usersテーブルに存在するID |
| deadline | datetime | No | 期限 | 日時形式 |
| allocated_hours | float | No | 割当時間 | 数値、0以上、enable_timesheets時のみ表示 |

### 入力データソース

画面フォーム入力、Taskモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | タスクID |
| priority | boolean | 優先度（スターマーク） |
| state | enum | 状態 |
| title | string | タスク名 |
| project.name | string | プロジェクト名 |
| milestone.name | string | マイルストーン名 |
| partner.name | string | 顧客名 |
| users.name | array | 担当者名一覧 |
| allocated_hours | float | 割当時間 |
| total_hours_spent | float | 実績時間 |
| remaining_hours | float | 残り時間 |
| progress | float | 進捗率(%) |
| deadline | datetime | 期限 |
| tags.name | array | タグ名一覧 |
| stage.name | string | ステージ名 |

### 出力先

Filamentテーブル画面、Infolist詳細画面、データベース(projects_tasks)

## 処理フロー

### 処理シーケンス

```
1. タスク一覧表示
   └─ UserPermissionScopeを適用してタスクをフィルタ
2. タスク作成
   └─ フォーム入力 → バリデーション → DBへ保存
3. タスク編集
   └─ 既存データ取得 → フォーム表示 → 更新保存 → タイムシート自動更新
4. タスク削除
   └─ ソフトデリート(SoftDeletes)
5. 優先度トグル
   └─ priorityフィールドを反転して更新
6. 状態変更
   └─ モーダルでstate選択 → 更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[タスク一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|詳細| F[詳細画面表示]
    C -->|削除| G[削除確認]
    C -->|優先度切替| H[priorityトグル]
    C -->|状態変更| I[状態選択モーダル]
    C -->|タイムシート| J[タイムシート管理画面]
    C -->|サブタスク| K[サブタスク管理画面]
    D --> L[プロジェクト選択]
    L --> M[マイルストーン/顧客連動]
    M --> N[入力バリデーション]
    E --> N
    N -->|OK| O[DB保存]
    N -->|NG| P[エラー表示]
    G --> Q[ソフトデリート]
    H --> R[priority更新]
    I --> S[state更新]
    O --> T[タイムシート連動更新]
    T --> U[成功通知]
    Q --> U
    R --> B
    S --> B
    P --> C
    U --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-104-01 | プロジェクト連動 | プロジェクト変更時にマイルストーンをリセット、顧客をプロジェクトから引継ぎ | プロジェクト変更時 |
| BR-104-02 | マイルストーン表示制御 | enable_milestones=true かつ project.allow_milestones=true の場合のみ表示 | フォーム表示時 |
| BR-104-03 | 工数フィールド表示制御 | enable_timesheets=true の場合のみ表示 | フォーム/一覧表示時 |
| BR-104-04 | タスク更新時タイムシート連動 | タスクのproject_id/partner_id更新時にタイムシートも自動更新 | タスク更新時 |
| BR-104-05 | 優先度トグル | 一覧のスターアイコンクリックでpriority反転 | 優先度クリック時 |
| BR-104-06 | 状態変更モーダル | 状態アイコンクリックでモーダル表示して状態変更 | 状態アイコンクリック時 |
| BR-104-07 | 進捗率色分け | progress > 100%: danger, < 100%: warning, = 100%: success | 進捗表示時 |

### 計算ロジック

タスク工数の自動更新（Timesheet::updateTaskTimes経由）:
```
effective_hours = タイムシート合計
total_hours_spent = effective_hours + サブタスクのタイムシート合計
remaining_hours = allocated_hours - total_hours_spent
overtime = total_hours_spent > allocated_hours ? total_hours_spent - allocated_hours : 0
progress = allocated_hours ? (total_hours_spent / allocated_hours) * 100 : 0
```

時間表示形式:
```
hours = floor(value)
minutes = (value - hours) * 60
表示 = hours:minutes
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | projects_tasks | SELECT | UserPermissionScope適用 |
| 作成 | projects_tasks | INSERT | 新規タスク登録 |
| 作成 | projects_task_users | INSERT | 担当者関連付け |
| 作成 | projects_task_tag | INSERT | タグ関連付け |
| 編集 | projects_tasks | UPDATE | タスク情報更新 |
| 編集後 | analytics_records | UPDATE | タイムシートのproject_id/partner_id更新 |
| 削除 | projects_tasks | UPDATE | deleted_atをセット(ソフトデリート) |
| 完全削除 | projects_tasks | DELETE | 物理削除 |
| 優先度 | projects_tasks | UPDATE | priority反転 |
| 状態変更 | projects_tasks | UPDATE | state更新 |

### テーブル別操作詳細

#### projects_tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | ユーザー入力値 | 必須 |
| INSERT | state | 選択値 | デフォルトin_progress |
| INSERT | stage_id | 選択値 | 必須 |
| INSERT | project_id | 選択値 | 任意 |
| INSERT | milestone_id | 選択値 | 任意 |
| INSERT | partner_id | 選択値/プロジェクトから引継ぎ | 任意 |
| INSERT | deadline | ユーザー入力値 | 任意 |
| INSERT | allocated_hours | ユーザー入力値 | enable_timesheets時 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | priority | !priority | トグル時 |
| UPDATE | state | 選択値 | 状態変更時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-104-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-104-02 | 参照エラー | 存在しないプロジェクト/マイルストーン選択 | エラーメッセージ表示 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

タスクの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。タスク更新時のタイムシート連動更新はEloquentイベントで自動実行。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内
- フィルタ検索: 2秒以内

## セキュリティ考慮事項

- UserPermissionScope('users')によるユーザー権限ベースのアクセス制御
- 担当者として割り当てられたユーザーのみがアクセス可能
- 認証済みユーザーのみアクセス可能

## 備考

- HasCustomFieldsトレイトによりカスタムフィールド対応
- HasChatter, HasLogActivityトレイトによりチャット・アクティビティログ対応
- SoftDeletes対応
- SortableTraitによるドラッグ&ドロップ並び替え対応
- グローバル検索対応（title, project.name, partner.name, milestone.name）
- サブナビゲーション（Top位置）でView/Edit/Timesheets/SubTasks間の移動
- TaskState Enum: IN_PROGRESS, CHANGES_REQUESTED, APPROVED, DONE, CANCELLED
