# 機能設計書 105-マイルストーン管理

## 概要

本ドキュメントは、プロジェクトプラグイン(projects)におけるマイルストーン管理機能の設計仕様を定義する。

### 本機能の処理概要

プロジェクトの重要な節目（マイルストーン）を定義・管理し、プロジェクト進捗の可視化と目標管理を支援する機能を提供する。

**業務上の目的・背景**：プロジェクトにおいて、重要な成果物の完成やフェーズの終了など、節目となるポイントをマイルストーンとして設定することで、プロジェクト全体の進捗を把握しやすくする。タスクをマイルストーンに紐付けることで、マイルストーン単位での進捗管理が可能になる。

**機能の利用シーン**：
- プロジェクトマネージャーがプロジェクトのマイルストーンを設定する
- マイルストーンの達成状況を確認する
- タスクをマイルストーンに紐付けて進捗を管理する

**主要な処理内容**：
1. マイルストーンの作成・編集・削除
2. 期限（deadline）の設定
3. 完了状態（is_completed）の管理
4. プロジェクトへの紐付け

**関連システム・外部連携**：Projectモデル、Taskモデルと連携。

**権限による制御**：TaskSettingsのenable_milestones設定により機能全体の有効/無効を制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-MILE-001 | MilestoneResource (Configurations) | 設定画面 | マイルストーン一覧・管理 |
| SCR-MILE-002 | MilestonesRelationManager | 関連画面 | プロジェクト詳細からのマイルストーン管理 |
| SCR-MILE-003 | ManageMilestones | 関連画面 | プロジェクトのマイルストーン管理ページ |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | マイルストーン名 | 最大255文字 |
| deadline | datetime | No | 期限 | 日時形式 |
| is_completed | boolean | Yes | 完了フラグ | 必須 |
| project_id | integer | Yes* | プロジェクトID | projectsテーブルに存在するID（RelationManager時は自動設定） |

### 入力データソース

画面フォーム入力、Milestoneモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | マイルストーンID |
| name | string | マイルストーン名 |
| deadline | datetime | 期限 |
| is_completed | boolean | 完了フラグ |
| completed_at | datetime | 完了日時 |
| project.name | string | プロジェクト名 |
| creator.name | string | 作成者名 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

Filamentテーブル画面、データベース(projects_milestones)

## 処理フロー

### 処理シーケンス

```
1. マイルストーン一覧表示
   └─ enable_milestones設定確認 → 一覧表示
2. マイルストーン作成
   └─ フォーム入力 → バリデーション → DBへ保存 → creator_id自動設定
3. マイルストーン編集
   └─ 既存データ取得 → フォーム表示 → 更新保存
4. マイルストーン削除
   └─ 削除確認 → 物理削除
5. 完了トグル
   └─ is_completedトグル → completed_at自動設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{enable_milestones?}
    B -->|No| C[機能非表示]
    B -->|Yes| D[マイルストーン一覧表示]
    D --> E{操作選択}
    E -->|作成| F[作成フォーム表示]
    E -->|編集| G[編集フォーム表示]
    E -->|削除| H[削除確認]
    E -->|完了トグル| I[is_completed反転]
    F --> J[入力バリデーション]
    G --> J
    J -->|OK| K[DB保存]
    J -->|NG| L[エラー表示]
    H --> M[物理削除]
    I --> N[completed_at設定]
    K --> O[成功通知]
    M --> O
    N --> D
    L --> E
    O --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-105-01 | 機能有効化制御 | TaskSettings.enable_milestones=trueの場合のみ表示 | 全画面 |
| BR-105-02 | プロジェクト許可制御 | project.allow_milestones=trueの場合のみ表示 | RelationManager時 |
| BR-105-03 | 完了日時自動設定 | is_completed=trueにする際にcompleted_at=now()、falseにする際にnull | 完了トグル時 |
| BR-105-04 | 作成者自動設定 | 作成時にcreator_id=Auth::id()を自動設定 | 作成時 |
| BR-105-05 | プロジェクト非表示 | RelationManager/ManageMilestones画面ではproject_idフィールド非表示 | 関連画面時 |

### 計算ロジック

完了日時の自動設定:
```
is_completed変更時:
  if (is_completed == true) {
    completed_at = now()
  } else {
    completed_at = null
  }
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | projects_milestones | SELECT | プロジェクト/完了状態でフィルタ可能 |
| 作成 | projects_milestones | INSERT | 新規マイルストーン登録 |
| 編集 | projects_milestones | UPDATE | マイルストーン情報更新 |
| 削除 | projects_milestones | DELETE | 物理削除 |
| 完了トグル | projects_milestones | UPDATE | is_completed, completed_at更新 |

### テーブル別操作詳細

#### projects_milestones

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | deadline | ユーザー入力値 | 任意 |
| INSERT | is_completed | 選択値 | 必須 |
| INSERT | project_id | 選択値/自動設定 | 必須 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | is_completed | true/false | トグル時 |
| UPDATE | completed_at | now()/null | is_completed連動 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-105-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-105-02 | 参照エラー | 存在しないプロジェクト選択 | エラーメッセージ表示 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

マイルストーンの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内

## セキュリティ考慮事項

- 認証済みユーザーのみアクセス可能
- TaskSettings.enable_milestonesによる機能制御

## 備考

- MilestoneResourceはConfigurations Clusterに配置
- ナビゲーションソート順は3
- reorderableColumns対応
- グループ化機能（プロジェクト/完了状態/作成日）対応
- ToggleColumnで完了状態の即時変更が可能
