# 機能設計書 106-タスクステージ管理

## 概要

本ドキュメントは、プロジェクトプラグイン(projects)におけるタスクステージ管理機能の設計仕様を定義する。

### 本機能の処理概要

タスクの進捗ステージ（例：未着手、進行中、レビュー待ち、完了）を定義・管理し、タスクのワークフロー管理を支援する機能を提供する。

**業務上の目的・背景**：プロジェクト内のタスクがどのような状態にあるかを可視化するため、ステージ（カンバンボードのカラムに相当）を定義する。プロジェクトごとに異なるステージを設定でき、タスクの進捗管理をカスタマイズできる。

**機能の利用シーン**：
- プロジェクト管理者がプロジェクト固有のステージを設定する
- タスクをステージ間で移動させて進捗を管理する
- ProgressStepperでタスクのステージを可視化する

**主要な処理内容**：
1. タスクステージの作成・編集・削除・復元
2. プロジェクトへの紐付け
3. ソート順の管理（ドラッグ&ドロップ対応）

**関連システム・外部連携**：Projectモデル、Taskモデルと連携。

**権限による制御**：ソフトデリート対応。関連タスクがある場合は完全削除不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-STAGE-001 | TaskStageResource (Configurations) | 設定画面 | タスクステージ一覧・管理 |
| SCR-STAGE-002 | TaskStagesRelationManager | 関連画面 | プロジェクト詳細からのステージ管理 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | ステージ名 | 最大255文字 |
| project_id | integer | Yes* | プロジェクトID | projectsテーブルに存在するID（削除済みも含む表示）、RelationManager時は自動設定 |

### 入力データソース

画面フォーム入力、TaskStageモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | ステージID |
| name | string | ステージ名 |
| project.name | string | プロジェクト名 |
| sort | integer | ソート順 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

Filamentテーブル画面、データベース(projects_task_stages)

## 処理フロー

### 処理シーケンス

```
1. ステージ一覧表示
   └─ ソート順（降順）で表示
2. ステージ作成
   └─ フォーム入力 → バリデーション → DBへ保存
3. ステージ編集
   └─ 既存データ取得 → フォーム表示 → 更新保存
4. ステージ削除
   └─ ソフトデリート
5. ステージ復元
   └─ deleted_atをnullに設定
6. ステージ完全削除
   └─ 関連タスク確認 → 物理削除（エラー時は通知）
7. 並び替え
   └─ ドラッグ&ドロップでsort更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ステージ一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|削除| F[ソフトデリート]
    C -->|復元| G[restore処理]
    C -->|完全削除| H{関連タスク確認}
    C -->|並び替え| I[sort更新]
    D --> J[入力バリデーション]
    E --> J
    J -->|OK| K[DB保存]
    J -->|NG| L[エラー表示]
    H -->|なし| M[物理削除]
    H -->|あり| N[エラー通知]
    F --> O[成功通知]
    G --> O
    K --> O
    M --> O
    I --> B
    N --> B
    L --> C
    O --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-106-01 | 削除済みプロジェクト表示 | プロジェクト選択時に削除済みプロジェクトも表示（Deleted表記） | フォーム表示時 |
| BR-106-02 | 削除済みプロジェクト選択不可 | 削除済みプロジェクトは選択不可 | フォーム入力時 |
| BR-106-03 | ソフトデリート | 削除は論理削除（deleted_at設定） | 削除時 |
| BR-106-04 | 関連データ制約 | 関連タスクがある場合は完全削除不可 | 完全削除時 |
| BR-106-05 | RelationManagerで非表示 | RelationManager画面ではproject_idフィールド非表示 | 関連画面時 |
| BR-106-06 | デフォルトソート | ソート順（降順）でデフォルト表示 | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | projects_task_stages | SELECT | プロジェクトでフィルタ可能 |
| 作成 | projects_task_stages | INSERT | 新規ステージ登録 |
| 編集 | projects_task_stages | UPDATE | ステージ情報更新 |
| 削除 | projects_task_stages | UPDATE | deleted_atをセット(ソフトデリート) |
| 復元 | projects_task_stages | UPDATE | deleted_atをnullに |
| 完全削除 | projects_task_stages | DELETE | 物理削除 |
| 並び替え | projects_task_stages | UPDATE | sort更新 |

### テーブル別操作詳細

#### projects_task_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | project_id | 選択値/自動設定 | 必須 |
| UPDATE | deleted_at | now() | ソフトデリート時 |
| UPDATE | deleted_at | null | 復元時 |
| UPDATE | sort | ドラッグ位置 | 並び替え時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-106-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-106-02 | 削除エラー | 関連タスク存在時の完全削除 | エラー通知表示、削除中止 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

タスクステージの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内

## セキュリティ考慮事項

- 認証済みユーザーのみアクセス可能

## 備考

- TaskStageResourceはConfigurations Clusterに配置
- ナビゲーションソート順は2
- reorderable('sort')でドラッグ&ドロップ並び替え対応
- グループ化機能（プロジェクト/作成日）対応
- SoftDeletes対応
- 完全削除時のQueryException捕捉で外部キー制約エラーをハンドリング
