# 機能設計書 107-サブタスク管理

## 概要

本ドキュメントは、プロジェクトプラグイン(projects)におけるサブタスク管理機能の設計仕様を定義する。

### 本機能の処理概要

親タスクに紐付くサブタスクを作成・管理し、タスクの階層構造による詳細な作業分解を支援する機能を提供する。

**業務上の目的・背景**：大きなタスクを複数の小さなサブタスクに分解することで、作業の見える化と進捗管理の粒度を細かくできる。サブタスクのタイムシートは親タスクの工数に集計されるため、階層的な工数管理も可能。

**機能の利用シーン**：
- 大きなタスクを細分化してサブタスクを作成する
- サブタスクごとに担当者を割り当てる
- サブタスクの完了状況で親タスクの進捗を把握する

**主要な処理内容**：
1. サブタスクの作成・編集・削除
2. 親タスクへの紐付け（parent_id）
3. サブタスクの状態・優先度管理
4. サブタスクのタイムシート記録

**関連システム・外部連携**：Task（親タスク/サブタスク、自己参照）、Project、Partner、TaskStageと連携。

**権限による制御**：親タスクへのアクセス権限を継承。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SUB-001 | SubTasksRelationManager | 関連画面 | タスク詳細からのサブタスク管理 |
| SCR-SUB-002 | ManageSubTasks | 関連画面 | タスクのサブタスク管理ページ |

## 機能種別

CRUD操作 / リレーション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | string | Yes | サブタスク名 | 最大255文字 |
| state | enum | Yes | 状態 | TaskState Enum値、デフォルトIN_PROGRESS |
| stage_id | integer | No | ステージID | TaskStageテーブルに存在するID |
| user_id | integer | No | 担当者ID | usersテーブルに存在するID（users many-to-manyでも可） |
| deadline | datetime | No | 期限 | 日時形式 |
| allocated_hours | float | No | 割当時間 | 数値、0以上 |
| parent_id | integer | Yes | 親タスクID | 自動設定（RelationManager経由） |
| project_id | integer | Yes | プロジェクトID | 親タスクから継承 |
| partner_id | integer | No | 顧客ID | 親タスクから継承可能 |

### 入力データソース

画面フォーム入力、Taskモデル（サブタスクとして）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | サブタスクID |
| title | string | サブタスク名 |
| state | enum | 状態 |
| stage.name | string | ステージ名 |
| users.name | array | 担当者名 |
| allocated_hours | float | 割当時間 |
| total_hours_spent | float | 実績時間 |
| remaining_hours | float | 残り時間 |
| progress | float | 進捗率(%) |
| deadline | datetime | 期限 |
| created_at | datetime | 作成日時 |

### 出力先

Filament RelationManager画面、データベース(projects_tasks)

## 処理フロー

### 処理シーケンス

```
1. サブタスク一覧表示
   └─ 親タスク(parent_id)でフィルタして表示
2. サブタスク作成
   └─ フォーム入力 → 親タスク情報継承 → バリデーション → DBへ保存
3. サブタスク編集
   └─ 既存データ取得 → フォーム表示 → 更新保存
4. サブタスク削除
   └─ ソフトデリート
5. 状態/優先度変更
   └─ インライン更新
```

### フローチャート

```mermaid
flowchart TD
    A[親タスク詳細画面] --> B[サブタスク一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|詳細| F[サブタスク詳細画面]
    C -->|削除| G[ソフトデリート]
    C -->|状態変更| H[stateインライン更新]
    D --> I[親タスク情報継承]
    I --> J[入力バリデーション]
    E --> J
    J -->|OK| K[DB保存]
    J -->|NG| L[エラー表示]
    K --> M[親タスク工数更新]
    G --> M
    M --> N[成功通知]
    H --> B
    F --> O[タスク詳細画面へ遷移]
    L --> C
    N --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-01 | 親タスク情報継承 | 作成時にproject_id、partner_idを親タスクから継承 | 作成時 |
| BR-107-02 | 工数自動集計 | サブタスクのタイムシートは親タスクのtotal_hours_spentに集計 | タイムシート操作時 |
| BR-107-03 | ステージ共有 | サブタスクは親タスクと同じプロジェクトのステージを使用 | フォーム表示時 |
| BR-107-04 | 進捗率色分け | progress > 100%: danger, < 100%: warning, = 100%: success | 進捗表示時 |
| BR-107-05 | 詳細画面遷移 | サブタスクをクリックするとタスク詳細画面へ遷移 | 一覧クリック時 |

### 計算ロジック

親タスクへの工数集計（Timesheet::updateTaskTimes）:
```
// 親タスクの工数計算
parentEffectiveHours = 親タスクのタイムシート合計
parentHoursSpent = parentEffectiveHours + サブタスクのタイムシート合計

parentTask.update({
  total_hours_spent: parentHoursSpent,
  effective_hours: parentEffectiveHours,
  subtask_effective_hours: サブタスクのeffective_hours合計,
  overtime: parentHoursSpent > allocated_hours ? parentHoursSpent - allocated_hours : 0,
  remaining_hours: allocated_hours - parentHoursSpent,
  progress: allocated_hours ? (parentHoursSpent / allocated_hours) * 100 : 0
})
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | projects_tasks | SELECT | parent_id=親タスクIDでフィルタ |
| 作成 | projects_tasks | INSERT | 新規サブタスク登録（parent_id設定） |
| 編集 | projects_tasks | UPDATE | サブタスク情報更新 |
| 削除 | projects_tasks | UPDATE | deleted_atをセット(ソフトデリート) |
| 工数更新 | projects_tasks | UPDATE | 親タスクの工数フィールド更新 |

### テーブル別操作詳細

#### projects_tasks（サブタスク）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | ユーザー入力値 | 必須 |
| INSERT | parent_id | 親タスクID | RelationManagerで自動設定 |
| INSERT | project_id | 親タスクから継承 | 自動設定 |
| INSERT | partner_id | 親タスクから継承 | 自動設定 |
| INSERT | state | 選択値 | デフォルトin_progress |
| INSERT | stage_id | 選択値 | 任意 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-107-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-107-02 | 循環参照エラー | 自身を親タスクに設定 | エラーメッセージ表示 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

サブタスクの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内

## セキュリティ考慮事項

- 親タスクへのアクセス権限を継承
- 認証済みユーザーのみアクセス可能

## 備考

- サブタスクはTaskモデルを共用（parent_idで親子関係を表現）
- RelationManagerとして実装
- サブタスクの詳細はタスク詳細画面（TaskResource::getUrl('view')）で表示
- SoftDeletes対応
- グループ化機能（状態/ステージ/作成日）対応
- ProgressBarEntryで進捗率を可視化
