# 機能設計書 F011-サポート

## 概要

本ドキュメントは、AureusERPシステムにおけるサポートプラグイン（support）の機能設計書です。サポートプラグインは全プラグイン共通の基盤機能を提供し、ヘルプデスク・ドキュメント・共通ユーティリティとして機能します。

### 本機能の処理概要

サポートプラグインは、AureusERPシステムの中核基盤として、他のすべてのプラグインが共通で利用するユーティリティ機能群を提供します。活動タイプ管理、活動プラン管理、単位変換、通貨・国・地域情報の管理など、システム全体で必要とされる共通機能を一元的に管理します。

**業務上の目的・背景**：企業のERPシステムでは、販売・購買・在庫・会計など複数の業務モジュールが連携して動作します。これらのモジュールが効率的に連携するためには、共通のデータマスタ（通貨、国、単位など）や共通機能（活動管理、プロファイル管理など）が必要です。サポートプラグインはこの共通基盤を提供し、システム全体の一貫性と保守性を確保します。

**機能の利用シーン**：
- システム管理者が活動タイプ（会議、電話、メール送信など）を定義する場面
- 各業務プロセスで活動プランを利用してワークフローを自動化する場面
- ユーザーがプロファイル情報を管理する場面
- 各プラグインが単位変換や通貨計算を行う場面

**主要な処理内容**：
1. 活動タイプの作成・編集・削除・一覧表示
2. 活動プランの作成・管理
3. 単位変換カテゴリおよび単位の管理
4. 通貨・国・地域マスタデータの管理
5. UTMソース・メディア・キャンペーン管理
6. ユーザープロファイル管理
7. メールログ・メールテンプレート管理

**関連システム・外部連携**：
- 全プラグイン（sales、purchases、inventories、accounts等）から参照される基盤機能
- Filament管理パネルとの統合
- Chatterプラグインとの連携（活動ログ機能）

**権限による制御**：
- 活動タイプの管理は管理者権限が必要
- ユーザープロファイルは自分自身の情報のみ編集可能
- 設定画面へのアクセスは適切な権限を持つユーザーのみ

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SUP-001 | ActivityTypeResource | 主画面 | 活動タイプの一覧表示・作成・編集・削除 |
| - | Profile | 参照画面 | ユーザープロファイル管理 |
| - | Settings | 設定画面 | システム設定管理 |

## 機能種別

マスタ管理 / CRUD操作 / 共通ユーティリティ

## 入力仕様

### 入力パラメータ（活動タイプ）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 活動タイプ名 | 最大255文字 |
| category | string | No | アクションカテゴリ | ActivityTypeAction Enum値 |
| default_user_id | integer | No | デフォルト担当者ID | users.id存在チェック |
| summary | text | No | サマリー | - |
| default_note | text | No | デフォルトノート | HTML許可 |
| delay_count | integer | Yes | 遅延カウント | 0以上、デフォルト0 |
| delay_unit | string | Yes | 遅延単位 | ActivityDelayUnit Enum値 |
| delay_from | string | Yes | 遅延起点 | ActivityDelayFrom Enum値 |
| icon | string | No | アイコン | heroicons/fontawesome-solid形式 |
| decoration_type | string | No | 装飾タイプ | ActivityDecorationType Enum値 |
| chaining_type | string | Yes | チェーニングタイプ | ActivityChainingType Enum値（デフォルト: suggest） |
| is_active | boolean | No | 有効フラグ | デフォルト: false |
| keep_done | boolean | No | 完了保持フラグ | デフォルト: false |

### 入力データソース

- 画面入力（Filament管理パネル）
- データベーステーブル（activity_types）
- シーダーによる初期データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 活動タイプID |
| name | string | 活動タイプ名 |
| category | string | アクションカテゴリ |
| delay_count | integer | 遅延カウント |
| delay_unit | string | 遅延単位 |
| delay_from | string | 遅延起点 |
| is_active | boolean | 有効状態 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（Filament管理パネル）
- データベーステーブル（activity_types）
- 他プラグインからの参照

## 処理フロー

### 処理シーケンス

```
1. 活動タイプ一覧表示
   └─ activity_typesテーブルからplugin条件でフィルタして取得
2. 活動タイプ作成
   └─ フォーム入力値をバリデーション後、activity_typesテーブルに挿入
3. 活動タイプ編集
   └─ 既存レコードを取得し、フォーム入力値で更新
4. 活動タイプ削除
   └─ ソフトデリートを実行（deleted_atを設定）
5. 活動タイプ復元
   └─ ソフトデリートを解除（deleted_atをnullに設定）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧| C[plugin条件でフィルタ]
    C --> D[活動タイプ一覧取得]
    B -->|作成| E[フォーム表示]
    E --> F[入力値バリデーション]
    F -->|OK| G[DBに挿入]
    F -->|NG| H[エラー表示]
    B -->|編集| I[既存データ取得]
    I --> J[フォーム表示]
    J --> K[入力値バリデーション]
    K -->|OK| L[DBを更新]
    K -->|NG| H
    B -->|削除| M[ソフトデリート実行]
    D --> N[終了]
    G --> N
    L --> N
    M --> N
    H --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-011-001 | プラグイン別フィルタ | 活動タイプはpluginカラムでフィルタされ、各プラグイン専用のものだけ表示 | 常時 |
| BR-011-002 | チェーニングタイプ制御 | categoryがupload_fileの場合、chaining_typeの選択肢が制限される | category = upload_file |
| BR-011-003 | サジェスト/トリガー排他 | chaining_typeがsuggestの場合はsuggestedActivityTypes、triggerの場合はtriggeredNextTypeを使用 | 常時 |
| BR-011-004 | ソート順管理 | 活動タイプはsortカラムで並び替え可能 | 常時 |

### 計算ロジック

遅延時間の計算:
- delay_countとdelay_unitを組み合わせて遅延時間を算出
- delay_fromに基づいて起点を決定（前の活動からの経過時間など）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 活動タイプ一覧 | activity_types | SELECT | plugin条件でフィルタして取得 |
| 活動タイプ作成 | activity_types | INSERT | 新規レコード挿入 |
| 活動タイプ編集 | activity_types | UPDATE | 既存レコード更新 |
| 活動タイプ削除 | activity_types | UPDATE | ソフトデリート（deleted_at設定） |
| 活動タイプ完全削除 | activity_types | DELETE | 物理削除 |
| サジェスト設定 | activity_type_suggestions | INSERT/DELETE | 多対多関係の管理 |

### テーブル別操作詳細

#### activity_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE plugin = :plugin_name | プラグイン別フィルタ |
| INSERT | name, category, delay_count, delay_unit, delay_from, icon, decoration_type, chaining_type, plugin, is_active, keep_done, creator_id, default_user_id, triggered_next_type_id | フォーム入力値 | sort自動設定 |
| UPDATE | 全カラム | フォーム入力値 | updated_at自動更新 |
| UPDATE | deleted_at | 現在日時 / null | ソフトデリート/復元 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-011-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促進 |
| E-011-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |
| E-011-003 | 削除制約違反 | 他から参照されている活動タイプの削除 | エラーメッセージ表示、削除不可 |

### リトライ仕様

データベース操作失敗時は自動リトライなし。ユーザーによる再操作を促す。

## トランザクション仕様

- 単一レコードの作成・更新・削除は個別トランザクション
- 活動タイプサジェストの多対多関係更新はEloquent Syncによる自動トランザクション

## パフォーマンス要件

- 活動タイプ一覧表示: 1秒以内
- 活動タイプ作成・更新: 2秒以内
- sortカラムにインデックスを設定し、並び替えパフォーマンスを確保

## セキュリティ考慮事項

- 活動タイプの管理はActivityTypePolicy によるアクセス制御
- XSS対策: default_noteフィールドはHTMLエスケープ処理
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ: Laravelのバリデーション機能を使用

## 備考

- サポートプラグインは他の全プラグインの依存関係として機能
- 活動タイプはプラグイン別に分離されており、各プラグインで独自の活動タイプを定義可能
- ActivityTypeSeederにより初期データが投入される
