# 機能設計書 110-ブログカテゴリ管理

## 概要

本ドキュメントは、ブログプラグイン(blogs)におけるブログカテゴリ管理機能の設計仕様を定義する。

### 本機能の処理概要

ブログ記事を分類するためのカテゴリを作成・管理し、コンテンツの整理と閲覧性向上を支援する機能を提供する。

**業務上の目的・背景**：ブログ記事を適切にカテゴリ分類することで、読者が関心のあるコンテンツを見つけやすくし、サイトのナビゲーション性を向上させる。

**機能の利用シーン**：
- コンテンツ管理者がブログカテゴリを作成・管理する
- 記事作成時にカテゴリを選択する
- カテゴリごとに記事を一覧表示する

**主要な処理内容**：
1. カテゴリの作成・編集・削除・復元
2. スラッグの自動生成
3. サブタイトルの設定

**関連システム・外部連携**：Post（ブログ記事）と連携。

**権限による制御**：SoftDeletes対応。関連記事がある場合は完全削除不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-CAT-001 | ManageCategories | 主画面 | カテゴリ一覧表示・作成・編集・削除 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | カテゴリ名 | 最大255文字 |
| slug | string | Yes | スラッグ（URLパス） | 最大255文字、ユニーク、自動生成（disabled） |
| sub_title | string | No | サブタイトル | 最大255文字 |

### 入力データソース

画面フォーム入力、Categoryモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | カテゴリID |
| name | string | カテゴリ名 |
| slug | string | スラッグ |
| sub_title | string | サブタイトル |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

Filamentテーブル画面、データベース(blogs_categories)

## 処理フロー

### 処理シーケンス

```
1. カテゴリ一覧表示
   └─ 名前で検索・ソート可能
2. カテゴリ作成
   └─ 名前入力 → スラッグ自動生成 → DBへ保存
3. カテゴリ編集
   └─ 既存データ取得 → フォーム表示 → 更新保存
4. カテゴリ削除
   └─ ソフトデリート(SoftDeletes)
5. カテゴリ復元
   └─ deleted_atをnullに設定
6. カテゴリ完全削除
   └─ 関連記事確認 → 物理削除（エラー時は通知）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[カテゴリ一覧表示]
    B --> C{操作選択}
    C -->|作成| D[作成フォーム表示]
    C -->|編集| E[編集フォーム表示]
    C -->|削除| F[ソフトデリート]
    C -->|復元| G[restore処理]
    C -->|完全削除| H{関連記事確認}
    D --> I[名前入力]
    I --> J[スラッグ自動生成]
    J --> K[入力バリデーション]
    E --> K
    K -->|OK| L[DB保存]
    K -->|NG| M[エラー表示]
    H -->|なし| N[物理削除]
    H -->|あり| O[エラー通知]
    F --> P[成功通知]
    G --> P
    L --> P
    N --> P
    M --> C
    O --> B
    P --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-110-01 | スラッグ自動生成 | 名前入力時（作成時のみ）にスラッグを自動生成 | 作成時、onBlur |
| BR-110-02 | スラッグ編集不可 | スラッグフィールドはdisabled（編集不可） | フォーム表示時 |
| BR-110-03 | スラッグ一意性 | スラッグは同テーブル内でユニーク | 保存時 |
| BR-110-04 | ソフトデリート | 削除は論理削除（deleted_at設定） | 削除時 |
| BR-110-05 | 関連データ制約 | 関連記事がある場合は完全削除不可 | 完全削除時 |
| BR-110-06 | 削除済み操作制限 | 削除済みカテゴリは編集不可（復元/完全削除のみ） | 一覧操作時 |

### 計算ロジック

スラッグ自動生成:
```php
// 作成時のみ
if ($operation === 'create') {
    $set('slug', Str::slug($state));
}
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | blogs_categories | SELECT | 名前で検索・ソート可能 |
| 作成 | blogs_categories | INSERT | 新規カテゴリ登録 |
| 編集 | blogs_categories | UPDATE | カテゴリ情報更新 |
| 削除 | blogs_categories | UPDATE | deleted_atをセット(ソフトデリート) |
| 復元 | blogs_categories | UPDATE | deleted_atをnullに |
| 完全削除 | blogs_categories | DELETE | 物理削除 |

### テーブル別操作詳細

#### blogs_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | slug | Str::slug(name) | 自動生成 |
| INSERT | sub_title | ユーザー入力値 | 任意 |
| UPDATE | deleted_at | now() | ソフトデリート時 |
| UPDATE | deleted_at | null | 復元時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-110-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-110-02 | ユニーク制約エラー | スラッグ重複 | エラーメッセージ表示 |
| E-110-03 | 削除エラー | 関連記事存在時の完全削除 | エラー通知表示、削除中止 |

### リトライ仕様

特になし(画面操作による再実行)

## トランザクション仕様

カテゴリの作成・編集・削除はFilamentのデフォルトトランザクション制御に従う。

## パフォーマンス要件

- 一覧表示: 2秒以内
- 作成/編集/削除: 1秒以内

## セキュリティ考慮事項

- 認証済みユーザーのみアクセス可能

## 備考

- CategoryResourceはConfigurations Cluster(Website)に配置
- ナビゲーションアイコンはheroicon-o-folder
- ManageCategoriesページで一覧・作成・編集を統合管理
- SoftDeletes対応
- 完全削除時のQueryException捕捉で外部キー制約エラーをハンドリング
- 一括操作（復元/削除/完全削除）対応
