# 機能設計書 111-ブログタグ管理

## 概要

本ドキュメントは、ブログ記事に付与するタグを管理する機能の設計書です。Blogsプラグインの一部として、ブログ記事の分類・検索性向上のためのタグマスタ管理機能を提供します。

### 本機能の処理概要

ブログタグ管理機能は、ブログ記事に付与するタグの作成、編集、削除を行う機能です。タグは記事のカテゴリ分類とは別に、より柔軟なラベル付けを可能にし、読者が関連記事を見つけやすくします。

**業務上の目的・背景**：ブログ運営において、記事を効果的に整理し、読者が関心のある記事を見つけやすくすることは重要です。タグ機能により、記事を複数の観点から分類でき、SEO対策やユーザーエクスペリエンス向上に貢献します。また、コンテンツマーケティング戦略において、関連コンテンツの発見を促進し、サイト内回遊率の向上にも寄与します。

**機能の利用シーン**：
- ブログ記事公開時に適切なタグを選択・付与する場面
- 新しいトピックに対応するタグを追加する場面
- 使用されなくなったタグを整理・削除する場面
- タグの表示色をカスタマイズしてブランディングに合わせる場面

**主要な処理内容**：
1. タグの新規作成（名前と色の設定）
2. 既存タグの編集（名前・色の変更）
3. タグの削除（ソフトデリート対応）
4. タグの復元（削除されたタグの復元）
5. タグの完全削除（物理削除）
6. タグ一覧の表示・検索・ソート
7. 複数タグの一括削除・一括復元

**関連システム・外部連携**：ブログ投稿管理機能と連携し、記事にタグを付与する際にマスタデータとして参照されます。

**権限による制御**：Filament Shieldによる権限管理が適用され、タグの作成・編集・削除には適切な権限が必要です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-BLOG-003 | TagResource | 主画面 | タグ一覧表示、作成、編集、削除 |
| SCR-BLOG-001 | PostResource | 参照画面 | ブログ投稿時のタグ選択 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | タグ名 | 必須、最大255文字、一意制約 |
| color | string | No | タグの表示色（HEX形式） | HEXカラーコード形式 |

### 入力データソース

- 画面入力：管理画面のフォームからユーザーが直接入力
- システム自動設定：creator_id（作成者ID）、sort（表示順）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | タグID（自動採番） |
| name | string | タグ名 |
| color | string | タグの表示色（HEXコード） |
| sort | integer | 表示順序 |
| creator_id | integer | 作成者ユーザーID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（ソフトデリート） |

### 出力先

- データベーステーブル：blogs_tags
- 画面表示：タグ一覧画面、編集フォーム

## 処理フロー

### 処理シーケンス

```
1. タグ一覧表示
   └─ blogs_tagsテーブルからソフトデリートされていないレコードを取得

2. タグ新規作成
   └─ フォーム入力値のバリデーション
   └─ 一意性チェック（name）
   └─ レコード挿入（sort値は自動設定）
   └─ 成功通知表示

3. タグ編集
   └─ 対象レコード取得
   └─ フォーム入力値のバリデーション
   └─ 一意性チェック（name、自身を除く）
   └─ レコード更新
   └─ 成功通知表示

4. タグ削除
   └─ ソフトデリート（deleted_atに日時設定）
   └─ 成功通知表示

5. タグ復元
   └─ deleted_atをnullに更新
   └─ 成功通知表示

6. タグ完全削除
   └─ レコード物理削除
   └─ 成功通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[タグ一覧取得]
    B -->|新規作成| D[フォーム入力]
    B -->|編集| E[既存データ取得]
    B -->|削除| F[ソフトデリート実行]
    B -->|復元| G[復元処理]
    B -->|完全削除| H[物理削除実行]

    C --> I[画面表示]
    D --> J{バリデーション}
    E --> K[フォーム表示]
    K --> J
    F --> L[成功通知]
    G --> L
    H --> L

    J -->|OK| M[DB保存]
    J -->|NG| N[エラー表示]
    M --> L
    N --> D
    L --> I
    I --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-111-01 | タグ名一意性 | タグ名は重複不可 | 作成・編集時 |
| BR-111-02 | ソフトデリート | 削除時は物理削除せずdeleted_atを設定 | 通常削除時 |
| BR-111-03 | 表示順自動設定 | 新規作成時にsort値を自動設定 | 作成時 |
| BR-111-04 | 削除済み操作制限 | 削除済みレコードは編集不可、復元または完全削除のみ可能 | 削除済みレコード操作時 |

### 計算ロジック

- 表示順（sort）：Spatie EloquentSortableにより自動管理される

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | blogs_tags | SELECT | アクティブなタグ一覧を取得 |
| 新規作成 | blogs_tags | INSERT | タグレコードを新規挿入 |
| 編集 | blogs_tags | UPDATE | 既存タグレコードを更新 |
| 削除 | blogs_tags | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元 | blogs_tags | UPDATE | deleted_atをnullに設定 |
| 完全削除 | blogs_tags | DELETE | レコードを物理削除 |

### テーブル別操作詳細

#### blogs_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須、一意 |
| INSERT | color | ユーザー入力値（HEX） | 任意 |
| INSERT | sort | 自動採番 | SortableTrait使用 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | name | ユーザー入力値 | 一意チェック |
| UPDATE | color | ユーザー入力値 | |
| UPDATE | deleted_at | 現在日時/null | ソフトデリート/復元 |
| DELETE | - | - | 完全削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-111-01 | バリデーションエラー | タグ名未入力 | 必須項目を入力するよう促す |
| E-111-02 | バリデーションエラー | タグ名255文字超過 | 文字数を減らすよう促す |
| E-111-03 | 一意制約エラー | 既存のタグ名と重複 | 別のタグ名を入力するよう促す |
| E-111-04 | 不正操作エラー | 削除済みレコードの編集試行 | 復元後に編集するよう促す |

### リトライ仕様

本機能は同期的なCRUD操作であり、リトライ機能は不要です。エラー発生時はユーザーに再入力を促します。

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- 一括削除・一括復元時は複数レコードを単一トランザクションで処理
- エラー発生時はロールバック

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・更新・削除：1秒以内
- タグ数が増加してもインデックスによる検索最適化

## セキュリティ考慮事項

- Filament Shieldによる権限管理が適用
- creator_idによる作成者追跡
- 入力値のサニタイズ（XSS対策）
- 色コードはHEX形式のバリデーションを実施

## 備考

- Spatie EloquentSortableパッケージを使用した表示順管理
- 多言語対応のため、ラベルはLaravelの翻訳機能を使用
- ブログ投稿との関連はblogs_post_tagsテーブルで管理（多対多）
