# 機能設計書 112-ページ管理

## 概要

本ドキュメントは、ウェブサイトの静的ページを管理する機能の設計書です。Websiteプラグインの一部として、CMS機能によるウェブページの作成・編集・公開管理を提供します。

### 本機能の処理概要

ページ管理機能は、企業ウェブサイトで使用される静的ページ（会社概要、サービス紹介、プライバシーポリシーなど）の作成、編集、公開を管理する機能です。リッチエディタによるコンテンツ作成、SEO対策のためのメタ情報設定、ヘッダー・フッターの表示制御など、本格的なCMS機能を提供します。

**業務上の目的・背景**：企業のウェブサイト運営において、静的ページの管理は必須の機能です。開発者の介入なしにマーケティング担当者やコンテンツ管理者がページを作成・更新できることで、タイムリーな情報発信とウェブサイト運営の効率化を実現します。また、SEO対策に必要なメタ情報の設定機能により、検索エンジンからの流入最大化にも貢献します。

**機能の利用シーン**：
- 新規ウェブページの作成（会社概要、サービス案内等）
- 既存ページのコンテンツ更新
- ページの公開・非公開切り替え
- SEO最適化のためのメタ情報設定
- ヘッダー・フッターの表示/非表示設定
- 古いページの削除・アーカイブ

**主要な処理内容**：
1. ページの新規作成（タイトル、コンテンツ、スラッグ設定）
2. リッチエディタによるコンテンツ編集
3. SEOメタ情報の設定（タイトル、キーワード、説明文）
4. 表示設定（ヘッダー・フッター表示制御）
5. 公開状態の管理
6. ページの削除・復元・完全削除
7. ページ一覧の検索・フィルタリング

**関連システム・外部連携**：フロントエンドウェブサイトに直接公開され、URLスラッグによりアクセス可能になります。

**権限による制御**：Filament Shieldによる権限管理が適用され、ページの作成・編集・削除・公開には適切な権限が必要です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-WEB-001 | PageResource | 主画面 | ページ一覧表示、作成、編集、削除 |
| - | CreatePage | 作成画面 | 新規ページ作成 |
| - | EditPage | 編集画面 | ページ編集 |
| - | ViewPage | 詳細画面 | ページ詳細表示 |
| - | ListPages | 一覧画面 | ページ一覧・検索 |

## 機能種別

CRUD操作 / コンテンツ管理（CMS）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | string | Yes | ページタイトル | 必須 |
| slug | string | Yes | URLスラッグ | 必須、最大255文字、一意制約 |
| content | text | Yes | ページ本文（リッチテキスト） | 必須 |
| meta_title | string | No | SEO用メタタイトル | 最大255文字 |
| meta_keywords | string | No | SEO用メタキーワード | 最大255文字 |
| meta_description | text | No | SEO用メタ説明文 | - |
| is_header_visible | boolean | No | ヘッダー表示フラグ | - |
| is_footer_visible | boolean | No | フッター表示フラグ | - |

### 入力データソース

- 画面入力：管理画面のフォームからユーザーが直接入力
- 自動生成：slug（タイトルから自動生成、作成時のみ）
- システム自動設定：creator_id（作成者ID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | ページID（自動採番） |
| title | string | ページタイトル |
| content | text | ページ本文（HTML） |
| slug | string | URLスラッグ |
| is_published | boolean | 公開状態 |
| published_at | datetime | 公開日時 |
| is_header_visible | boolean | ヘッダー表示フラグ |
| is_footer_visible | boolean | フッター表示フラグ |
| meta_title | string | SEO用メタタイトル |
| meta_keywords | string | SEO用メタキーワード |
| meta_description | text | SEO用メタ説明文 |
| creator_id | integer | 作成者ユーザーID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（ソフトデリート） |

### 出力先

- データベーステーブル：website_pages
- フロントエンド：ウェブサイト上の静的ページとして表示
- 画面表示：管理画面のページ一覧・詳細画面

## 処理フロー

### 処理シーケンス

```
1. ページ一覧表示
   └─ website_pagesテーブルからアクティブなレコードを取得
   └─ フィルター・ソート条件を適用
   └─ 一覧表示

2. ページ新規作成
   └─ タイトル入力時にスラッグを自動生成
   └─ フォーム入力値のバリデーション
   └─ スラッグ一意性チェック
   └─ レコード挿入
   └─ 成功通知表示

3. ページ編集
   └─ 対象レコード取得
   └─ フォーム表示（スラッグは編集不可）
   └─ フォーム入力値のバリデーション
   └─ レコード更新
   └─ 成功通知表示

4. ページ詳細表示
   └─ 対象レコード取得
   └─ 詳細情報表示（Infolist形式）

5. ページ削除
   └─ ソフトデリート（deleted_atに日時設定）
   └─ 成功通知表示

6. ページ復元
   └─ deleted_atをnullに更新
   └─ 成功通知表示

7. ページ完全削除
   └─ レコード物理削除
   └─ 成功通知表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[ページ一覧取得]
    B -->|新規作成| D[作成フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|詳細表示| F[詳細情報取得]
    B -->|削除| G[ソフトデリート実行]
    B -->|復元| H[復元処理]
    B -->|完全削除| I[物理削除実行]

    C --> J[フィルター適用]
    J --> K[一覧表示]

    D --> L[タイトル入力]
    L --> M[スラッグ自動生成]
    M --> N{バリデーション}

    E --> O[既存データ取得]
    O --> N

    N -->|OK| P[DB保存]
    N -->|NG| Q[エラー表示]
    P --> R[成功通知]
    Q --> D

    F --> S[Infolist表示]
    G --> R
    H --> R
    I --> R

    K --> T[終了]
    R --> T
    S --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-112-01 | スラッグ一意性 | URLスラッグは重複不可 | 作成・編集時 |
| BR-112-02 | スラッグ自動生成 | 作成時にタイトルからスラッグを自動生成 | 作成時のみ |
| BR-112-03 | スラッグ編集不可 | 作成後はスラッグの変更不可 | 編集時 |
| BR-112-04 | ソフトデリート | 削除時は物理削除せずdeleted_atを設定 | 通常削除時 |
| BR-112-05 | 削除済み操作制限 | 削除済みレコードは編集・表示不可、復元または完全削除のみ可能 | 削除済みレコード操作時 |

### 計算ロジック

- スラッグ生成：`Str::slug($title)` によりタイトルからURL用スラッグを生成

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | website_pages | SELECT | アクティブなページ一覧を取得 |
| 新規作成 | website_pages | INSERT | ページレコードを新規挿入 |
| 編集 | website_pages | UPDATE | 既存ページレコードを更新 |
| 削除 | website_pages | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元 | website_pages | UPDATE | deleted_atをnullに設定 |
| 完全削除 | website_pages | DELETE | レコードを物理削除 |

### テーブル別操作詳細

#### website_pages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | ユーザー入力値 | 必須 |
| INSERT | slug | タイトルから自動生成 | 一意、編集不可 |
| INSERT | content | ユーザー入力値（リッチテキスト） | 必須 |
| INSERT | is_published | デフォルト0 | |
| INSERT | is_header_visible | ユーザー入力値 | |
| INSERT | is_footer_visible | ユーザー入力値 | |
| INSERT | meta_title | ユーザー入力値 | 任意 |
| INSERT | meta_keywords | ユーザー入力値 | 任意 |
| INSERT | meta_description | ユーザー入力値 | 任意 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | title, content等 | ユーザー入力値 | slug以外 |
| UPDATE | deleted_at | 現在日時/null | ソフトデリート/復元 |
| DELETE | - | - | 完全削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-112-01 | バリデーションエラー | タイトル未入力 | 必須項目を入力するよう促す |
| E-112-02 | バリデーションエラー | コンテンツ未入力 | 必須項目を入力するよう促す |
| E-112-03 | 一意制約エラー | 既存のスラッグと重複 | 自動生成されたスラッグに番号を付与するか、タイトルを変更するよう促す |
| E-112-04 | 不正操作エラー | 削除済みレコードの編集試行 | 復元後に編集するよう促す |

### リトライ仕様

本機能は同期的なCRUD操作であり、リトライ機能は不要です。エラー発生時はユーザーに再入力を促します。

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- 一括削除・一括復元時は複数レコードを単一トランザクションで処理
- エラー発生時はロールバック

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・更新・削除：1秒以内
- リッチエディタのコンテンツ保存：2秒以内（大容量コンテンツ考慮）

## セキュリティ考慮事項

- Filament Shieldによる権限管理が適用
- creator_idによる作成者追跡
- リッチエディタの入力値はサニタイズ（XSS対策）
- スラッグはURL安全な形式に変換
- 公開前のプレビュー機能による意図しない情報公開防止

## 備考

- RichEditorコンポーネントによるWYSIWYG編集
- SubNavigationPosition::Topによるタブナビゲーション
- 作成者（creator）との関連による作成者情報表示
- フロントエンド表示はCustomerパネルのPageResourceで別途管理
