# 機能設計書 113-ウェブサイトパートナー管理

## 概要

本ドキュメントは、ウェブサイト向けのパートナー（顧客）情報を管理する機能の設計書です。Websiteプラグインの一部として、顧客ポータル用のパートナー管理機能を提供します。

### 本機能の処理概要

ウェブサイトパートナー管理機能は、ウェブサイト経由で登録された顧客（パートナー）の情報を管理する機能です。基本的なパートナー管理機能を継承しつつ、ウェブサイト固有の認証・パスワード管理機能を追加しています。連絡先情報、住所情報の管理も行え、顧客ポータル機能の基盤となります。

**業務上の目的・背景**：ECサイトや会員制ウェブサイトにおいて、顧客情報の管理は不可欠です。顧客が自身でアカウントを作成・管理できる環境を提供するとともに、管理者側でも顧客情報を一元管理できる機能が必要です。本機能により、顧客ポータル機能の実現と、CRM的な顧客管理の両立を図ります。

**機能の利用シーン**：
- ウェブサイト登録顧客の情報確認・編集
- 顧客の住所情報管理
- 顧客の連絡先（担当者）情報管理
- 顧客アカウントの有効化・無効化
- 顧客パスワードの管理

**主要な処理内容**：
1. パートナー（顧客）情報の一覧表示・検索
2. パートナー情報の新規作成
3. パートナー情報の編集
4. パートナー情報の詳細表示
5. 連絡先（担当者）の管理
6. 住所情報の管理
7. アカウント有効化/無効化

**関連システム・外部連携**：基本パートナー管理機能（Partnerプラグイン）を継承し、ウェブサイト認証機能と連携します。

**権限による制御**：Filament Shieldによる権限管理が適用され、パートナー情報へのアクセス・編集には適切な権限が必要です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-WEB-002 | PartnerResource | 主画面 | パートナー一覧表示、作成、編集、削除 |
| - | ListPartners | 一覧画面 | パートナー一覧・検索 |
| - | CreatePartner | 作成画面 | 新規パートナー作成 |
| - | ViewPartner | 詳細画面 | パートナー詳細表示 |
| - | EditPartner | 編集画面 | パートナー編集 |
| - | ManageContacts | 関連管理画面 | 連絡先管理 |
| - | ManageAddresses | 関連管理画面 | 住所管理 |

## 機能種別

CRUD操作 / 顧客管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| account_type | enum | Yes | アカウント種別（individual/company） | 必須 |
| sub_type | string | No | サブタイプ | - |
| name | string | Yes | 名前 | 必須 |
| email | string | No | メールアドレス | メール形式 |
| password | string | No | パスワード | ハッシュ化して保存 |
| phone | string | No | 電話番号 | - |
| mobile | string | No | 携帯電話番号 | - |
| website | string | No | ウェブサイトURL | URL形式 |
| job_title | string | No | 役職 | - |
| tax_id | string | No | 税ID | - |
| avatar | file | No | プロフィール画像 | 画像ファイル |
| is_active | boolean | No | アカウント有効フラグ | - |
| street1 | string | No | 住所1 | - |
| street2 | string | No | 住所2 | - |
| city | string | No | 市区町村 | - |
| zip | string | No | 郵便番号 | - |
| state_id | integer | No | 都道府県ID | 存在する都道府県 |
| country_id | integer | No | 国ID | 存在する国 |
| company_id | integer | No | 会社ID | 存在する会社 |
| industry_id | integer | No | 業種ID | 存在する業種 |
| title_id | integer | No | 敬称ID | 存在する敬称 |
| parent_id | integer | No | 親パートナーID | 存在するパートナー |

### 入力データソース

- 画面入力：管理画面のフォームからユーザーが直接入力
- ウェブサイト登録：顧客がウェブサイトから自己登録
- システム自動設定：creator_id（作成者ID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | パートナーID（自動採番） |
| account_type | enum | アカウント種別 |
| sub_type | string | サブタイプ |
| name | string | 名前 |
| avatar | string | プロフィール画像パス |
| email | string | メールアドレス |
| password | string | ハッシュ化されたパスワード |
| job_title | string | 役職 |
| website | string | ウェブサイトURL |
| tax_id | string | 税ID |
| phone | string | 電話番号 |
| mobile | string | 携帯電話番号 |
| color | string | カラーコード |
| company_registry | string | 会社登記番号 |
| reference | string | 参照番号 |
| street1 | string | 住所1 |
| street2 | string | 住所2 |
| city | string | 市区町村 |
| zip | string | 郵便番号 |
| state_id | integer | 都道府県ID |
| country_id | integer | 国ID |
| parent_id | integer | 親パートナーID |
| creator_id | integer | 作成者ユーザーID |
| user_id | integer | 関連ユーザーID |
| title_id | integer | 敬称ID |
| company_id | integer | 会社ID |
| industry_id | integer | 業種ID |
| is_active | boolean | アカウント有効フラグ |
| email_verified_at | datetime | メール確認日時 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（ソフトデリート） |

### 出力先

- データベーステーブル：partners_partners
- 画面表示：管理画面のパートナー一覧・詳細画面
- 顧客ポータル：認証済み顧客として利用

## 処理フロー

### 処理シーケンス

```
1. パートナー一覧表示
   └─ partners_partnersテーブルからアクティブなレコードを取得
   └─ フィルター・ソート条件を適用
   └─ 一覧表示

2. パートナー新規作成
   └─ フォーム入力値のバリデーション
   └─ パスワードがある場合はハッシュ化
   └─ レコード挿入
   └─ 成功通知表示

3. パートナー編集
   └─ 対象レコード取得
   └─ フォーム表示
   └─ フォーム入力値のバリデーション
   └─ パスワード変更がある場合はハッシュ化
   └─ レコード更新
   └─ 成功通知表示

4. パートナー詳細表示
   └─ 対象レコード取得
   └─ 関連データ（連絡先、住所）取得
   └─ 詳細情報表示

5. 連絡先管理
   └─ ManageContactsページで関連連絡先を管理
   └─ ContactsRelationManagerで操作

6. 住所管理
   └─ ManageAddressesページで関連住所を管理
   └─ AddressesRelationManagerで操作
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[パートナー一覧取得]
    B -->|新規作成| D[作成フォーム表示]
    B -->|編集| E[編集フォーム表示]
    B -->|詳細表示| F[詳細情報取得]
    B -->|連絡先管理| G[連絡先一覧取得]
    B -->|住所管理| H[住所一覧取得]

    C --> I[フィルター適用]
    I --> J[一覧表示]

    D --> K{バリデーション}
    E --> L[既存データ取得]
    L --> K

    K -->|OK| M{パスワード入力?}
    K -->|NG| N[エラー表示]
    M -->|Yes| O[パスワードハッシュ化]
    M -->|No| P[DB保存]
    O --> P
    N --> D
    P --> Q[成功通知]

    F --> R[関連データ取得]
    R --> S[Infolist表示]

    G --> T[RelationManager表示]
    H --> T

    J --> U[終了]
    Q --> U
    S --> U
    T --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-113-01 | パスワードハッシュ化 | パスワードは必ずハッシュ化して保存 | パスワード登録・変更時 |
| BR-113-02 | 基本機能継承 | BasePartnerResourceの機能を継承 | 全操作 |
| BR-113-03 | ソフトデリート | 削除時は物理削除せずdeleted_atを設定 | 通常削除時 |
| BR-113-04 | 親子関係 | 連絡先・住所はparent_idで親パートナーに紐づく | 連絡先・住所管理時 |
| BR-113-05 | アカウントタイプ区分 | 住所はaccount_type=ADDRESSで、連絡先はそれ以外で識別 | 連絡先・住所取得時 |

### 計算ロジック

- パスワードハッシュ化：Laravelのハッシュ機能（bcrypt）を使用

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | partners_partners | SELECT | アクティブなパートナー一覧を取得 |
| 新規作成 | partners_partners | INSERT | パートナーレコードを新規挿入 |
| 編集 | partners_partners | UPDATE | 既存パートナーレコードを更新 |
| 詳細表示 | partners_partners | SELECT | パートナー詳細と関連データを取得 |
| 連絡先管理 | partners_partners | SELECT/INSERT/UPDATE/DELETE | 関連連絡先の管理 |
| 住所管理 | partners_partners | SELECT/INSERT/UPDATE/DELETE | 関連住所の管理 |

### テーブル別操作詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | 必須 |
| INSERT | email | ユーザー入力値 | メール形式 |
| INSERT | password | ハッシュ化された値 | 任意 |
| INSERT | account_type | ユーザー入力値 | 必須 |
| INSERT | is_active | ユーザー入力値 | デフォルト有効 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| UPDATE | password | ハッシュ化された値 | 変更時のみ |
| SELECT | parent_id | 親パートナーID | 連絡先・住所取得時 |
| SELECT | account_type | ADDRESS/それ以外 | 連絡先・住所区別 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-113-01 | バリデーションエラー | 名前未入力 | 必須項目を入力するよう促す |
| E-113-02 | バリデーションエラー | メール形式不正 | 正しいメール形式を入力するよう促す |
| E-113-03 | 認証エラー | パスワード不一致 | 正しいパスワードを入力するよう促す |
| E-113-04 | 外部キーエラー | 存在しない関連データ参照 | 正しい関連データを選択するよう促す |

### リトライ仕様

本機能は同期的なCRUD操作であり、リトライ機能は不要です。エラー発生時はユーザーに再入力を促します。

## トランザクション仕様

- 各CRUD操作は単一トランザクションで実行
- 関連データ（連絡先、住所）の操作も同一トランザクションで処理
- エラー発生時はロールバック

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・更新・削除：1秒以内
- 関連データ取得：1秒以内

## セキュリティ考慮事項

- パスワードはbcryptでハッシュ化して保存（平文保存禁止）
- password項目はモデルで$hiddenに設定
- Filament Shieldによる権限管理が適用
- creator_idによる作成者追跡
- メール確認機能（email_verified_at）による本人確認
- FilamentUserインターフェース実装によるパネルアクセス制御

## 備考

- BasePartnerResourceを継承し、ウェブサイト固有の機能を追加
- Authenticatableを継承し、Laravel認証機能に対応
- Notifiableトレイトによる通知機能対応
- HasChatter、HasLogActivityトレイトによるコミュニケーション・監査機能対応
- サブナビゲーション（View、Edit、Contacts、Addresses）によるタブ形式の画面遷移
