# 機能設計書 114-連絡先設定管理

## 概要

本ドキュメントは、ウェブサイトの連絡先設定を管理する機能の設計書です。Websiteプラグインの一部として、サイト全体で使用される連絡先情報やソーシャルメディアリンクの設定機能を提供します。

### 本機能の処理概要

連絡先設定管理機能は、ウェブサイトに表示する連絡先情報（メールアドレス、電話番号）およびソーシャルメディアリンク（Twitter、Facebook、Instagram等）を一括管理する設定ページです。Spatie Laravel Settingsパッケージを使用した設定管理により、データベースに設定値を永続化し、サイト全体で参照可能にします。

**業務上の目的・背景**：企業ウェブサイトにおいて、連絡先情報やソーシャルメディアリンクは複数のページ（ヘッダー、フッター、問い合わせページ等）で共通して使用されます。これらの情報を一箇所で管理することで、更新時の手間を削減し、情報の一貫性を保つことができます。また、マーケティング施策に応じてソーシャルメディアリンクを迅速に更新できます。

**機能の利用シーン**：
- ウェブサイト公開前の連絡先情報初期設定
- 電話番号・メールアドレスの変更
- 新規ソーシャルメディアアカウント開設時のリンク追加
- ソーシャルメディアアカウント変更・削除時の更新
- 季節キャンペーン等に応じたSNSリンク更新

**主要な処理内容**：
1. メールアドレスの設定
2. 電話番号の設定
3. 各種ソーシャルメディアリンクの設定
   - Twitter (X)
   - Facebook
   - Instagram
   - WhatsApp
   - YouTube
   - LinkedIn
   - Pinterest
   - TikTok
   - GitHub
   - Slack
4. 設定値の保存・更新

**関連システム・外部連携**：フロントエンドウェブサイトのヘッダー、フッター、問い合わせページ等で設定値が参照されます。

**権限による制御**：Filament Shieldによる権限管理（HasPageShield）が適用され、設定変更には管理者権限が必要です。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ManageContacts | 主画面 | 連絡先・ソーシャルリンク設定 |

## 機能種別

設定管理 / システム設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| email | string | No | 連絡先メールアドレス | メール形式 |
| phone | string | No | 連絡先電話番号 | 電話番号形式 |
| twitter | string | No | Twitter (X) ユーザー名 | - |
| facebook | string | No | Facebook ユーザー名 | - |
| instagram | string | No | Instagram ユーザー名 | - |
| whatsapp | string | No | WhatsApp 電話番号 | - |
| youtube | string | No | YouTube チャンネル名 | - |
| linkedin | string | No | LinkedIn ユーザー名 | - |
| pinterest | string | No | Pinterest ユーザー名 | - |
| tiktok | string | No | TikTok ユーザー名 | - |
| github | string | No | GitHub ユーザー名 | - |
| slack | string | No | Slack ワークスペース名 | - |

### 入力データソース

- 画面入力：設定画面のフォームから管理者が直接入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| email | string | 連絡先メールアドレス |
| phone | string | 連絡先電話番号 |
| twitter | string | Twitter (X) ユーザー名 |
| facebook | string | Facebook ユーザー名 |
| instagram | string | Instagram ユーザー名 |
| whatsapp | string | WhatsApp 電話番号 |
| youtube | string | YouTube チャンネル名 |
| linkedin | string | LinkedIn ユーザー名 |
| pinterest | string | Pinterest ユーザー名 |
| tiktok | string | TikTok ユーザー名 |
| github | string | GitHub ユーザー名 |
| slack | string | Slack ワークスペース名 |

### 出力先

- データベーステーブル：settings（Spatie Laravel Settings）
- フロントエンド：ウェブサイトのヘッダー、フッター、問い合わせページ等

## 処理フロー

### 処理シーケンス

```
1. 設定画面表示
   └─ ContactSettingsクラスから現在の設定値を取得
   └─ フォームに設定値を表示

2. 設定変更
   └─ フォーム入力値のバリデーション
   └─ ContactSettingsクラスに値を設定
   └─ settingsテーブルに保存
   └─ 成功通知表示

3. フロントエンド参照
   └─ ContactSettingsクラスから設定値を取得
   └─ 各コンポーネントで表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[設定画面アクセス]
    B --> C{権限チェック}
    C -->|許可| D[現在の設定値取得]
    C -->|拒否| E[アクセス拒否]
    D --> F[フォーム表示]
    F --> G[設定値入力]
    G --> H{バリデーション}
    H -->|OK| I[設定値保存]
    H -->|NG| J[エラー表示]
    I --> K[成功通知]
    J --> G
    K --> L[終了]
    E --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | 全項目任意 | 全ての設定項目は任意入力 | 常時 |
| BR-114-02 | プレフィックス表示 | ソーシャルリンクはURLプレフィックスを表示 | フォーム表示時 |
| BR-114-03 | ユーザー名のみ保存 | ソーシャルリンクはユーザー名のみを保存 | 保存時 |
| BR-114-04 | 設定グループ | 設定値は'website_contact'グループで管理 | 常時 |

### 計算ロジック

- ソーシャルリンクURL生成：保存されたユーザー名にプレフィックス（例：https://x.com/）を付与して完全なURLを生成

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定表示 | settings | SELECT | 現在の設定値を取得 |
| 設定保存 | settings | INSERT/UPDATE | 設定値を保存・更新 |

### テーブル別操作詳細

#### settings（Spatie Laravel Settings）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | group = 'website_contact' | 連絡先設定グループ | ContactSettingsクラス使用 |
| INSERT/UPDATE | name | 各設定項目名 | email, phone, twitter等 |
| INSERT/UPDATE | payload | 設定値（JSON） | 文字列値を格納 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-114-01 | バリデーションエラー | メールアドレス形式不正 | 正しいメール形式を入力するよう促す |
| E-114-02 | バリデーションエラー | 電話番号形式不正 | 正しい電話番号形式を入力するよう促す |
| E-114-03 | 権限エラー | 設定変更権限なし | 管理者に連絡するよう促す |

### リトライ仕様

本機能は同期的な設定保存操作であり、リトライ機能は不要です。エラー発生時はユーザーに再入力を促します。

## トランザクション仕様

- 設定保存は単一トランザクションで実行
- 複数設定項目も一括で保存
- エラー発生時はロールバック

## パフォーマンス要件

- 設定画面表示：1秒以内
- 設定保存：1秒以内
- フロントエンド参照：キャッシュ活用により高速化推奨

## セキュリティ考慮事項

- HasPageShieldトレイトによる権限管理
- 管理者のみが設定変更可能
- 入力値のサニタイズ（XSS対策）
- メールアドレス・電話番号の公開範囲に注意

## 備考

- Spatie Laravel Settingsパッケージを使用
- ContactSettingsクラスで設定項目を定義
- SettingsPageを継承したFilament設定ページ
- Settingsクラスタに属する設定ページ
- ソーシャルリンクはプレフィックス付きTextInputで入力しやすさを向上
- 将来的なソーシャルメディア追加にも対応しやすい設計
