# 機能設計書 F013-受注管理

## 概要

本ドキュメントは、AureusERPシステムにおける受注管理機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

受注管理機能は、確定した受注の管理を行います。見積書が受注として確定された後の受注一覧表示、詳細確認、配送管理、請求書管理などの業務プロセスをサポートします。

**業務上の目的・背景**：見積書が顧客に承認され受注として確定した後、その受注を適切に管理し、配送や請求といった後続プロセスへ円滑に引き継ぐことが重要です。受注管理機能は、確定済み受注の一元管理と後続プロセスへの連携を実現します。

**機能の利用シーン**：
- 受注一覧を確認し、未出荷・未請求の受注を把握する場面
- 受注詳細を確認し、顧客や商品情報を参照する場面
- 受注から請求書を作成する場面
- 受注から配送処理を管理する場面

**主要な処理内容**：
1. 受注（state=SALE）の一覧表示
2. 受注の詳細表示・編集
3. 請求書の作成・管理
4. 配送オペレーションの管理
5. 受注明細の確認

**関連システム・外部連携**：
- 見積書管理との連携（受注は見積の確定状態）
- 請求書管理（Invoice）との連携
- 在庫管理（Inventory）との連携（配送処理）

**権限による制御**：
- 受注の閲覧・編集は営業担当者権限が必要
- 受注の削除は通常不可

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-006 | OrderResource | 主画面 | 受注一覧表示 |
| SCR-SAL-007 | ViewOrder | 参照画面 | 受注詳細表示 |
| SCR-SAL-008 | EditOrder | 編集画面 | 受注編集 |
| SCR-SAL-009 | ManageInvoices | 関連画面 | 請求書管理 |
| SCR-SAL-010 | ManageDeliveries | 関連画面 | 配送管理 |

## 機能種別

トランザクション管理 / 参照・編集

## 入力仕様

### 入力パラメータ

受注の入力パラメータは見積書管理（F012）と同一です。
受注は見積書から状態遷移したものであり、基本的に編集は制限されます。

### 入力データソース

- 見積書からの状態遷移
- 画面からの限定的な編集

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 受注ID |
| name | string | 受注番号（SO/{id}形式） |
| state | enum | 受注状態（sale固定） |
| invoice_status | enum | 請求状態 |
| amount_untaxed | decimal | 税抜金額 |
| amount_tax | decimal | 税額 |
| amount_total | decimal | 合計金額 |
| date_order | date | 受注日 |

### 出力先

- 画面表示（Filament管理パネル）
- 請求書への連携
- 配送処理への連携

## 処理フロー

### 処理シーケンス

```
1. 受注一覧表示
   └─ state=SALEの注文をフィルタして取得
2. 受注詳細表示
   └─ 受注ヘッダ + 明細 + 関連請求書/配送情報を取得
3. 請求書作成
   └─ 受注から請求書データを生成
4. 配送管理
   └─ 在庫オペレーションとの連携
```

### フローチャート

```mermaid
flowchart TD
    A[受注一覧] --> B{操作選択}
    B -->|詳細表示| C[受注詳細画面]
    B -->|編集| D[受注編集画面]
    B -->|請求書| E[請求書管理画面]
    B -->|配送| F[配送管理画面]
    C --> G[明細確認]
    E --> H[請求書作成/一覧]
    F --> I[配送オペレーション管理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-013-001 | SALE状態フィルタ | 受注一覧はstate=SALEのみ表示 | 一覧表示時 |
| BR-013-002 | 受注削除不可 | 受注状態のオーダーは削除不可 | 削除操作時 |
| BR-013-003 | フォーム共有 | 見積書と同一フォーム・テーブル定義を使用 | 画面表示時 |
| BR-013-004 | サブナビゲーション | 詳細・編集・請求書・配送の4タブ構成 | 画面遷移時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 受注一覧 | sales_orders | SELECT | WHERE state = 'sale' |
| 受注詳細 | sales_orders | SELECT | 単一レコード取得 |
| 受注詳細 | sales_order_lines | SELECT | 明細取得 |
| 受注編集 | sales_orders | UPDATE | 限定的な更新 |

### テーブル別操作詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE state = 'sale' AND deleted_at IS NULL | 受注のみ抽出 |
| UPDATE | 限定項目のみ | 編集可能項目のみ | ロック状態確認必須 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-013-001 | 削除制約違反 | 受注の削除試行 | 削除不可メッセージ表示 |
| E-013-002 | 編集制約違反 | ロック済み受注の編集試行 | 編集不可メッセージ表示 |

## トランザクション仕様

- 見積書管理と同一（F012参照）

## パフォーマンス要件

- 受注一覧表示: 2秒以内（100件まで）
- 受注詳細表示: 1秒以内

## セキュリティ考慮事項

- OrderPolicyによるアクセス制御
- 見積書管理と同一のセキュリティ対策を適用

## 備考

- OrderResourceはQuotationResourceのフォーム・テーブル定義を再利用
- table()メソッドでmodifyQueryUsingを使用してstate=SALEでフィルタ
- 見積書から受注への遷移は同一レコードの状態変更
