# 機能設計書 F014-顧客管理

## 概要

本ドキュメントは、AureusERPシステムにおける顧客管理機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

顧客管理機能は、販売活動における顧客情報の管理を行います。顧客の基本情報、連絡先、住所、銀行口座情報などを一元管理し、見積書・受注との連携を実現します。

**業務上の目的・背景**：営業活動において顧客情報の適切な管理は不可欠です。顧客管理機能は、Invoiceプラグインの取引先（Partner）リソースを継承し、販売業務に特化した顧客管理インターフェースを提供します。

**機能の利用シーン**：
- 新規顧客の登録
- 既存顧客の情報更新
- 顧客の連絡先・住所管理
- 顧客の銀行口座情報管理
- 見積書作成時の顧客選択

**主要な処理内容**：
1. 顧客情報の登録・編集・削除・一覧表示
2. 顧客連絡先の管理
3. 顧客住所の管理
4. 顧客銀行口座の管理
5. 顧客関連の見積・受注の参照

**関連システム・外部連携**：
- Invoiceプラグイン（PartnerResource）の継承
- 見積書管理との連携
- 受注管理との連携

**権限による制御**：
- 顧客情報の閲覧・編集は営業担当者権限が必要
- 顧客の削除は適切な権限を持つユーザーのみ

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-011 | CustomerResource | 主画面 | 顧客一覧表示・作成・編集・削除 |
| SCR-SAL-012 | ViewCustomer | 参照画面 | 顧客詳細表示 |
| SCR-SAL-013 | EditCustomer | 編集画面 | 顧客編集 |
| SCR-SAL-014 | ManageContacts | 関連画面 | 連絡先管理 |
| SCR-SAL-015 | ManageAddresses | 関連画面 | 住所管理 |
| SCR-SAL-016 | ManageBankAccounts | 関連画面 | 銀行口座管理 |

## 機能種別

マスタ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

顧客情報の入力パラメータはInvoiceプラグインのPartnerResourceを継承しています。
主要な項目は以下の通りです。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 顧客名 | 最大255文字 |
| sub_type | string | - | サブタイプ | 'customer'固定 |
| email | string | No | メールアドレス | メール形式 |
| phone | string | No | 電話番号 | - |
| website | string | No | Webサイト | URL形式 |
| company_id | integer | No | 会社ID | companies.id存在チェック |
| user_id | integer | No | 担当者ID | users.id存在チェック |

### 入力データソース

- 画面入力（Filament管理パネル）
- インポート機能（該当する場合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 顧客ID |
| name | string | 顧客名 |
| sub_type | string | サブタイプ（customer） |
| email | string | メールアドレス |
| phone | string | 電話番号 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（カードグリッドレイアウト）
- 見積書・受注の顧客選択リスト

## 処理フロー

### 処理シーケンス

```
1. 顧客一覧表示
   └─ カードグリッド形式で顧客一覧を表示
2. 顧客作成
   └─ フォーム入力 → バリデーション → 保存
3. 顧客編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. サブナビゲーション
   └─ 連絡先/住所/銀行口座の管理
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-014-001 | BaseCustomerResource継承 | InvoiceプラグインのPartnerResourceを継承 | 常時 |
| BR-014-002 | カードグリッド表示 | 一覧はカードグリッドレイアウトで表示 | 一覧表示時 |
| BR-014-003 | サブナビゲーション5タブ | 詳細・編集・連絡先・住所・銀行口座の5タブ構成 | 画面遷移時 |
| BR-014-004 | Ordersクラスタ所属 | 受注管理クラスタ配下に配置 | 常時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客一覧 | partners_partners | SELECT | 一覧取得 |
| 顧客作成 | partners_partners | INSERT | 新規顧客挿入 |
| 顧客編集 | partners_partners | UPDATE | 既存顧客更新 |
| 顧客削除 | partners_partners | UPDATE | ソフトデリート |
| 連絡先管理 | partners_contacts | SELECT/INSERT/UPDATE/DELETE | 連絡先CRUD |
| 住所管理 | partners_addresses | SELECT/INSERT/UPDATE/DELETE | 住所CRUD |
| 銀行口座管理 | partners_bank_accounts | SELECT/INSERT/UPDATE/DELETE | 銀行口座CRUD |

### テーブル別操作詳細

#### partners_partners（Sales側はPartnerモデルとして参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE sub_type = 'customer' | 顧客のみ抽出 |
| INSERT | name, sub_type, email, phone, etc. | フォーム入力値 | sub_type='customer' |
| UPDATE | 全カラム | フォーム入力値 | - |
| UPDATE | deleted_at | 現在日時 | ソフトデリート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-014-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-014-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |

## トランザクション仕様

- 顧客情報の作成・更新は単一トランザクション
- 連絡先・住所・銀行口座は個別トランザクション

## パフォーマンス要件

- 顧客一覧表示: 2秒以内
- 顧客作成・更新: 2秒以内

## セキュリティ考慮事項

- PartnerPolicyによるアクセス制御
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ

## 備考

- CustomerResourceはBaseCustomerResource（Invoice）を継承
- Salesプラグイン独自のPartnerモデルを使用
- contentGridでレスポンシブなカードレイアウトを実現（sm:1, md:2, xl:3, 2xl:3）
