# 機能設計書 F015-商品管理(販売)

## 概要

本ドキュメントは、AureusERPシステムにおける商品管理(販売)機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

商品管理(販売)機能は、販売業務で使用する商品情報の管理を行います。Invoiceプラグインの商品リソースを継承し、販売業務に特化した商品管理インターフェースを提供します。

**業務上の目的・背景**：販売活動において商品情報は見積・受注の基盤となる重要なマスタデータです。商品名、価格、税、属性、バリエーションなどの情報を一元管理し、見積書・受注への効率的な連携を実現します。

**機能の利用シーン**：
- 新規商品の登録
- 既存商品の情報更新（価格改定など）
- 商品属性の設定
- 商品バリエーションの管理
- 見積書作成時の商品選択

**主要な処理内容**：
1. 商品情報の登録・編集・削除・一覧表示
2. 商品属性の管理
3. 商品バリエーションの管理
4. 商品の価格・税情報管理

**関連システム・外部連携**：
- Invoiceプラグイン（ProductResource）の継承
- 見積書管理との連携
- 受注管理との連携
- 在庫管理との連携

**権限による制御**：
- 商品情報の閲覧・編集は適切な権限を持つユーザーのみ

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-017 | ProductResource | 主画面 | 商品一覧表示・作成・編集・削除 |
| SCR-SAL-018 | ViewProduct | 参照画面 | 商品詳細表示 |
| SCR-SAL-019 | EditProduct | 編集画面 | 商品編集 |
| SCR-SAL-020 | ManageAttributes | 関連画面 | 属性管理 |
| SCR-SAL-021 | ManageVariants | 関連画面 | バリエーション管理 |

## 機能種別

マスタ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

商品情報の入力パラメータはInvoiceプラグインのProductResourceを継承しています。
主要な項目は以下の通りです。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 商品名 | 最大255文字 |
| price | decimal | No | 販売価格 | 0以上 |
| cost | decimal | No | 原価 | 0以上 |
| uom_id | integer | No | 単位ID | uoms.id存在チェック |
| category_id | integer | No | カテゴリID | categories.id存在チェック |
| is_configurable | boolean | No | 設定可能フラグ | - |

### 入力データソース

- 画面入力（Filament管理パネル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 商品ID |
| name | string | 商品名 |
| price | decimal | 販売価格 |
| cost | decimal | 原価 |
| is_configurable | boolean | 設定可能フラグ |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示
- 見積書・受注の商品選択リスト

## 処理フロー

### 処理シーケンス

```
1. 商品一覧表示
   └─ フィルタ・ソート付きで商品一覧を表示
2. 商品作成
   └─ フォーム入力 → バリデーション → 保存
3. 商品編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. サブナビゲーション
   └─ 属性/バリエーションの管理
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-015-001 | BaseProductResource継承 | InvoiceプラグインのProductResourceを継承 | 常時 |
| BR-015-002 | Productsクラスタ所属 | 商品クラスタ配下に配置 | 常時 |
| BR-015-003 | サブナビゲーション4タブ | 詳細・編集・属性・バリエーションの4タブ構成 | 画面遷移時 |
| BR-015-004 | responsibleフィルタ除外 | 親クラスのresponsibleフィルタを除外 | 一覧フィルタ時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品一覧 | products | SELECT | 一覧取得 |
| 商品作成 | products | INSERT | 新規商品挿入 |
| 商品編集 | products | UPDATE | 既存商品更新 |
| 商品削除 | products | UPDATE | ソフトデリート |
| 属性管理 | product_attributes | SELECT/INSERT/UPDATE/DELETE | 属性CRUD |
| バリエーション管理 | product_variants | SELECT/INSERT/UPDATE/DELETE | バリエーションCRUD |

### テーブル別操作詳細

#### products（Sales側はProductモデルとして参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE deleted_at IS NULL | ソフトデリート除外 |
| INSERT | name, price, cost, uom_id, category_id, etc. | フォーム入力値 | - |
| UPDATE | 全カラム | フォーム入力値 | - |
| UPDATE | deleted_at | 現在日時 | ソフトデリート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-015-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-015-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |

## トランザクション仕様

- 商品情報の作成・更新は単一トランザクション
- 属性・バリエーションは個別トランザクション

## パフォーマンス要件

- 商品一覧表示: 2秒以内
- 商品作成・更新: 2秒以内

## セキュリティ考慮事項

- ProductPolicyによるアクセス制御
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ

## 備考

- ProductResourceはBaseProductResource（Invoice）を継承
- Salesプラグイン独自のProductモデルを使用
- テーブルフィルタからresponsibleを除外（親クラスのフィルタ調整）
