# 機能設計書 F016-請求対象管理

## 概要

本ドキュメントは、AureusERPシステムにおける請求対象管理機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

請求対象管理機能は、請求書発行待ちの受注を管理します。受注のうち、請求ステータスが「請求対象」のものを抽出し、請求書作成への効率的なワークフローを提供します。

**業務上の目的・背景**：受注が確定した後、商品の出荷や役務の提供が完了すると請求書を発行する必要があります。請求対象管理機能は、請求待ちの受注を一覧化し、請求業務の漏れ防止と効率化を実現します。

**機能の利用シーン**：
- 請求待ち受注の一覧確認
- 請求書作成対象の確認
- 請求プロセスの進捗管理

**主要な処理内容**：
1. 請求対象受注（invoice_status=TO_INVOICE）の一覧表示
2. 請求対象受注の詳細確認
3. 請求対象受注の編集

**関連システム・外部連携**：
- 受注管理との連携
- 請求書管理（Invoice）との連携

**権限による制御**：
- 請求対象受注の閲覧・編集は営業担当者/経理担当者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-022 | OrderToInvoiceResource | 主画面 | 請求対象受注一覧表示 |
| SCR-SAL-023 | ViewOrderToInvoice | 参照画面 | 請求対象受注詳細表示 |
| SCR-SAL-024 | EditOrderToInvoice | 編集画面 | 請求対象受注編集 |

## 機能種別

トランザクション管理 / 参照・編集

## 入力仕様

### 入力パラメータ

請求対象受注の入力パラメータは見積書管理（F012）と同一です。
基本的に参照・確認が主な用途となります。

### 入力データソース

- 受注からのフィルタリング

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 受注ID |
| name | string | 受注番号 |
| state | enum | 受注状態 |
| invoice_status | enum | 請求状態（to_invoice固定） |
| amount_total | decimal | 合計金額 |
| partner.name | string | 顧客名 |
| date_order | date | 受注日 |

### 出力先

- 画面表示（Filament管理パネル）
- 請求書作成への連携

## 処理フロー

### 処理シーケンス

```
1. 請求対象一覧表示
   └─ invoice_status=TO_INVOICEの受注をフィルタして取得
2. 請求対象詳細表示
   └─ 受注詳細情報を表示
3. 請求書作成
   └─ 請求書管理機能への連携
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-016-001 | TO_INVOICEフィルタ | invoice_status=TO_INVOICEの受注のみ表示 | 一覧表示時 |
| BR-016-002 | QuotationResourceフォーム共有 | 見積書と同一フォーム定義を使用 | 画面表示時 |
| BR-016-003 | QuotationResourceテーブル共有 | 見積書と同一テーブル定義を使用 | 一覧表示時 |
| BR-016-004 | ToInvoiceクラスタ所属 | 請求対象クラスタ配下に配置 | 常時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 請求対象一覧 | sales_orders | SELECT | WHERE invoice_status = 'to_invoice' |
| 請求対象詳細 | sales_orders | SELECT | 単一レコード取得 |
| 請求対象編集 | sales_orders | UPDATE | 限定的な更新 |

### テーブル別操作詳細

#### sales_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE invoice_status = 'to_invoice' | 請求対象のみ抽出 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-016-001 | 編集制約違反 | ロック済み受注の編集試行 | 編集不可メッセージ表示 |

## トランザクション仕様

- 見積書管理と同一（F012参照）

## パフォーマンス要件

- 請求対象一覧表示: 2秒以内
- 請求対象詳細表示: 1秒以内

## セキュリティ考慮事項

- OrderPolicyによるアクセス制御
- 見積書管理と同一のセキュリティ対策を適用

## 備考

- OrderToInvoiceResourceはQuotationResourceのフォーム・テーブル・infolist定義を再利用
- modifyQueryUsingでinvoice_status=TO_INVOICEでフィルタ
- サブナビゲーションは2タブ（ViewOrderToInvoice, EditOrderToInvoice）
- 作成ページは不要（受注から自動的に遷移）
