# 機能設計書 F017-販売チーム管理

## 概要

本ドキュメントは、AureusERPシステムにおける販売チーム管理機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

販売チーム管理機能は、営業組織のチーム情報を管理します。チームリーダー、メンバー、目標売上などを設定し、営業活動の組織的な管理を実現します。

**業務上の目的・背景**：営業組織では複数のチームが競争・協力しながら目標達成を目指します。販売チーム管理機能は、チームの構成、リーダー、メンバー、売上目標を一元管理し、営業パフォーマンスの可視化と管理を支援します。

**機能の利用シーン**：
- 販売チームの新規作成
- チームメンバーの追加・変更
- チームの売上目標設定
- 見積書・受注へのチーム割り当て

**主要な処理内容**：
1. 販売チームの登録・編集・削除・一覧表示
2. チームリーダーの設定
3. チームメンバーの管理
4. 売上目標（Invoiced Target）の設定
5. チームの有効/無効切り替え

**関連システム・外部連携**：
- 見積書管理との連携（チーム割り当て）
- 受注管理との連携
- ユーザー管理との連携

**権限による制御**：
- 販売チームの管理は管理者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-025 | TeamResource | 主画面 | 販売チーム一覧表示・作成・編集・削除 |
| SCR-SAL-026 | ViewTeam | 参照画面 | 販売チーム詳細表示 |
| SCR-SAL-027 | EditTeam | 編集画面 | 販売チーム編集 |
| SCR-SAL-028 | CreateTeam | 作成画面 | 販売チーム作成 |

## 機能種別

マスタ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | チーム名 | 最大255文字 |
| user_id | integer | No | チームリーダーID | users.id存在チェック |
| company_id | integer | No | 会社ID | companies.id存在チェック |
| invoiced_target | decimal | No | 売上目標 | 0以上、最大99999999999、デフォルト0 |
| color | string | No | チームカラー | 16進数カラーコード |
| sales_team_members | array | No | メンバーID配列 | users.id存在チェック |
| is_active | boolean | No | 有効フラグ | デフォルト: false |

### 入力データソース

- 画面入力（Filament管理パネル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | チームID |
| name | string | チーム名 |
| user.name | string | チームリーダー名 |
| company.name | string | 会社名 |
| invoiced_target | decimal | 売上目標 |
| color | string | チームカラー |
| is_active | boolean | 有効状態 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（Filament管理パネル）
- 見積書・受注のチーム選択リスト

## 処理フロー

### 処理シーケンス

```
1. 販売チーム一覧表示
   └─ 販売チーム一覧を取得・表示
2. 販売チーム作成
   └─ フォーム入力 → バリデーション → 保存
3. 販売チーム編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 販売チーム削除
   └─ ソフトデリート実行
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-017-001 | ソフトデリート | 削除はソフトデリートで実行 | 削除操作時 |
| BR-017-002 | メンバー多対多 | チームメンバーはsales_team_membersテーブルで管理 | メンバー設定時 |
| BR-017-003 | ソート対応 | チームはsortカラムで並び替え可能 | 一覧表示時 |
| BR-017-004 | Configurationクラスタ所属 | 設定クラスタ配下に配置 | 常時 |
| BR-017-005 | ナビゲーション非表示 | デフォルトでナビゲーションに表示しない | 常時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| チーム一覧 | sales_teams | SELECT | 一覧取得 |
| チーム作成 | sales_teams | INSERT | 新規チーム挿入 |
| チーム編集 | sales_teams | UPDATE | 既存チーム更新 |
| チーム削除 | sales_teams | UPDATE | ソフトデリート |
| メンバー設定 | sales_team_members | INSERT/DELETE | 多対多関係管理 |

### テーブル別操作詳細

#### sales_teams

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE deleted_at IS NULL | ソフトデリート除外 |
| INSERT | name, user_id, company_id, invoiced_target, color, is_active, sort, creator_id | フォーム入力値 | sort自動設定 |
| UPDATE | 全カラム | フォーム入力値 | updated_at自動更新 |
| UPDATE | deleted_at | 現在日時 / null | ソフトデリート/復元 |

#### sales_team_members

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | team_id, user_id | 選択されたメンバー | 多対多関係 |
| DELETE | - | WHERE team_id = ? | メンバー削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-017-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-017-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |

## トランザクション仕様

- チーム情報の作成・更新は単一トランザクション
- メンバー設定はEloquent Syncによる自動トランザクション

## パフォーマンス要件

- チーム一覧表示: 1秒以内
- チーム作成・更新: 2秒以内

## セキュリティ考慮事項

- TeamPolicyによるアクセス制御
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ

## 備考

- Teamモデルはsales_teamsテーブルを使用
- SortableTraitによる並び替え機能対応
- HasChatter, HasLogActivityトレイトによる活動ログ対応
- ColorPickerでチームカラーを視覚的に設定可能
- フィルタ・グループ機能でチームリーダー、会社などで絞り込み可能
