# 機能設計書 F018-見積テンプレート管理

## 概要

本ドキュメントは、AureusERPシステムにおける見積テンプレート管理機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

見積テンプレート管理機能は、見積書のテンプレートを管理します。よく使用する商品構成、利用規約、支払条件などを事前に定義しておき、見積書作成の効率化を図ります。

**業務上の目的・背景**：営業活動において、同じような構成の見積書を繰り返し作成することがあります。見積テンプレート機能は、頻繁に使用する商品構成や条件をテンプレートとして保存し、見積書作成時にワンクリックで適用することで、作業効率の向上とミスの削減を実現します。

**機能の利用シーン**：
- 定型的な見積パターンのテンプレート作成
- 見積書作成時のテンプレート適用
- テンプレートの更新・管理

**主要な処理内容**：
1. 見積テンプレートの登録・編集・削除・一覧表示
2. テンプレート商品の設定
3. 利用規約・備考の設定
4. 有効期限日数の設定
5. 前払い条件の設定

**関連システム・外部連携**：
- 見積書管理との連携（テンプレート適用）
- 商品管理との連携

**権限による制御**：
- 見積テンプレートの管理は管理者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-029 | QuotationTemplateResource | 主画面 | 見積テンプレート一覧表示・作成・編集・削除 |
| SCR-SAL-030 | ViewQuotationTemplate | 参照画面 | 見積テンプレート詳細表示 |
| SCR-SAL-031 | EditQuotationTemplate | 編集画面 | 見積テンプレート編集 |
| SCR-SAL-032 | CreateQuotationTemplate | 作成画面 | 見積テンプレート作成 |

## 機能種別

マスタ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | テンプレート名 | 最大255文字 |
| number_of_days | integer | No | 有効期限日数 | 0以上 |
| company_id | integer | No | 会社ID | companies.id存在チェック |
| journal_id | integer | No | 仕訳帳ID | accounts_journals.id存在チェック |
| note | text | No | 利用規約・備考 | - |
| is_active | boolean | No | 有効フラグ | デフォルト: true |
| require_signature | boolean | No | 署名必須フラグ | デフォルト: false |
| require_payment | boolean | No | 支払必須フラグ | デフォルト: false |
| prepayment_percentage | decimal | No | 前払い割合(%) | 0-100 |

### 入力データソース

- 画面入力（Filament管理パネル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | テンプレートID |
| name | string | テンプレート名 |
| number_of_days | integer | 有効期限日数 |
| is_active | boolean | 有効状態 |
| require_signature | boolean | 署名必須 |
| require_payment | boolean | 支払必須 |
| prepayment_percentage | decimal | 前払い割合 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示（Filament管理パネル）
- 見積書作成時のテンプレート選択リスト

## 処理フロー

### 処理シーケンス

```
1. テンプレート一覧表示
   └─ テンプレート一覧を取得・表示
2. テンプレート作成
   └─ フォーム入力 → 商品設定 → バリデーション → 保存
3. テンプレート編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. テンプレート適用
   └─ 見積書作成時にテンプレートを選択して適用
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-018-001 | テンプレート商品 | OrderTemplateProductでテンプレート内の商品を管理 | 常時 |
| BR-018-002 | セクション/ノート | display_typeでセクションとノートを区別 | 常時 |
| BR-018-003 | ソート対応 | テンプレートはsortカラムで並び替え可能 | 一覧表示時 |
| BR-018-004 | Configurationクラスタ所属 | 設定クラスタ配下に配置 | 常時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テンプレート一覧 | sales_order_templates | SELECT | 一覧取得 |
| テンプレート作成 | sales_order_templates | INSERT | 新規テンプレート挿入 |
| テンプレート編集 | sales_order_templates | UPDATE | 既存テンプレート更新 |
| テンプレート削除 | sales_order_templates | DELETE | 物理削除 |
| 商品設定 | sales_order_template_products | INSERT/UPDATE/DELETE | テンプレート商品管理 |

### テーブル別操作詳細

#### sales_order_templates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | 全件取得 |
| INSERT | name, number_of_days, company_id, journal_id, note, is_active, require_signature, require_payment, prepayment_percentage, sort, creator_id | フォーム入力値 | sort自動設定 |
| UPDATE | 全カラム | フォーム入力値 | updated_at自動更新 |
| DELETE | - | WHERE id = ? | 物理削除 |

#### sales_order_template_products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | order_template_id, product_id, quantity, price_unit, display_type | フォーム入力値 | display_typeでセクション/ノート区別 |
| DELETE | - | WHERE order_template_id = ? | テンプレート商品削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-018-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-018-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |

## トランザクション仕様

- テンプレートと商品設定は同一トランザクション
- 商品設定の一括更新はEloquent Relationship経由で自動管理

## パフォーマンス要件

- テンプレート一覧表示: 1秒以内
- テンプレート作成・更新: 2秒以内

## セキュリティ考慮事項

- OrderTemplatePolicyによるアクセス制御
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ

## 備考

- OrderTemplateモデルはsales_order_templatesテーブルを使用
- SortableTraitによる並び替え機能対応
- products()リレーションはdisplay_type=nullのもの（実際の商品）
- sections()リレーションはdisplay_type=SECTIONのもの
- notes()リレーションはdisplay_type=NOTEのもの
