# 機能設計書 F019-商品カテゴリ管理(販売)

## 概要

本ドキュメントは、AureusERPシステムにおける商品カテゴリ管理(販売)機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

商品カテゴリ管理(販売)機能は、販売業務で使用する商品カテゴリの管理を行います。Invoiceプラグインの商品カテゴリリソースを継承し、販売業務に特化したカテゴリ管理インターフェースを提供します。

**業務上の目的・背景**：商品を体系的に分類・管理するためにカテゴリ機能は重要です。商品カテゴリを階層的に管理することで、商品の検索性向上や売上分析の精度向上を実現します。

**機能の利用シーン**：
- 新規商品カテゴリの作成
- 既存カテゴリの情報更新
- カテゴリ配下の商品管理
- 商品登録時のカテゴリ選択

**主要な処理内容**：
1. 商品カテゴリの登録・編集・削除・一覧表示
2. カテゴリの階層管理
3. カテゴリ配下の商品一覧表示

**関連システム・外部連携**：
- Invoiceプラグイン（ProductCategoryResource）の継承
- 商品管理との連携

**権限による制御**：
- 商品カテゴリの管理は管理者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-033 | ProductCategoryResource | 主画面 | 商品カテゴリ一覧表示・作成・編集・削除 |
| SCR-SAL-034 | ViewProductCategory | 参照画面 | 商品カテゴリ詳細表示 |
| SCR-SAL-035 | EditProductCategory | 編集画面 | 商品カテゴリ編集 |
| SCR-SAL-036 | CreateProductCategory | 作成画面 | 商品カテゴリ作成 |
| SCR-SAL-037 | ManageProducts | 関連画面 | カテゴリ配下商品管理 |

## 機能種別

マスタ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

商品カテゴリの入力パラメータはInvoiceプラグインのProductCategoryResourceを継承しています。
主要な項目は以下の通りです。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | カテゴリ名 | 最大255文字 |
| parent_id | integer | No | 親カテゴリID | categories.id存在チェック |

### 入力データソース

- 画面入力（Filament管理パネル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | カテゴリID |
| name | string | カテゴリ名 |
| parent_id | integer | 親カテゴリID |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示
- 商品登録時のカテゴリ選択リスト

## 処理フロー

### 処理シーケンス

```
1. カテゴリ一覧表示
   └─ カテゴリ一覧を取得・表示
2. カテゴリ作成
   └─ フォーム入力 → バリデーション → 保存
3. カテゴリ編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. サブナビゲーション
   └─ カテゴリ配下商品の管理
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-019-001 | BaseProductCategoryResource継承 | InvoiceプラグインのProductCategoryResourceを継承 | 常時 |
| BR-019-002 | Configurationクラスタ所属 | 設定クラスタ配下に配置 | 常時 |
| BR-019-003 | サブナビゲーション3タブ | 詳細・編集・商品の3タブ構成 | 画面遷移時 |
| BR-019-004 | ナビゲーショングループ | ナビゲーショングループを設定 | 常時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ一覧 | categories | SELECT | 一覧取得 |
| カテゴリ作成 | categories | INSERT | 新規カテゴリ挿入 |
| カテゴリ編集 | categories | UPDATE | 既存カテゴリ更新 |
| カテゴリ削除 | categories | DELETE | 削除 |
| 商品管理 | products | SELECT | カテゴリ配下商品取得 |

### テーブル別操作詳細

#### categories（Sales側はCategoryモデルとして参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | 全件取得 |
| INSERT | name, parent_id, etc. | フォーム入力値 | - |
| UPDATE | 全カラム | フォーム入力値 | - |
| DELETE | - | WHERE id = ? | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-019-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-019-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |

## トランザクション仕様

- カテゴリ情報の作成・更新は単一トランザクション

## パフォーマンス要件

- カテゴリ一覧表示: 1秒以内
- カテゴリ作成・更新: 2秒以内

## セキュリティ考慮事項

- CategoryPolicyによるアクセス制御
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ

## 備考

- ProductCategoryResourceはBaseProductCategoryResource（Invoice）を継承
- SalesプラグインのCategoryモデルを使用
- ManageProductsページでカテゴリ配下の商品を管理可能
