# 機能設計書: ユーザー管理

## 1. 機能概要

| 項目 | 内容 |
|------|------|
| 機能ID | F002 |
| 機能名 | ユーザー管理 |
| 機能概要 | システムユーザーの登録・編集・削除・アーカイブ、および招待機能を提供する |
| 関連画面 | SCR-USER-001（ユーザー一覧）、SCR-USER-002（ユーザー作成）、SCR-USER-003（ユーザー詳細）、SCR-USER-004（ユーザー編集） |
| 関連API | なし |
| 関連バッチ | なし |

## 2. 機能詳細

### 2.1 機能説明

ユーザー管理機能は、AureusERPシステムにおけるユーザーアカウントのライフサイクル全体を管理する。ユーザーの作成、情報更新、アーカイブ（論理削除）、および招待メール送信による新規ユーザー登録招待を行う。

#### 主な機能
1. **ユーザー一覧表示**: 登録済みユーザーをテーブル形式で表示（全件/アーカイブ済みタブ切り替え）
2. **ユーザー作成**: 新規ユーザーアカウントの登録
3. **ユーザー編集**: 既存ユーザー情報の更新
4. **ユーザーアーカイブ**: ユーザーの論理削除（SoftDelete）
5. **ユーザー招待**: メールアドレスを指定して招待メール送信

### 2.2 処理フロー

#### ユーザー作成フロー
```
[開始]
   |
   v
[ユーザー作成画面表示]
   |
   v
[フォーム入力（名前、メール、パスワード等）]
   |
   v
[バリデーション実行]
   |
   +-- NG --> [エラー表示] --> [フォーム入力]
   |
   v (OK)
[usersテーブルにレコード作成]
   |
   v
[Partnerレコード自動作成（boot処理）]
   |
   v
[ユーザー詳細画面へリダイレクト]
   |
   v
[終了]
```

#### ユーザー招待フロー
```
[開始]
   |
   v
[招待ボタンクリック]
   |
   v
[メールアドレス入力モーダル表示]
   |
   v
[デフォルト会社設定チェック]
   |
   +-- 未設定 --> [エラー通知] --> [終了]
   |
   v (設定済)
[invitationsテーブルにレコード作成]
   |
   v
[招待メール送信]
   |
   v
[成功通知表示]
   |
   v
[終了]
```

### 2.3 入力仕様

| 入力項目 | 型 | 必須 | バリデーション | 説明 |
|----------|-----|------|---------------|------|
| name | string | YES | max:255 | ユーザー名 |
| email | string | YES | email, unique:users | メールアドレス |
| password | string | YES | min:8 | パスワード |
| language | string | NO | in:en,ja,... | 使用言語 |
| is_active | boolean | NO | - | アクティブ状態 |
| default_company_id | integer | NO | exists:companies,id | デフォルト会社 |
| resource_permission | string | NO | - | リソース権限設定 |

### 2.4 出力仕様

| 出力項目 | 型 | 説明 |
|----------|-----|------|
| id | integer | ユーザーID |
| name | string | ユーザー名 |
| email | string | メールアドレス |
| avatar_url | string | アバター画像URL（Partner経由） |
| is_active | boolean | アクティブ状態 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |
| deleted_at | datetime | 削除日時（アーカイブ時） |

## 3. ビジネスルール

| No | ルール | 説明 |
|----|--------|------|
| BR-001 | メールアドレス一意性 | メールアドレスはシステム全体で一意である必要がある |
| BR-002 | Partner自動作成 | ユーザー作成時、対応するPartnerレコードが自動作成される |
| BR-003 | Partner自動更新 | ユーザー更新時、関連Partnerレコードも同期更新される |
| BR-004 | 招待メール送信条件 | デフォルト会社が設定されている場合のみ招待メール送信可能 |
| BR-005 | 論理削除 | ユーザー削除は論理削除（SoftDelete）で行われる |

## 4. データ設計

### 4.1 使用テーブル

| テーブル名 | 用途 | 操作 |
|------------|------|------|
| users | ユーザー情報管理 | SELECT, INSERT, UPDATE, DELETE(soft) |
| partners | パートナー情報連携 | SELECT, INSERT, UPDATE |
| invitations | 招待情報管理 | SELECT, INSERT |
| companies | 会社情報参照 | SELECT |
| user_allowed_companies | ユーザー許可会社 | SELECT, INSERT, DELETE |

### 4.2 テーブル定義（users 拡張カラム）

| カラム名 | データ型 | NULL許可 | デフォルト | 説明 |
|----------|----------|----------|------------|------|
| id | bigint | NO | auto | 主キー |
| name | varchar(255) | NO | - | ユーザー名 |
| email | varchar(255) | NO | - | メールアドレス（一意） |
| password | varchar(255) | NO | - | ハッシュ化パスワード |
| partner_id | bigint | YES | NULL | パートナーID（外部キー） |
| language | varchar(10) | YES | NULL | 使用言語 |
| is_active | boolean | NO | true | アクティブフラグ |
| default_company_id | bigint | YES | NULL | デフォルト会社ID |
| resource_permission | varchar(255) | YES | NULL | リソース権限 |
| is_default | boolean | NO | false | デフォルトユーザーフラグ |
| deleted_at | timestamp | YES | NULL | 論理削除日時 |
| created_at | timestamp | YES | - | 作成日時 |
| updated_at | timestamp | YES | - | 更新日時 |

## 5. 関連コンポーネント

### 5.1 主要クラス

| クラス名 | パス | 役割 |
|----------|------|------|
| UserResource | plugins/webkul/security/src/Filament/Resources/UserResource.php | ユーザー管理Filamentリソース |
| ListUsers | plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php | ユーザー一覧・招待機能 |
| CreateUser | plugins/webkul/security/src/Filament/Resources/UserResource/Pages/CreateUser.php | ユーザー作成ページ |
| User | plugins/webkul/security/src/Models/User.php | ユーザーモデル |
| UserInvitationMail | plugins/webkul/security/src/Mail/UserInvitationMail.php | 招待メール送信 |
| Invitation | plugins/webkul/security/src/Models/Invitation.php | 招待モデル |

### 5.2 依存モジュール

| モジュール名 | 依存関係 |
|--------------|----------|
| webkul/support | 必須（Company等の基盤モデル） |
| webkul/partner | 必須（Partner連携） |
| spatie/laravel-permission | 必須（ロール管理） |
| filament/filament | 必須（管理画面UI） |

## 6. セキュリティ

### 6.1 アクセス制御

| 権限 | 説明 |
|------|------|
| view_user | ユーザー一覧・詳細の閲覧 |
| view_any_user | 全ユーザーの閲覧 |
| create_user | ユーザー作成 |
| update_user | ユーザー更新 |
| delete_user | ユーザーアーカイブ |
| restore_user | アーカイブ復元 |
| force_delete_user | 物理削除 |

### 6.2 セキュリティ考慮事項

- パスワードはBcryptによるハッシュ化保存
- 招待機能はUserSettings設定で有効/無効切り替え可能
- セッション管理によるアクセス制御

## 7. 非機能要件

### 7.1 パフォーマンス

| 項目 | 要件 |
|------|------|
| 一覧表示速度 | 1秒以内（100件まで） |
| ユーザー作成応答時間 | 2秒以内 |
| 招待メール送信 | 非同期処理推奨 |

### 7.2 可用性

- ユーザー操作はトランザクション管理により整合性を保証
- Partner同期処理の失敗時はロールバック

## 8. 例外処理

| エラーコード | エラー内容 | 対応 |
|--------------|------------|------|
| USER-001 | メールアドレス重複 | バリデーションエラー表示 |
| USER-002 | Partner作成失敗 | ロールバック、エラーログ出力 |
| USER-003 | 招待メール送信失敗 | エラー通知、ログ出力 |
| USER-004 | デフォルト会社未設定 | 招待不可エラー通知 |

## 9. テスト観点

| No | テスト項目 | 確認内容 |
|----|------------|----------|
| T-001 | 一覧表示 | ユーザー一覧が正しく表示されること |
| T-002 | タブ切り替え | 全件/アーカイブ済みタブが機能すること |
| T-003 | ユーザー作成 | 必須項目入力で正常に作成できること |
| T-004 | Partner連携 | ユーザー作成時にPartnerが自動作成されること |
| T-005 | ユーザー招待 | 招待メールが正常に送信されること |
| T-006 | アーカイブ | ユーザーが論理削除されること |
| T-007 | 復元 | アーカイブユーザーが復元できること |
| T-008 | 権限確認 | 権限のないユーザーが操作できないこと |

## 10. 改訂履歴

| 版数 | 日付 | 変更者 | 変更内容 |
|------|------|--------|----------|
| 1.0 | 2025-12-26 | 自動生成 | 初版作成 |
