# 機能設計書 F020-商品属性管理(販売)

## 概要

本ドキュメントは、AureusERPシステムにおける商品属性管理(販売)機能（salesプラグイン）の機能設計書です。

### 本機能の処理概要

商品属性管理(販売)機能は、販売業務で使用する商品属性の管理を行います。Invoiceプラグインの商品属性リソースを継承し、販売業務に特化した属性管理インターフェースを提供します。

**業務上の目的・背景**：商品にはサイズ、色、素材などの様々な属性があります。商品属性を管理することで、商品バリエーションの生成や商品情報の詳細管理を実現します。

**機能の利用シーン**：
- 新規商品属性の作成（例：サイズ、色、素材）
- 属性値の設定（例：S/M/L、赤/青/緑）
- 商品への属性割り当て
- 商品バリエーションの生成

**主要な処理内容**：
1. 商品属性の登録・編集・削除・一覧表示
2. 属性値の管理
3. 商品への属性適用

**関連システム・外部連携**：
- Invoiceプラグイン（ProductAttributeResource）の継承
- 商品管理との連携

**権限による制御**：
- 商品属性の管理は管理者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SAL-038 | ProductAttributeResource | 主画面 | 商品属性一覧表示・作成・編集・削除 |
| SCR-SAL-039 | ViewProductAttribute | 参照画面 | 商品属性詳細表示 |
| SCR-SAL-040 | EditProductAttribute | 編集画面 | 商品属性編集 |
| SCR-SAL-041 | CreateProductAttribute | 作成画面 | 商品属性作成 |

## 機能種別

マスタ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

商品属性の入力パラメータはInvoiceプラグインのProductAttributeResourceを継承しています。
主要な項目は以下の通りです。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | 属性名 | 最大255文字 |
| values | array | No | 属性値配列 | - |

### 入力データソース

- 画面入力（Filament管理パネル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | 属性ID |
| name | string | 属性名 |
| values | array | 属性値一覧 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- 画面表示
- 商品登録時の属性選択リスト

## 処理フロー

### 処理シーケンス

```
1. 属性一覧表示
   └─ 属性一覧を取得・表示
2. 属性作成
   └─ フォーム入力 → 属性値設定 → バリデーション → 保存
3. 属性編集
   └─ 既存データ取得 → フォーム編集 → 保存
4. 属性削除
   └─ 削除実行
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-020-001 | BaseProductAttributeResource継承 | InvoiceプラグインのProductAttributeResourceを継承 | 常時 |
| BR-020-002 | Configurationクラスタ所属 | 設定クラスタ配下に配置 | 常時 |
| BR-020-003 | ナビゲーション登録有効 | ナビゲーションに表示 | 常時 |
| BR-020-004 | ナビゲーションソート9 | ナビゲーション順序9番目 | 常時 |
| BR-020-005 | ナビゲーショングループ | ナビゲーショングループを設定 | 常時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 属性一覧 | product_attributes | SELECT | 一覧取得 |
| 属性作成 | product_attributes | INSERT | 新規属性挿入 |
| 属性編集 | product_attributes | UPDATE | 既存属性更新 |
| 属性削除 | product_attributes | DELETE | 削除 |
| 属性値管理 | product_attribute_values | INSERT/UPDATE/DELETE | 属性値CRUD |

### テーブル別操作詳細

#### product_attributes（Sales側はAttributeモデルとして参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | 全件取得 |
| INSERT | name, etc. | フォーム入力値 | - |
| UPDATE | 全カラム | フォーム入力値 | - |
| DELETE | - | WHERE id = ? | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-020-001 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| E-020-002 | 外部キー制約違反 | 参照先が存在しない | エラーメッセージ表示 |

## トランザクション仕様

- 属性情報の作成・更新は単一トランザクション
- 属性値の管理はEloquent Relationship経由で自動管理

## パフォーマンス要件

- 属性一覧表示: 1秒以内
- 属性作成・更新: 2秒以内

## セキュリティ考慮事項

- AttributePolicyによるアクセス制御
- CSRF対策: Laravelの標準CSRF保護を適用
- 入力値サニタイズ

## 備考

- ProductAttributeResourceはBaseProductAttributeResource（Invoice）を継承
- SalesプラグインのAttributeモデルを使用
- recordTitleAttribute = 'name'でレコードタイトルを属性名で表示
- navigationSort = 9でナビゲーション順序を設定
