# 機能設計書 F021-パッケージング管理(販売)

## 概要

本ドキュメントは、販売モジュールにおけるパッケージング管理機能の設計を定義するものです。商品の梱包単位を管理し、見積書・受注処理における包装数量の自動計算を支援します。

### 本機能の処理概要

販売用商品のパッケージング（梱包形態）情報を管理する機能です。商品ごとに複数のパッケージング単位を定義し、受注時の数量入力に応じて最適なパッケージング単位を自動選択できます。

**業務上の目的・背景**：販売業務において、商品は様々な梱包形態（単品、箱、パレット等）で取り扱われます。パッケージング管理により、顧客への見積・受注時に適切な梱包単位での数量管理が可能となり、物流効率の向上と顧客満足度の向上に寄与します。

**機能の利用シーン**：営業担当者が見積書を作成する際、商品数量を入力すると自動的に最適なパッケージング単位が選択されます。また、倉庫担当者が出荷準備を行う際の梱包計画の基礎データとして活用されます。

**主要な処理内容**：
1. パッケージング情報の登録・編集・削除
2. 商品とパッケージングの関連付け
3. 見積・受注時の最適パッケージング自動選択
4. パッケージング単位での数量変換計算

**関連システム・外部連携**：在庫管理モジュールと連携し、パッケージング単位での在庫管理が可能。また、商品マスタ（Productsプラグイン）のPackagingモデルを継承しています。

**権限による制御**：パッケージング管理機能の表示・編集はProductSettings設定（enable_packagings）によって制御されます。無効の場合、ナビゲーションに表示されません。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-SALES-011 | PackagingResource | 主画面 | パッケージング一覧表示・作成・編集・削除 |
| SCR-SALES-001 | QuotationResource | 参照画面 | 見積書作成時のパッケージング選択 |
| SCR-SALES-002 | OrderResource | 参照画面 | 受注時のパッケージング選択 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | パッケージング名 | 最大255文字 |
| qty | decimal | Yes | 数量（1パッケージあたりの商品数） | 正の数値 |
| product_id | integer | Yes | 対象商品ID | 存在する商品ID |
| barcode | string | No | バーコード | 最大255文字 |

### 入力データソース

- 画面入力（Filament管理画面のフォーム）
- 商品マスタからの商品情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | integer | パッケージングID |
| name | string | パッケージング名 |
| qty | decimal | 数量 |
| product_id | integer | 商品ID |
| barcode | string | バーコード |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- データベーステーブル（products_packagings）
- 画面表示（一覧・詳細画面）

## 処理フロー

### 処理シーケンス

```
1. パッケージング一覧表示
   └─ ManagePackagingsページで一覧を表示
2. パッケージング作成
   └─ フォーム入力 → バリデーション → DBへ保存
3. パッケージング編集
   └─ 既存データ読込 → フォーム編集 → バリデーション → DB更新
4. パッケージング削除
   └─ 削除確認 → DB削除
5. 見積・受注での利用
   └─ 商品数量入力 → 最適パッケージング検索 → 自動選択
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧表示| C[DBからパッケージング取得]
    B -->|作成| D[フォーム入力]
    B -->|編集| E[既存データ読込]
    B -->|削除| F[削除確認ダイアログ]
    C --> G[一覧表示]
    D --> H{バリデーション}
    E --> D
    H -->|OK| I[DBへ保存]
    H -->|NG| D
    F -->|確認| J[DB削除]
    F -->|キャンセル| G
    I --> G
    J --> G
    G --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-021-01 | パッケージング有効化 | ProductSettings.enable_packagingsがtrueの場合のみ機能が有効 | 常時 |
| BR-021-02 | 最適パッケージング選択 | 商品数量を割り切れるパッケージングのうち、最大数量のものを優先選択 | 見積・受注時 |
| BR-021-03 | 数量変換 | パッケージング数量 × パッケージ数 = 商品数量 | 数量計算時 |

### 計算ロジック

```
最適パッケージング選択:
1. 商品に紐づくパッケージングを数量降順で取得
2. 商品数量 % パッケージング数量 == 0 となる最初のパッケージングを選択
3. パッケージ数 = 商品数量 / パッケージング数量
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | products_packagings | SELECT | パッケージング一覧取得 |
| 作成 | products_packagings | INSERT | 新規パッケージング登録 |
| 編集 | products_packagings | UPDATE | パッケージング情報更新 |
| 削除 | products_packagings | DELETE | パッケージング削除 |

### テーブル別操作詳細

#### products_packagings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name, qty, product_id, barcode | フォーム入力値 | 作成時 |
| UPDATE | name, qty, barcode | フォーム入力値 | 編集時 |
| DELETE | - | id指定 | 物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E021-01 | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、再入力促す |
| E021-02 | 整合性エラー | 存在しない商品ID指定 | エラーメッセージ表示 |
| E021-03 | 削除エラー | 使用中のパッケージング削除 | エラーメッセージ表示、削除不可 |

### リトライ仕様

該当なし（同期処理のため）

## トランザクション仕様

- 作成・編集・削除はそれぞれ個別のトランザクションで実行
- Laravelのデフォルトトランザクション管理を使用

## パフォーマンス要件

- 一覧表示：1秒以内
- 作成・編集・削除：2秒以内

## セキュリティ考慮事項

- Filament Shieldによる権限制御
- CSRF保護（Filament標準機能）
- 入力値のサニタイズ（Laravelバリデーション）

## 備考

- 本機能はWebkul\Product\Filament\Resources\PackagingResourceを継承
- Webkul\Sale\Models\PackagingモデルはWebkul\Product\Models\Packagingを継承
- 設定（ProductSettings）によって機能の有効/無効を切り替え可能
